/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkTag
implements ObjectTag,
Adjustable {
    int chunkX;
    int chunkZ;
    WorldTag world;
    Chunk cachedChunk;
    String prefix = "Chunk";
    public static ObjectTagProcessor<ChunkTag> tagProcessor = new ObjectTagProcessor();

    public static ChunkTag valueOf(String string) {
        return ChunkTag.valueOf(string, null);
    }

    @Fetchable(value="ch")
    public static ChunkTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String[] parts = (string = CoreUtilities.toLowerCase(string).replace("ch@", "")).split(",");
        if (parts.length == 3) {
            try {
                return new ChunkTag(WorldTag.valueOf(parts[2], context), Integer.valueOf(parts[0]), Integer.valueOf(parts[1]));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf ChunkTag returning null: ch@" + string);
                }
                return null;
            }
        }
        if (context == null || context.debug) {
            Debug.log("Minor: valueOf ChunkTag unable to handle malformed format: ch@" + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        return CoreUtilities.toLowerCase(string).startsWith("ch@");
    }

    public Chunk getChunkForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (!this.isLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Cannot get chunk at " + this.chunkX + ", " + this.chunkZ + ": Chunk is not loaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Chunk chunk = null;
                return chunk;
            }
            Chunk chunk = this.getChunk();
            return chunk;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Chunk getChunk() {
        if (this.cachedChunk == null) {
            this.cachedChunk = this.world.getWorld().getChunkAt(this.chunkX, this.chunkZ);
        }
        return this.cachedChunk;
    }

    public ChunkTag(Chunk chunk) {
        this.cachedChunk = chunk;
        this.world = new WorldTag(chunk.getWorld());
        this.chunkX = chunk.getX();
        this.chunkZ = chunk.getZ();
    }

    public ChunkTag(WorldTag world, int x, int z) {
        this.world = world;
        this.chunkX = x;
        this.chunkZ = z;
    }

    public ChunkTag(Location location) {
        this.world = new WorldTag(location.getWorld());
        this.chunkX = location.getBlockX() >> 4;
        this.chunkZ = location.getBlockZ() >> 4;
    }

    public LocationTag getCenter() {
        return new LocationTag(this.getWorld(), this.getX() * 16 + 8, 128.0, this.getZ() * 16 + 8);
    }

    public int getX() {
        return this.chunkX;
    }

    public int getZ() {
        return this.chunkZ;
    }

    public World getWorld() {
        return this.world.getWorld();
    }

    @Override
    public String getObjectType() {
        return "Chunk";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ChunkTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "ch@" + this.getX() + ',' + this.getZ() + ',' + this.getWorld().getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public boolean isLoaded() {
        return this.world.getWorld().isChunkLoaded(this.chunkX, this.chunkZ);
    }

    public boolean isLoadedSafe() {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
            boolean bl = this.isLoaded();
            return bl;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public static void registerTags() {
        ChunkTag.registerTag("add", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ChunkTag.add[<#>,<#>] must have a value.");
                    return null;
                }
                List<String> coords = CoreUtilities.split(attribute.getContext(1), ',');
                if (coords.size() < 2) {
                    Debug.echoError("The tag ChunkTag.add[<#>,<#>] requires two values!");
                    return null;
                }
                int x = ArgumentHelper.getIntegerFrom(coords.get(0));
                int z = ArgumentHelper.getIntegerFrom(coords.get(1));
                ChunkTag chunk = object;
                return new ChunkTag(chunk.world, chunk.chunkX + x, chunk.chunkZ + z);
            }
        });
        ChunkTag.registerTag("sub", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ChunkTag.add[<#>,<#>] must have a value.");
                    return null;
                }
                List<String> coords = CoreUtilities.split(attribute.getContext(1), ',');
                if (coords.size() < 2) {
                    Debug.echoError("The tag ChunkTag.sub[<#>,<#>] requires two values!");
                    return null;
                }
                int x = ArgumentHelper.getIntegerFrom(coords.get(0));
                int z = ArgumentHelper.getIntegerFrom(coords.get(1));
                ChunkTag chunk = object;
                return new ChunkTag(chunk.world, chunk.chunkX - x, chunk.chunkZ - z);
            }
        });
        ChunkTag.registerTag("is_loaded", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                return new ElementTag(object.isLoadedSafe());
            }
        });
        ChunkTag.registerTag("x", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                return new ElementTag(object.chunkX);
            }
        });
        ChunkTag.registerTag("z", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                return new ElementTag(object.chunkZ);
            }
        });
        ChunkTag.registerTag("world", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                return object.world;
            }
        });
        ChunkTag.registerTag("cuboid", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                ChunkTag chunk = object;
                return new CuboidTag(new Location(chunk.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16)), new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 15), 255.0, (double)(chunk.getZ() * 16 + 15)));
            }
        });
        ChunkTag.registerTag("tile_entities", new TagRunnable.ObjectForm<ChunkTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                ListTag tiles = new ListTag();
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                    for (BlockState block : chunk.getTileEntities()) {
                        tiles.addObject(new LocationTag(block.getLocation()));
                    }
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                }
                return tiles;
            }
        });
        ChunkTag.registerTag("entities", new TagRunnable.ObjectForm<ChunkTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                ListTag entities = new ListTag();
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                    for (Entity ent : chunk.getEntities()) {
                        entities.addObject(new EntityTag(ent).getDenizenObject());
                    }
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                }
                return entities;
            }
        });
        ChunkTag.registerTag("living_entities", new TagRunnable.ObjectForm<ChunkTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                ListTag entities = new ListTag();
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                    for (Entity ent : chunk.getEntities()) {
                        if (!(ent instanceof LivingEntity)) continue;
                        entities.addObject(new EntityTag(ent).getDenizenObject());
                    }
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                }
                return entities;
            }
        });
        ChunkTag.registerTag("players", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                ListTag entities = new ListTag();
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                for (Entity ent : chunk.getEntities()) {
                    if (!EntityTag.isPlayer(ent)) continue;
                    entities.addObject(new PlayerTag((Player)ent));
                }
                return entities;
            }
        });
        ChunkTag.registerTag("height_map", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                int[] heightMap = NMSHandler.getChunkHelper().getHeightMap(chunk);
                ArrayList<String> height_map = new ArrayList<String>(heightMap.length);
                for (int i : heightMap) {
                    height_map.add(String.valueOf(i));
                }
                return new ListTag((List<String>)height_map);
            }
        });
        ChunkTag.registerTag("average_height", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                int[] heightMap = NMSHandler.getChunkHelper().getHeightMap(chunk);
                int sum = 0;
                for (int i : heightMap) {
                    sum += i;
                }
                return new ElementTag((double)sum / (double)heightMap.length);
            }
        });
        ChunkTag.registerTag("is_flat", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                int[] heightMap = NMSHandler.getChunkHelper().getHeightMap(chunk);
                int tolerance = attribute.hasContext(1) ? ArgumentHelper.getIntegerFrom(attribute.getContext(1)) : 2;
                int x = heightMap[0];
                for (int i : heightMap) {
                    if (Math.abs(x - i) <= tolerance) continue;
                    return new ElementTag(false);
                }
                return new ElementTag(true);
            }
        });
        ChunkTag.registerTag("surface_blocks", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                ListTag surface_blocks = new ListTag();
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                ChunkSnapshot snapshot = chunk.getChunkSnapshot();
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        surface_blocks.add(new LocationTag(chunk.getBlock(x, snapshot.getHighestBlockYAt(x, z) - 1, z).getLocation()).identify());
                    }
                }
                return surface_blocks;
            }
        });
        ChunkTag.registerTag("spawn_slimes", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                Chunk chunk = object.getChunkForTag(attribute);
                if (chunk == null) {
                    return null;
                }
                return new ElementTag(chunk.isSlimeChunk());
            }
        });
        ChunkTag.registerTag("type", new TagRunnable.ObjectForm<ChunkTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ChunkTag object) {
                return new ElementTag("Chunk");
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm<ChunkTag> runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a chunk!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("unload")) {
            this.getChunk().unload(true);
        }
        if (mechanism.matches("unload_safely")) {
            Debug.echoError("Mechanism 'dChunk.unload_safely' is not valid: It is never safe to remove a chunk in use.");
            this.getChunk().unload(true);
        }
        if (mechanism.matches("unload_without_saving")) {
            this.getChunk().unload(false);
        }
        if (mechanism.matches("load")) {
            this.getChunk().load(true);
        }
        if (mechanism.matches("regenerate")) {
            this.getWorld().regenerateChunk(this.getX(), this.getZ());
        }
        if (mechanism.matches("refresh_chunk")) {
            final int chunkX = this.getX();
            final int chunkZ = this.getZ();
            this.getWorld().refreshChunk(chunkX, chunkZ);
            new BukkitRunnable(){

                public void run() {
                    for (Map<Location, FakeBlock> blocks : FakeBlock.getBlocks().values()) {
                        for (Map.Entry<Location, FakeBlock> locBlock : blocks.entrySet()) {
                            Location location = locBlock.getKey();
                            if (Math.floor(location.getX() / 16.0) != (double)chunkX || Math.floor(location.getZ() / 16.0) != (double)chunkZ) continue;
                            locBlock.getValue().updateBlock();
                        }
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 2L);
        }
        if (mechanism.matches("refresh_chunk_sections")) {
            NMSHandler.getChunkHelper().refreshChunkSections(this.getChunk());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

