/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CuboidTag
implements ObjectTag,
Cloneable,
Notable,
Adjustable {
    static final Pattern cuboid_by_saved = Pattern.compile("(cu@)?(.+)");
    static final Pattern cuboidLocations = Pattern.compile("(\\|?([-\\d\\.]+,){3}[\\w\\s]+\\|([-\\d\\.]+,){3}[\\w\\s]+)+", 2);
    public List<LocationPair> pairs = new ArrayList<LocationPair>();
    ArrayList<ObjectTag> filter = new ArrayList();
    String prefix = "Cuboid";
    public static ObjectTagProcessor<CuboidTag> tagProcessor = new ObjectTagProcessor();

    public CuboidTag clone() throws CloneNotSupportedException {
        CuboidTag cuboid = (CuboidTag)super.clone();
        cuboid.pairs = new ArrayList<LocationPair>(this.pairs.size());
        for (LocationPair pair : this.pairs) {
            cuboid.pairs.add(new LocationPair(pair.point_1.clone(), pair.point_2.clone()));
        }
        cuboid.filter = new ArrayList<ObjectTag>(this.filter);
        return cuboid;
    }

    public static List<CuboidTag> getNotableCuboidsContaining(Location location) {
        ArrayList<CuboidTag> cuboids = new ArrayList<CuboidTag>();
        for (CuboidTag cuboid : NotableManager.getAllType(CuboidTag.class)) {
            if (!cuboid.isInsideCuboid(location)) continue;
            cuboids.add(cuboid);
        }
        return cuboids;
    }

    public static CuboidTag valueOf(String string) {
        return CuboidTag.valueOf(string, null);
    }

    @Fetchable(value="cu")
    public static CuboidTag valueOf(String string, TagContext context) {
        Matcher m;
        if (string == null) {
            return null;
        }
        ListTag positions = ListTag.valueOf(string.replace("cu@", ""));
        if (positions.size() > 1 && LocationTag.matches((String)positions.get(0)) && LocationTag.matches((String)positions.get(1))) {
            if (positions.size() % 2 != 0) {
                if (context == null || context.debug) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null (Uneven number of locations): '" + string + "'.");
                }
                return null;
            }
            CuboidTag toReturn = new CuboidTag();
            for (int i = 0; i < positions.size(); i += 2) {
                LocationTag pos_1 = LocationTag.valueOf((String)positions.get(i));
                LocationTag pos_2 = LocationTag.valueOf((String)positions.get(i + 1));
                if (pos_1 == null || pos_2 == null) {
                    if (context == null || context.debug) {
                        com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf in CuboidTag returning null (null locations): '" + string + "'.");
                    }
                    return null;
                }
                if (pos_1.getWorldName() == null || pos_2.getWorldName() == null) {
                    if (context == null || context.debug) {
                        com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf in CuboidTag returning null (null worlds): '" + string + "'.");
                    }
                    return null;
                }
                toReturn.addPair(pos_1, pos_2);
            }
            if (toReturn.pairs.size() > 0) {
                return toReturn;
            }
        }
        if ((m = cuboid_by_saved.matcher(string)).matches() && NotableManager.isType(m.group(2), CuboidTag.class)) {
            return (CuboidTag)NotableManager.getSavedObject(m.group(2));
        }
        if (context == null || context.debug) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("cu@")) {
            return true;
        }
        Matcher m = cuboid_by_saved.matcher(string);
        if (m.matches() && NotableManager.isType(m.group(2), CuboidTag.class)) {
            return true;
        }
        m = cuboidLocations.matcher(string.replace("cu@", ""));
        return m.matches();
    }

    public CuboidTag() {
    }

    public CuboidTag(Location point_1, Location point_2) {
        this.addPair(point_1, point_2);
    }

    public void addPair(Location point_1, Location point_2) {
        if (point_1.getWorld() != point_2.getWorld()) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Tried to make cross-world cuboid!");
            return;
        }
        if (this.pairs.size() > 0 && point_1.getWorld() != this.getWorld()) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Tried to make cross-world cuboid set!");
            return;
        }
        LocationPair pair = new LocationPair(new LocationTag(point_1), new LocationTag(point_2));
        this.pairs.add(pair);
    }

    public boolean isInsideCuboid(Location location) {
        for (LocationPair pair : this.pairs) {
            if (!location.getWorld().equals(pair.low.getWorld()) || !Utilities.isBetween(pair.low.getBlockX(), pair.high.getBlockX() + 1, location.getBlockX()) || !Utilities.isBetween(pair.low.getBlockY(), pair.high.getBlockY() + 1, location.getBlockY()) || !Utilities.isBetween(pair.low.getBlockZ(), pair.high.getBlockZ() + 1, location.getBlockZ())) continue;
            return true;
        }
        return false;
    }

    public CuboidTag addBlocksToFilter(List<MaterialTag> addl) {
        this.filter.addAll(addl);
        return this;
    }

    public CuboidTag removeBlocksFromFilter(List<MaterialTag> addl) {
        this.filter.removeAll(addl);
        return this;
    }

    public CuboidTag removeFilter() {
        this.filter.clear();
        return this;
    }

    public CuboidTag setAsFilter(List<MaterialTag> list) {
        this.filter.clear();
        this.filter.addAll(list);
        return this;
    }

    public ListTag getShell() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            int z;
            LocationTag low = pair.low;
            LocationTag high = pair.high;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x < x_distance; ++x) {
                for (int y = 0; y < y_distance; ++y) {
                    list.addObject(new LocationTag(low.getWorld(), low.getBlockX() + x, low.getBlockY() + y, low.getBlockZ()));
                    list.addObject(new LocationTag(low.getWorld(), low.getBlockX() + x, low.getBlockY() + y, high.getBlockZ()));
                    if (++index <= max) continue;
                    return list;
                }
                for (z = 0; z < z_distance; ++z) {
                    list.addObject(new LocationTag(low.getWorld(), low.getBlockX() + x, low.getBlockY(), low.getBlockZ() + z));
                    list.addObject(new LocationTag(low.getWorld(), low.getBlockX() + x, high.getBlockY(), low.getBlockZ() + z));
                    if (++index <= max) continue;
                    return list;
                }
            }
            for (int y = 0; y < y_distance; ++y) {
                for (z = 0; z < z_distance; ++z) {
                    list.addObject(new LocationTag(low.getWorld(), low.getBlockX(), low.getBlockY() + y, low.getBlockZ() + z));
                    list.addObject(new LocationTag(low.getWorld(), high.getBlockX(), low.getBlockY() + y, low.getBlockZ() + z));
                    if (++index <= max) continue;
                    return list;
                }
            }
        }
        return list;
    }

    public ListTag getOutline() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            LocationTag loc_2 = pair.high;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int y = loc_1.getBlockY(); y < loc_1.getBlockY() + y_distance; ++y) {
                list.addObject(new LocationTag(loc_1.getWorld(), loc_1.getBlockX(), y, loc_1.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), loc_2.getBlockX(), y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), loc_1.getBlockX(), y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), loc_2.getBlockX(), y, loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int x = loc_1.getBlockX(); x < loc_1.getBlockX() + x_distance; ++x) {
                list.addObject(new LocationTag(loc_1.getWorld(), x, loc_1.getBlockY(), loc_1.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), x, loc_1.getBlockY(), loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), x, loc_2.getBlockY(), loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), x, loc_2.getBlockY(), loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int z = loc_1.getBlockZ(); z < loc_1.getBlockZ() + z_distance; ++z) {
                list.addObject(new LocationTag(loc_1.getWorld(), loc_1.getBlockX(), loc_1.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), loc_2.getBlockX(), loc_2.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), loc_1.getBlockX(), loc_2.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), loc_2.getBlockX(), loc_1.getBlockY(), z));
                if (++index <= max) continue;
                return list;
            }
            list.add(pair.high.identify());
        }
        return list;
    }

    public ListTag getBlocks(Attribute attribute) {
        return this.getBlocks(null, attribute);
    }

    private boolean matchesMaterialList(Location loc, List<MaterialTag> materials, Attribute attribute) {
        if (materials == null) {
            return true;
        }
        MaterialTag mat = new MaterialTag(new LocationTag(loc).getBlockForTag(attribute));
        for (MaterialTag material : materials) {
            if (!mat.equals(material) && mat.getMaterial() != material.getMaterial()) continue;
            return true;
        }
        return false;
    }

    public ListTag getBlocks(List<MaterialTag> materials, Attribute attribute) {
        List<LocationTag> locs = this.getBlocks_internal(materials, attribute);
        ListTag list = new ListTag();
        for (LocationTag loc : locs) {
            list.add(loc.identify());
        }
        return list;
    }

    public List<LocationTag> getBlocks_internal(List<MaterialTag> materials, Attribute attribute) {
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        if (loc.getY() < 0.0 || loc.getY() > 255.0) continue;
                        if (!this.filter.isEmpty()) {
                            for (ObjectTag material : this.filter) {
                                if (!((MaterialTag)material).matchesBlock(loc.getBlockForTag(attribute)) || !this.matchesMaterialList(loc, materials, attribute)) continue;
                                list.add(loc);
                            }
                        } else if (this.matchesMaterialList(loc, materials, attribute)) {
                            list.add(loc);
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public void setBlocks_internal(List<BlockData> materials) {
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        if (loc_1.getY() + (double)y >= 0.0 && loc_1.getY() + (double)y < 256.0) {
                            materials.get(index).setBlock(loc_1.clone().add(x, y, z).getBlock(), false);
                        }
                        ++index;
                    }
                }
            }
        }
    }

    public BlockData getBlockAt(double nX, double nY, double nZ, List<BlockData> materials) {
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        if ((double)x == nX && nY == (double)y && (double)z == nZ) {
                            return materials.get(index);
                        }
                        ++index;
                    }
                }
            }
        }
        return null;
    }

    public List<LocationTag> getBlockLocationsUnfiltered() {
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int z = 0; z != z_distance + 1; ++z) {
                    for (int y = 0; y != y_distance + 1; ++y) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        list.add(loc);
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public List<LocationTag> getBlockLocations(Attribute attribute) {
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int z = 0; z != z_distance + 1; ++z) {
                    for (int y = 0; y != y_distance + 1; ++y) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        if (!this.filter.isEmpty()) {
                            for (ObjectTag material : this.filter) {
                                if (!loc.getBlockTypeForTag(attribute).name().equalsIgnoreCase(((MaterialTag)material).getMaterial().name())) continue;
                                list.add(loc);
                            }
                        } else {
                            list.add(loc);
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public ListTag getSpawnableBlocks(Attribute attribute) {
        return this.getSpawnableBlocks(null, attribute);
    }

    public ListTag getSpawnableBlocks(List<MaterialTag> mats, Attribute attribute) {
        int max = Settings.blockTagsMaxBlocks();
        ListTag list = new ListTag();
        int index = 0;
        BlockHelper blockHelper = NMSHandler.getBlockHelper();
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        if (blockHelper.isSafeBlock(loc.getBlockTypeForTag(attribute)) && blockHelper.isSafeBlock(new LocationTag(loc.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute)) && new LocationTag(loc.clone().add(0.0, -1.0, 0.0)).getBlockTypeForTag(attribute).isSolid() && this.matchesMaterialList(loc.clone().add(0.0, -1.0, 0.0), mats, attribute)) {
                            loc.add(0.5, 0.0, 0.5);
                            list.add(loc.identify());
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public World getWorld() {
        if (this.pairs.size() == 0) {
            return null;
        }
        return this.pairs.get((int)0).high.getWorld();
    }

    public LocationTag getHigh(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).high;
    }

    public LocationTag getLow(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).low;
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="Cuboids")
    public String getSaveObject() {
        return this.identifyFull().substring(3);
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "cuboid";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public CuboidTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this) + " <GR>(" + this.identifyFull() + ")";
        }
        return this.identifyFull();
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this);
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        StringBuilder sb = new StringBuilder();
        sb.append("cu@");
        for (LocationPair pair : this.pairs) {
            if (pair.low.getWorld() == null || pair.high.getWorld() == null) {
                com.denizenscript.denizen.utilities.debugging.Debug.echoError("Null world for cuboid, returning invalid identity!");
                return "cu@null";
            }
            sb.append(pair.low.getBlockX()).append(',').append(pair.low.getBlockY()).append(',').append(pair.low.getBlockZ()).append(',').append(pair.low.getWorld().getName()).append('|').append(pair.high.getBlockX()).append(',').append(pair.high.getBlockY()).append(',').append(pair.high.getBlockZ()).append(',').append(pair.high.getWorld().getName()).append('|');
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        CuboidTag.registerTag("blocks", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (attribute.hasContext(1)) {
                    return new ListTag(object.getBlocks(ListTag.valueOf(attribute.getContext(1)).filter(MaterialTag.class, attribute.context), attribute));
                }
                return new ListTag(object.getBlocks(attribute));
            }
        });
        CuboidTag.registerTag("get_blocks", CuboidTag.tagProcessor.registeredObjectTags.get("blocks"));
        CuboidTag.registerTag("members_size", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                return new ElementTag(object.pairs.size());
            }
        });
        CuboidTag.registerTag("spawnable_blocks", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (attribute.hasContext(1)) {
                    return new ListTag(object.getSpawnableBlocks(ListTag.valueOf(attribute.getContext(1)).filter(MaterialTag.class, attribute.context), attribute));
                }
                return new ListTag(object.getSpawnableBlocks(attribute));
            }
        });
        CuboidTag.registerTag("get_spawnable_blocks", CuboidTag.tagProcessor.registeredObjectTags.get("spawnable_blocks"));
        CuboidTag.registerTag("shell", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                return object.getShell();
            }
        });
        CuboidTag.registerTag("outline", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                return object.getOutline();
            }
        });
        CuboidTag.registerTag("get_outline", CuboidTag.tagProcessor.registeredObjectTags.get("outline"));
        CuboidTag.registerTag("filter", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                return new ListTag((Collection<? extends ObjectTag>)object.filter);
            }
        });
        CuboidTag.registerTag("intersects", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.intersects[...] must have a value.");
                    return null;
                }
                CuboidTag cub2 = CuboidTag.valueOf(attribute.getContext(1));
                if (cub2 != null) {
                    boolean intersects = false;
                    block0: for (LocationPair pair : object.pairs) {
                        for (LocationPair pair2 : cub2.pairs) {
                            if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                                return new ElementTag("false");
                            }
                            if (!(pair2.low.getX() <= pair.high.getX()) || !(pair2.low.getY() <= pair.high.getY()) || !(pair2.low.getZ() <= pair.high.getZ()) || !(pair2.high.getX() >= pair.low.getX()) || !(pair2.high.getY() >= pair.low.getY()) || !(pair2.high.getZ() >= pair.low.getZ())) continue;
                            intersects = true;
                            break block0;
                        }
                    }
                    return new ElementTag(intersects);
                }
                return null;
            }
        });
        CuboidTag.registerTag("contains_location", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.contains_location[...] must have a value.");
                    return null;
                }
                LocationTag loc = LocationTag.valueOf(attribute.getContext(1));
                return new ElementTag(object.isInsideCuboid(loc));
            }
        });
        CuboidTag.registerTag("is_within", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.is_within[...] must have a value.");
                    return null;
                }
                CuboidTag cub2 = CuboidTag.valueOf(attribute.getContext(1));
                if (cub2 != null) {
                    boolean contains = true;
                    for (LocationPair pair2 : object.pairs) {
                        boolean contained = false;
                        for (LocationPair pair : cub2.pairs) {
                            if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                                if (Debug.verbose) {
                                    com.denizenscript.denizen.utilities.debugging.Debug.log("Worlds don't match!");
                                }
                                return new ElementTag("false");
                            }
                            if (!(pair2.low.getX() >= pair.low.getX()) || !(pair2.low.getY() >= pair.low.getY()) || !(pair2.low.getZ() >= pair.low.getZ()) || !(pair2.high.getX() <= pair.high.getX()) || !(pair2.high.getY() <= pair.high.getY()) || !(pair2.high.getZ() <= pair.high.getZ())) continue;
                            contained = true;
                            break;
                        }
                        if (contained) continue;
                        contains = false;
                        break;
                    }
                    return new ElementTag(contains);
                }
                return null;
            }
        });
        CuboidTag.registerTag("list_members", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                List<LocationPair> pairs = object.pairs;
                ListTag list = new ListTag();
                for (LocationPair pair : pairs) {
                    list.addObject(new CuboidTag(pair.low, pair.high));
                }
                return list;
            }
        });
        CuboidTag.registerTag("get", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.get[...] must have a value.");
                    return null;
                }
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > object.pairs.size()) {
                    member = object.pairs.size();
                }
                LocationPair pair = object.pairs.get(member - 1);
                return new CuboidTag(pair.point_1, pair.point_2);
            }
        });
        CuboidTag.registerTag("member", CuboidTag.tagProcessor.registeredObjectTags.get("get"));
        CuboidTag.registerTag("get_member", CuboidTag.tagProcessor.registeredObjectTags.get("get"));
        CuboidTag.registerTag("set", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.set[...] must have a value.");
                    return null;
                }
                CuboidTag subCuboid = CuboidTag.valueOf(attribute.getContext(1));
                if (!attribute.startsWith("at", 2)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.set[...] must be followed by an 'at'.");
                    return null;
                }
                if (!attribute.hasContext(2)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.set[...].at[...] must have an 'at' value.");
                    return null;
                }
                int member = attribute.getIntContext(2);
                if (member < 1) {
                    member = 1;
                }
                if (member > object.pairs.size()) {
                    member = object.pairs.size();
                }
                attribute.fulfill(1);
                LocationPair pair = subCuboid.pairs.get(0);
                try {
                    CuboidTag cloned = object.clone();
                    cloned.pairs.set(member - 1, new LocationPair(pair.point_1, pair.point_2));
                    return cloned;
                }
                catch (CloneNotSupportedException ex) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
                    return null;
                }
            }
        });
        CuboidTag.registerTag("add", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                CuboidTag cuboid;
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.add[...] must have a value.");
                    return null;
                }
                try {
                    cuboid = object.clone();
                }
                catch (CloneNotSupportedException ex) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
                    return null;
                }
                CuboidTag subCuboid = CuboidTag.valueOf(attribute.getContext(1));
                int member = cuboid.pairs.size() + 1;
                if (attribute.startsWith("at", 2)) {
                    if (!attribute.hasContext(2)) {
                        com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.add[...].at[...] must have an 'at' value.");
                        return null;
                    }
                    member = attribute.getIntContext(2);
                    attribute.fulfill(1);
                }
                if (member < 1) {
                    member = 1;
                }
                if (member > cuboid.pairs.size() + 1) {
                    member = cuboid.pairs.size() + 1;
                }
                LocationPair pair = subCuboid.pairs.get(0);
                cuboid.pairs.add(member - 1, new LocationPair(pair.point_1, pair.point_2));
                return cuboid;
            }
        });
        CuboidTag.registerTag("center", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                LocationPair pair;
                if (!attribute.hasContext(1)) {
                    pair = object.pairs.get(0);
                } else {
                    int member = attribute.getIntContext(1);
                    if (member < 1) {
                        member = 1;
                    }
                    if (member > object.pairs.size()) {
                        member = object.pairs.size();
                    }
                    pair = object.pairs.get(member - 1);
                }
                Location base = pair.high.clone().add(pair.low.clone()).add(1.0, 1.0, 1.0);
                base.setX(base.getX() / 2.0);
                base.setY(base.getY() / 2.0);
                base.setZ(base.getZ() / 2.0);
                return new LocationTag(base);
            }
        });
        CuboidTag.registerTag("volume", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                LocationPair pair = object.pairs.get(0);
                Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
                return new ElementTag(base.getX() * base.getY() * base.getZ());
            }
        });
        CuboidTag.registerTag("size", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                LocationPair pair;
                if (!attribute.hasContext(1)) {
                    pair = object.pairs.get(0);
                } else {
                    int member = attribute.getIntContext(1);
                    if (member < 1) {
                        member = 1;
                    }
                    if (member > object.pairs.size()) {
                        member = object.pairs.size();
                    }
                    pair = object.pairs.get(member - 1);
                }
                Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
                return new LocationTag(base);
            }
        });
        CuboidTag.registerTag("max", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    return object.pairs.get((int)0).high;
                }
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > object.pairs.size()) {
                    member = object.pairs.size();
                }
                return object.pairs.get((int)(member - 1)).high;
            }
        });
        CuboidTag.registerTag("min", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    return object.pairs.get((int)0).low;
                }
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > object.pairs.size()) {
                    member = object.pairs.size();
                }
                return object.pairs.get((int)(member - 1)).low;
            }
        });
        CuboidTag.registerTag("include", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.include[...] must have a value.");
                    return null;
                }
                try {
                    LocationTag loc = LocationTag.valueOf(attribute.getContext(1));
                    CuboidTag cuboid = object.clone();
                    if (loc != null) {
                        if (loc.getX() < cuboid.pairs.get((int)0).low.getX()) {
                            cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), loc.getX(), cuboid.pairs.get((int)0).low.getY(), cuboid.pairs.get((int)0).low.getZ());
                        }
                        if (loc.getY() < cuboid.pairs.get((int)0).low.getY()) {
                            cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), loc.getY(), cuboid.pairs.get((int)0).low.getZ());
                        }
                        if (loc.getZ() < cuboid.pairs.get((int)0).low.getZ()) {
                            cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), cuboid.pairs.get((int)0).low.getY(), loc.getZ());
                        }
                        if (loc.getX() > cuboid.pairs.get((int)0).high.getX()) {
                            cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), loc.getX(), cuboid.pairs.get((int)0).high.getY(), cuboid.pairs.get((int)0).high.getZ());
                        }
                        if (loc.getY() > cuboid.pairs.get((int)0).high.getY()) {
                            cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), loc.getY(), cuboid.pairs.get((int)0).high.getZ());
                        }
                        if (loc.getZ() > cuboid.pairs.get((int)0).high.getZ()) {
                            cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), cuboid.pairs.get((int)0).high.getY(), loc.getZ());
                        }
                        return cuboid;
                    }
                }
                catch (CloneNotSupportedException ex) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
                }
                return null;
            }
        });
        CuboidTag.registerTag("include_x", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.include_x[...] must have a value.");
                    return null;
                }
                try {
                    double x = attribute.getDoubleContext(1);
                    CuboidTag cuboid = object.clone();
                    if (x < cuboid.pairs.get((int)0).low.getX()) {
                        cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), x, cuboid.pairs.get((int)0).low.getY(), cuboid.pairs.get((int)0).low.getZ());
                    }
                    if (x > cuboid.pairs.get((int)0).high.getX()) {
                        cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), x, cuboid.pairs.get((int)0).high.getY(), cuboid.pairs.get((int)0).high.getZ());
                    }
                    return cuboid;
                }
                catch (CloneNotSupportedException ex) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
                    return null;
                }
            }
        });
        CuboidTag.registerTag("include_y", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.include_y[...] must have a value.");
                    return null;
                }
                try {
                    double y = attribute.getDoubleContext(1);
                    CuboidTag cuboid = object.clone();
                    if (y < cuboid.pairs.get((int)0).low.getY()) {
                        cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), y, cuboid.pairs.get((int)0).low.getZ());
                    }
                    if (y > cuboid.pairs.get((int)0).high.getY()) {
                        cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), y, cuboid.pairs.get((int)0).high.getZ());
                    }
                    return cuboid;
                }
                catch (CloneNotSupportedException ex) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
                    return null;
                }
            }
        });
        CuboidTag.registerTag("include_z", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.include_z[...] must have a value.");
                    return null;
                }
                try {
                    double z = attribute.getDoubleContext(1);
                    CuboidTag cuboid = object.clone();
                    if (z < cuboid.pairs.get((int)0).low.getZ()) {
                        cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), cuboid.pairs.get((int)0).low.getY(), z);
                    }
                    if (z > cuboid.pairs.get((int)0).high.getZ()) {
                        cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), cuboid.pairs.get((int)0).high.getY(), z);
                    }
                    return cuboid;
                }
                catch (CloneNotSupportedException ex) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
                    return null;
                }
            }
        });
        CuboidTag.registerTag("with_min", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.with_min[...] must have a value.");
                    return null;
                }
                CuboidTag cuboid = object;
                LocationTag location = LocationTag.valueOf(attribute.getContext(1));
                return new CuboidTag(location, cuboid.pairs.get((int)0).high);
            }
        });
        CuboidTag.registerTag("with_max", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                if (!attribute.hasContext(1)) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("The tag CuboidTag.with_max[...] must have a value.");
                    return null;
                }
                CuboidTag cuboid = object;
                LocationTag location = LocationTag.valueOf(attribute.getContext(1));
                return new CuboidTag(location, cuboid.pairs.get((int)0).low);
            }
        });
        CuboidTag.registerTag("list_players", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                ArrayList<PlayerTag> players = new ArrayList<PlayerTag>();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!object.isInsideCuboid(player.getLocation())) continue;
                    players.add(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
                }
                return new ListTag((Collection<? extends ObjectTag>)players);
            }
        });
        if (Depends.citizens != null) {
            CuboidTag.registerTag("list_npcs", new TagRunnable.ObjectForm<CuboidTag>(){

                @Override
                public ObjectTag run(Attribute attribute, CuboidTag object) {
                    ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
                    for (NPC npc : CitizensAPI.getNPCRegistry()) {
                        NPCTag dnpc = NPCTag.mirrorCitizensNPC(npc);
                        if (!object.isInsideCuboid(dnpc.getLocation())) continue;
                        npcs.add(dnpc);
                    }
                    return new ListTag((Collection<? extends ObjectTag>)npcs);
                }
            });
        }
        CuboidTag.registerTag("list_entities", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
                ListTag types = new ListTag();
                if (attribute.hasContext(1)) {
                    types = ListTag.valueOf(attribute.getContext(1));
                }
                block0: for (Entity ent : new WorldTag(object.getWorld()).getEntitiesForTag()) {
                    EntityTag current = new EntityTag(ent);
                    if (!object.isInsideCuboid(ent.getLocation())) continue;
                    if (!types.isEmpty()) {
                        for (String type : types) {
                            if (!current.identifySimpleType().equalsIgnoreCase(type)) continue;
                            entities.add(current);
                            continue block0;
                        }
                        continue;
                    }
                    entities.add(new EntityTag(ent));
                }
                return new ListTag((Collection<? extends ObjectTag>)entities);
            }
        });
        CuboidTag.registerTag("list_living_entities", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
                for (Entity ent : object.getWorld().getLivingEntities()) {
                    if (!object.isInsideCuboid(ent.getLocation()) || EntityTag.isCitizensNPC(ent)) continue;
                    entities.add(new EntityTag(ent));
                }
                return new ListTag((Collection<? extends ObjectTag>)entities);
            }
        });
        CuboidTag.registerTag("list_chunks", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                ListTag chunks = new ListTag();
                for (LocationPair pair : object.pairs) {
                    int minY = pair.low.getBlockY();
                    ChunkTag minChunk = new ChunkTag(pair.low);
                    if (object.isInsideCuboid(new Location(object.getWorld(), (double)(minChunk.getX() * 16), (double)minY, (double)(minChunk.getZ() * 16)))) {
                        chunks.addObject(minChunk);
                    }
                    ChunkTag maxChunk = new ChunkTag(pair.high);
                    if (object.isInsideCuboid(new Location(object.getWorld(), (double)(maxChunk.getX() * 16 + 15), (double)minY, (double)(maxChunk.getZ() * 16 + 15)))) {
                        chunks.addObject(maxChunk);
                    }
                    for (int x = minChunk.getX() + 1; x < maxChunk.getX(); ++x) {
                        for (int z = minChunk.getZ() + 1; z < maxChunk.getZ(); ++z) {
                            chunks.addObject(new ChunkTag(new WorldTag(object.getWorld()), x, z));
                        }
                    }
                }
                return chunks.deduplicate();
            }
        });
        CuboidTag.registerTag("list_partial_chunks", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                ListTag chunks = new ListTag();
                for (LocationPair pair : object.pairs) {
                    ChunkTag minChunk = new ChunkTag(pair.low);
                    ChunkTag maxChunk = new ChunkTag(pair.high);
                    for (int x = minChunk.getX(); x <= maxChunk.getX(); ++x) {
                        for (int z = minChunk.getZ(); z <= maxChunk.getZ(); ++z) {
                            chunks.addObject(new ChunkTag(new WorldTag(object.getWorld()), x, z));
                        }
                    }
                }
                return chunks;
            }
        });
        CuboidTag.registerTag("notable_name", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                String notname = NotableManager.getSavedId(object);
                if (notname == null) {
                    return null;
                }
                return new ElementTag(notname);
            }
        });
        CuboidTag.registerTag("full", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                return new ElementTag(object.identifyFull());
            }
        });
        CuboidTag.registerTag("type", new TagRunnable.ObjectForm<CuboidTag>(){

            @Override
            public ObjectTag run(Attribute attribute, CuboidTag object) {
                return new ElementTag("Cuboid");
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm<CuboidTag> runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (NotableManager.isExactSavedObject(this)) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Cannot apply properties to noted objects.");
            return;
        }
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        LocationPair pair;
        CuboidTag subCuboid;
        int member;
        int comma;
        String value;
        if (mechanism.matches("set_member")) {
            value = mechanism.getValue().asString();
            comma = value.indexOf(44);
            member = 1;
            if (comma > 0) {
                member = new ElementTag(value.substring(0, comma)).asInt();
            }
            subCuboid = CuboidTag.valueOf(comma == -1 ? value : value.substring(comma + 1));
            if (member < 1) {
                member = 1;
            }
            if (member > this.pairs.size()) {
                member = this.pairs.size();
            }
            pair = subCuboid.pairs.get(0);
            this.pairs.set(member - 1, new LocationPair(pair.point_1, pair.point_2));
        }
        if (mechanism.matches("add_member")) {
            value = mechanism.getValue().asString();
            comma = value.indexOf(44);
            member = this.pairs.size() + 1;
            if (comma > 0) {
                member = new ElementTag(value.substring(0, comma)).asInt();
            }
            subCuboid = CuboidTag.valueOf(comma == -1 ? value : value.substring(comma + 1));
            if (member < 1) {
                member = 1;
            }
            if (member > this.pairs.size()) {
                member = this.pairs.size();
            }
            pair = subCuboid.pairs.get(0);
            this.pairs.add(member - 1, new LocationPair(pair.point_1, pair.point_2));
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    public static class LocationPair {
        public LocationTag low;
        public LocationTag high;
        LocationTag point_1;
        LocationTag point_2;
        int x_distance;
        int y_distance;
        int z_distance;

        public LocationPair(LocationTag point_1, LocationTag point_2) {
            this.point_1 = point_1;
            this.point_2 = point_2;
            this.regenerate();
        }

        public void changePoint(int number, LocationTag point) {
            if (number == 1) {
                this.point_1 = point;
            } else if (number == 2) {
                this.point_2 = point;
            }
            this.regenerate();
        }

        public void regenerate() {
            World world = this.point_1.getWorld();
            int x_high = this.point_1.getBlockX() >= this.point_2.getBlockX() ? this.point_1.getBlockX() : this.point_2.getBlockX();
            int x_low = this.point_1.getBlockX() <= this.point_2.getBlockX() ? this.point_1.getBlockX() : this.point_2.getBlockX();
            int y_high = this.point_1.getBlockY() >= this.point_2.getBlockY() ? this.point_1.getBlockY() : this.point_2.getBlockY();
            int y_low = this.point_1.getBlockY() <= this.point_2.getBlockY() ? this.point_1.getBlockY() : this.point_2.getBlockY();
            int z_high = this.point_1.getBlockZ() >= this.point_2.getBlockZ() ? this.point_1.getBlockZ() : this.point_2.getBlockZ();
            int z_low = this.point_1.getBlockZ() <= this.point_2.getBlockZ() ? this.point_1.getBlockZ() : this.point_2.getBlockZ();
            this.low = new LocationTag(world, x_low, y_low, z_low);
            this.high = new LocationTag(world, x_high, y_high, z_high);
            this.generateDistances();
        }

        public void generateDistances() {
            this.x_distance = this.high.getBlockX() - this.low.getBlockX();
            this.y_distance = this.high.getBlockY() - this.low.getBlockY();
            this.z_distance = this.high.getBlockZ() - this.low.getBlockZ();
        }
    }
}

