/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.interfaces.FakePlayer;
import com.denizenscript.denizen.npc.traits.MirrorTrait;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.properties.entity.EntityAge;
import com.denizenscript.denizen.objects.properties.entity.EntityColor;
import com.denizenscript.denizen.objects.properties.entity.EntityTame;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class EntityTag
implements ObjectTag,
Adjustable,
EntityFormObject {
    public static HashSet<String> earlyValidMechanisms = new HashSet<String>(Arrays.asList("max_health", "health_data", "health"));
    private static final Map<UUID, Entity> rememberedEntities = new HashMap<UUID, Entity>();
    static final Pattern entity_by_id = Pattern.compile("(n@|e@|p@)(.+)", 2);
    static final Pattern entity_with_data = Pattern.compile("(\\w+),?(\\w+)?,?(\\w+)?", 2);
    private Entity entity = null;
    private DenizenEntityType entity_type = null;
    private String data1 = null;
    private String data2 = null;
    private DespawnedEntity despawned_entity = null;
    private NPCTag npc = null;
    private UUID uuid = null;
    private String entityScript = null;
    private String prefix = "Entity";
    public static ObjectTagProcessor<EntityTag> tagProcessor = new ObjectTagProcessor();
    private ArrayList<Mechanism> mechanisms = new ArrayList();

    public static void rememberEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.put(entity.getUniqueId(), entity);
    }

    public static void forgetEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.remove(entity.getUniqueId());
    }

    public static boolean isNPC(Entity entity) {
        return entity != null && entity.hasMetadata("NPC") && ((MetadataValue)entity.getMetadata("NPC").get(0)).asBoolean();
    }

    public static boolean isCitizensNPC(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (Depends.citizens == null) {
            return false;
        }
        if (!CitizensAPI.hasImplementation()) {
            return false;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(entity);
        if (npc == null) {
            return false;
        }
        return npc.getOwningRegistry() == CitizensAPI.getNPCRegistry();
    }

    public static NPCTag getNPCFrom(Entity entity) {
        if (EntityTag.isCitizensNPC(entity)) {
            return NPCTag.fromEntity(entity);
        }
        return null;
    }

    public static boolean isPlayer(Entity entity) {
        return entity != null && entity instanceof Player && !EntityTag.isNPC(entity);
    }

    public static PlayerTag getPlayerFrom(Entity entity) {
        if (EntityTag.isPlayer(entity)) {
            return PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
        }
        return null;
    }

    public ItemTag getItemInHand() {
        if (this.isLivingEntity() && this.getLivingEntity().getEquipment() != null) {
            ItemStack its = this.getLivingEntity().getEquipment().getItemInHand();
            if (its == null) {
                return null;
            }
            return new ItemTag(its.clone());
        }
        return null;
    }

    public static EntityTag getEntityFor(ObjectTag object, TagContext context) {
        if (object instanceof EntityTag) {
            return (EntityTag)object;
        }
        if (object instanceof PlayerTag && ((PlayerTag)object).isOnline()) {
            return new EntityTag((Entity)((PlayerTag)object).getPlayerEntity());
        }
        if (object instanceof NPCTag) {
            return new EntityTag((NPCTag)object);
        }
        return EntityTag.valueOf(object.toString(), context);
    }

    public static EntityTag valueOf(String string) {
        return EntityTag.valueOf(string, null);
    }

    @Fetchable(value="e")
    public static EntityTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Matcher m = ObjectFetcher.DESCRIBED_PATTERN.matcher(string);
        if (m.matches()) {
            return ObjectFetcher.getObjectFrom(EntityTag.class, string, context);
        }
        if (string.equalsIgnoreCase("RANDOM")) {
            EntityType randomType = null;
            while (randomType == null || randomType.name().matches("^(COMPLEX_PART|DROPPED_ITEM|ENDER_CRYSTAL|ENDER_DRAGON|FISHING_HOOK|ITEM_FRAME|LEASH_HITCH|LIGHTNING|PAINTING|PLAYER|UNKNOWN|WEATHER|WITHER|WITHER_SKULL)$")) {
                randomType = EntityType.values()[CoreUtilities.getRandom().nextInt(EntityType.values().length)];
            }
            return new EntityTag(DenizenEntityType.getByName(randomType.name()), "RANDOM");
        }
        m = entity_by_id.matcher(string);
        if (m.matches()) {
            String entityGroup = m.group(1).toUpperCase();
            if (entityGroup.matches("N@")) {
                NPCTag npc = NPCTag.valueOf(string);
                if (npc != null) {
                    if (npc.isSpawned()) {
                        return new EntityTag(npc);
                    }
                    if (context != null && context.debug) {
                        Debug.echoDebug((Debuggable)context.entry, "NPC '" + string + "' is not spawned, errors may follow!");
                    }
                    return new EntityTag(npc);
                }
                Debug.echoError("NPC '" + string + "' does not exist!");
            } else if (entityGroup.matches("P@")) {
                Player returnable = PlayerTag.valueOf(m.group(2)).getPlayerEntity();
                if (returnable != null) {
                    return new EntityTag((Entity)returnable);
                }
                if (context == null || context.debug) {
                    Debug.echoError("Invalid Player! '" + m.group(2) + "' could not be found. Has the player logged off?");
                }
            } else {
                try {
                    UUID entityID = UUID.fromString(m.group(2));
                    Entity entity = EntityTag.getEntityForID(entityID);
                    if (entity != null) {
                        return new EntityTag(entity);
                    }
                    return null;
                }
                catch (Exception entityID) {
                    // empty catch block
                }
            }
        }
        if (ScriptRegistry.containsScript(string = string.replace("e@", ""), EntityScriptContainer.class)) {
            return ScriptRegistry.getScriptContainerAs(string, EntityScriptContainer.class).getEntityFrom();
        }
        m = entity_with_data.matcher(string);
        if (m.matches()) {
            String data1 = null;
            String data2 = null;
            if (m.group(2) != null) {
                data1 = m.group(2);
            }
            if (m.group(3) != null) {
                data2 = m.group(3);
            }
            if (DenizenEntityType.isRegistered(m.group(1))) {
                return new EntityTag(DenizenEntityType.getByName(m.group(1)), data1, data2);
            }
        }
        try {
            UUID entityID = UUID.fromString(string);
            Entity entity = EntityTag.getEntityForID(entityID);
            if (entity != null) {
                return new EntityTag(entity);
            }
            return null;
        }
        catch (Exception exception) {
            if (context == null || context.debug) {
                Debug.log("valueOf EntityTag returning null: " + string);
            }
            return null;
        }
    }

    public static Entity getEntityForID(UUID id) {
        if (rememberedEntities.containsKey(id)) {
            return rememberedEntities.get(id);
        }
        for (World world : Bukkit.getWorlds()) {
            Entity entity = NMSHandler.getEntityHelper().getEntity(world, id);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static boolean matches(String arg) {
        Matcher m = entity_by_id.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if ((arg = arg.replace("e@", "").toUpperCase()).equals("RANDOM")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, EntityScriptContainer.class)) {
            return true;
        }
        m = entity_with_data.matcher(arg);
        return m.matches() && DenizenEntityType.isRegistered(m.group(1));
    }

    public EntityTag(Entity entity) {
        if (entity != null) {
            this.entity = entity;
            this.entityScript = EntityScriptHelper.getEntityScript(entity);
            this.uuid = entity.getUniqueId();
            this.entity_type = DenizenEntityType.getByEntity(entity);
            if (EntityTag.isCitizensNPC(entity)) {
                this.npc = EntityTag.getNPCFrom(entity);
            }
        } else {
            Debug.echoError("Entity referenced is null!");
        }
    }

    @Deprecated
    public EntityTag(EntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    @Deprecated
    public EntityTag(EntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    @Deprecated
    public EntityTag(EntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    @Deprecated
    public EntityTag(EntityType entityType, String data1, String data2) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
            this.data2 = data2;
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public EntityTag(DenizenEntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType, String data1, String data2) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
            this.data2 = data2;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(NPCTag npc) {
        if (Depends.citizens == null) {
            return;
        }
        if (npc != null) {
            this.npc = npc;
            if (npc.isSpawned()) {
                this.entity = npc.getEntity();
                this.entity_type = DenizenEntityType.getByName(npc.getEntityType().name());
                this.uuid = this.entity.getUniqueId();
            }
        } else {
            Debug.echoError("NPC referenced is null!");
        }
    }

    public DenizenEntityType getEntityType() {
        return this.entity_type;
    }

    public EntityType getBukkitEntityType() {
        return this.entity_type.getBukkitEntityType();
    }

    public void setEntityScript(String entityScript) {
        this.entityScript = entityScript;
    }

    public String getEntityScript() {
        return this.entityScript;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSaveName() {
        String baseID = this.uuid.toString().toUpperCase().replace("-", "");
        return baseID.substring(0, 2) + "." + baseID;
    }

    @Override
    public EntityTag getDenizenEntity() {
        return this;
    }

    public EntityFormObject getDenizenObject() {
        if (this.entity == null && this.npc == null) {
            return null;
        }
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC();
        }
        if (this.isPlayer()) {
            return new PlayerTag(this.getPlayer());
        }
        return this;
    }

    public Entity getBukkitEntity() {
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.entity instanceof LivingEntity) {
            return (LivingEntity)this.entity;
        }
        return null;
    }

    public boolean isLivingEntity() {
        return this.entity instanceof LivingEntity;
    }

    public boolean hasInventory() {
        return this.getBukkitEntity() instanceof InventoryHolder || this.isCitizensNPC();
    }

    public NPCTag getDenizenNPC() {
        if (this.npc != null) {
            return this.npc;
        }
        return EntityTag.getNPCFrom(this.entity);
    }

    public boolean isNPC() {
        return this.npc != null || EntityTag.isNPC(this.entity);
    }

    public boolean isCitizensNPC() {
        return this.npc != null || EntityTag.isCitizensNPC(this.entity);
    }

    public Player getPlayer() {
        if (this.isPlayer()) {
            return (Player)this.entity;
        }
        return null;
    }

    public PlayerTag getDenizenPlayer() {
        if (this.isPlayer()) {
            return new PlayerTag(this.getPlayer());
        }
        return null;
    }

    public boolean isPlayer() {
        return this.entity instanceof Player && !this.isNPC();
    }

    public Projectile getProjectile() {
        return (Projectile)this.entity;
    }

    public boolean isProjectile() {
        return this.entity instanceof Projectile;
    }

    public EntityTag getShooter() {
        if (this.hasShooter()) {
            return new EntityTag((Entity)((LivingEntity)this.getProjectile().getShooter()));
        }
        return null;
    }

    public void setShooter(EntityTag shooter) {
        if (this.isProjectile() && shooter.isLivingEntity()) {
            this.getProjectile().setShooter((ProjectileSource)shooter.getLivingEntity());
        }
    }

    public boolean hasShooter() {
        return this.isProjectile() && this.getProjectile().getShooter() != null && this.getProjectile().getShooter() instanceof LivingEntity;
    }

    public Inventory getBukkitInventory() {
        if (this.hasInventory() && !this.isCitizensNPC()) {
            return ((InventoryHolder)this.getBukkitEntity()).getInventory();
        }
        return null;
    }

    public InventoryTag getInventory() {
        return this.hasInventory() ? (this.isCitizensNPC() ? this.getDenizenNPC().getDenizenInventory() : InventoryTag.mirrorBukkitInventory(this.getBukkitInventory())) : null;
    }

    public String getName() {
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getCitizen().getName();
        }
        if (this.entity instanceof FakePlayer) {
            return ((FakePlayer)this.entity).getFullName();
        }
        if (this.entity instanceof Player) {
            return this.entity.getName();
        }
        String customName = this.entity.getCustomName();
        if (customName != null) {
            return customName;
        }
        return this.entity_type.getName();
    }

    public ListTag getEquipment() {
        ItemStack[] equipment = this.getLivingEntity().getEquipment().getArmorContents();
        ListTag equipmentList = new ListTag();
        for (ItemStack item : equipment) {
            equipmentList.add(new ItemTag(item).identify());
        }
        return equipmentList;
    }

    public boolean isGeneric() {
        return !this.isUnique();
    }

    public LocationTag getLocation() {
        if (this.entity != null) {
            return new LocationTag(this.entity.getLocation());
        }
        return null;
    }

    public LocationTag getEyeLocation() {
        if (this.isPlayer()) {
            return new LocationTag(this.getPlayer().getEyeLocation());
        }
        if (!this.isGeneric() && this.isLivingEntity()) {
            return new LocationTag(this.getLivingEntity().getEyeLocation());
        }
        if (!this.isGeneric()) {
            return new LocationTag(this.getBukkitEntity().getLocation());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getTargetBlockSafe(Set<Material> mats, int range) {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
            Location location = this.getLivingEntity().getTargetBlock(mats, range).getLocation();
            return location;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Vector getVelocity() {
        if (!this.isGeneric()) {
            return this.entity.getVelocity();
        }
        return null;
    }

    public void setVelocity(Vector vector) {
        if (!this.isGeneric()) {
            if (this.entity instanceof WitherSkull) {
                ((WitherSkull)this.entity).setDirection(vector);
            } else {
                this.entity.setVelocity(vector);
            }
        }
    }

    public World getWorld() {
        if (!this.isGeneric()) {
            return this.entity.getWorld();
        }
        return null;
    }

    public void spawnAt(Location location) {
        if (this.isCitizensNPC()) {
            if (this.getDenizenNPC().getCitizen().isSpawned()) {
                this.getDenizenNPC().getCitizen().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            } else {
                this.getDenizenNPC().getCitizen().spawn(location);
                this.entity = this.getDenizenNPC().getCitizen().getEntity();
                this.uuid = this.getDenizenNPC().getCitizen().getEntity().getUniqueId();
            }
        } else if (this.entity != null && this.isUnique()) {
            this.entity.teleport(location);
            if (this.entity.getWorld().equals(location.getWorld())) {
                NMSHandler.getEntityHelper().teleport(this.entity, location.toVector());
            }
        } else {
            if (this.entity_type != null) {
                Entity ent;
                if (this.despawned_entity != null) {
                    if (this.despawned_entity.custom_script == null) {
                        this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    }
                    this.getLivingEntity().teleport(location);
                    this.getLivingEntity().getEquipment().setArmorContents(this.despawned_entity.equipment);
                    this.getLivingEntity().setHealth(this.despawned_entity.health.doubleValue());
                    this.despawned_entity = null;
                } else if (this.entity_type.getName().equals("PLAYER")) {
                    if (Depends.citizens == null) {
                        Debug.echoError("Cannot spawn entity of type PLAYER!");
                        return;
                    }
                    NPCTag npc = new NPCTag(CitizensAPI.getNPCRegistry().createNPC(EntityType.PLAYER, this.data1));
                    npc.getCitizen().spawn(location);
                    this.entity = npc.getEntity();
                    this.uuid = this.entity.getUniqueId();
                } else if (this.entity_type.getName().equals("FALLING_BLOCK")) {
                    Material material = null;
                    if (this.data1 != null && MaterialTag.matches(this.data1)) {
                        material = MaterialTag.valueOf(this.data1).getMaterial();
                        while (this.data1.equalsIgnoreCase("RANDOM") && (!material.isBlock() || material == Material.AIR || material == MaterialCompat.NETHER_PORTAL || material == MaterialCompat.END_PORTAL)) {
                            material = MaterialTag.valueOf(this.data1).getMaterial();
                        }
                    }
                    if (material == null || !material.isBlock()) {
                        material = Material.SAND;
                    }
                    byte materialData = 0;
                    if (this.data2 != null && ArgumentHelper.matchesInteger(this.data2)) {
                        materialData = (byte)ArgumentHelper.getIntegerFrom(this.data2);
                    }
                    this.entity = ent = location.getWorld().spawnFallingBlock(location, material, materialData);
                    this.uuid = this.entity.getUniqueId();
                } else {
                    this.entity = ent = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    if (this.entity == null) {
                        if (Debug.verbose) {
                            Debug.echoError("Failed to spawn entity of type " + this.entity_type.getName());
                        }
                        return;
                    }
                    this.uuid = this.entity.getUniqueId();
                    if (this.entityScript != null) {
                        EntityScriptHelper.setEntityScript(this.entity, this.entityScript);
                    }
                }
            } else {
                Debug.echoError("Cannot spawn a null EntityTag!");
            }
            if (!this.isUnique()) {
                Debug.echoError("Error spawning entity - bad entity type, blocked by another plugin, or tried to spawn in an unloaded chunk?");
                return;
            }
            for (Mechanism mechanism : this.mechanisms) {
                this.safeAdjust(new Mechanism(new ElementTag(mechanism.getName()), mechanism.getValue(), mechanism.context));
            }
            this.mechanisms.clear();
        }
    }

    public void despawn() {
        this.despawned_entity = new DespawnedEntity(this);
        this.getLivingEntity().remove();
    }

    public void respawn() {
        if (this.despawned_entity != null) {
            this.spawnAt(this.despawned_entity.location);
        } else if (this.entity == null) {
            Debug.echoError("Cannot respawn a null EntityTag!");
        }
    }

    public boolean isSpawnedOrValidForTag() {
        return this.entity != null && (this.isValidForTag() || rememberedEntities.containsKey(this.entity.getUniqueId()));
    }

    public boolean isSpawned() {
        return this.entity != null && this.entity.isValid();
    }

    public boolean isValid() {
        return this.entity != null && this.entity.isValid();
    }

    public boolean isValidForTag() {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.entity.getWorld());
        try {
            boolean bl = this.entity.isValid();
            return bl;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.entity.getWorld());
        }
    }

    public void remove() {
        EntityScriptHelper.unlinkEntity(this.entity);
        this.entity.remove();
    }

    public void teleport(Location location) {
        if (this.isCitizensNPC()) {
            this.getDenizenNPC().getCitizen().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            this.entity.teleport(location);
        }
    }

    public void target(LivingEntity target) {
        if (!this.isSpawned() || !(this.entity instanceof Creature)) {
            Debug.echoError(this.identify() + " is not a valid creature entity!");
            return;
        }
        NMSHandler.getEntityHelper().setTarget((Creature)this.entity, target);
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public int comparesTo(EntityTag entity) {
        if (entity == null) {
            return 0;
        }
        if (entity.isUnique() && entity.identify().equals(this.identify())) {
            return 1;
        }
        if (!entity.isUnique()) {
            if (!this.isUnique() && entity.identify().equals(this.identify())) {
                return 1;
            }
            if (this.entity_type == entity.entity_type) {
                return 1;
            }
        }
        return 0;
    }

    public boolean comparedTo(String compare) {
        if ((compare = CoreUtilities.toLowerCase(compare)).equals("entity")) {
            return true;
        }
        if (compare.equals("player")) {
            return this.isPlayer();
        }
        if (compare.equals("npc")) {
            return this.isCitizensNPC() || this.isNPC();
        }
        if (this.getEntityScript() != null && compare.equals(CoreUtilities.toLowerCase(this.getEntityScript()))) {
            return true;
        }
        return compare.equals(this.getEntityType().getLowercaseName());
    }

    @Override
    public String getObjectType() {
        return "Entity";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public EntityTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.npc != null) {
            return this.npc.debuggable();
        }
        if (this.entity != null) {
            if (this.isPlayer()) {
                return this.getDenizenPlayer().debuggable();
            }
            if (this.isSpawnedOrValidForTag()) {
                return "e@ " + this.entity.getUniqueId().toString() + "<GR>(" + this.entity.getType().name() + "/" + this.entity.getName() + ")";
            }
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            return this.identify();
        }
        return "null";
    }

    @Override
    public String identify() {
        if (this.npc != null) {
            return "n@" + this.npc.getId();
        }
        if (this.entity != null) {
            if (this.isPlayer()) {
                return "p@" + this.getPlayer().getUniqueId();
            }
            if (this.isSpawnedOrValidForTag()) {
                return "e@" + this.entity.getUniqueId().toString();
            }
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            StringBuilder properties = new StringBuilder();
            for (Mechanism mechanism : this.mechanisms) {
                properties.append(mechanism.getName()).append("=").append(mechanism.getValue().asString().replace(';', '\u2011')).append(";");
            }
            String propertyOutput = "";
            if (properties.length() > 0) {
                propertyOutput = "[" + properties.substring(0, properties.length() - 1) + "]";
            }
            return "e@" + this.entity_type.getLowercaseName() + propertyOutput;
        }
        return "null";
    }

    @Override
    public String identifySimple() {
        if (this.npc != null && this.npc.isValid()) {
            return "n@" + this.npc.getId();
        }
        if (this.isPlayer()) {
            return "p@" + this.getPlayer().getName();
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName();
        }
        return "null";
    }

    public String identifyType() {
        if (this.isCitizensNPC()) {
            return "npc";
        }
        if (this.isPlayer()) {
            return "player";
        }
        return "e@" + this.entity_type.getName();
    }

    public String identifySimpleType() {
        if (this.isCitizensNPC()) {
            return "npc";
        }
        if (this.isPlayer()) {
            return "player";
        }
        return this.entity_type.getLowercaseName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return this.isPlayer() || this.isCitizensNPC() || this.isSpawned() || this.isLivingEntity() || this.entity != null && rememberedEntities.containsKey(this.entity.getUniqueId());
    }

    public boolean matchesEntity(String ent) {
        if (ent.equalsIgnoreCase("entity")) {
            return true;
        }
        if (ent.equalsIgnoreCase("npc")) {
            return this.isCitizensNPC();
        }
        if (ent.equalsIgnoreCase("player")) {
            return this.isPlayer();
        }
        if (ent.equalsIgnoreCase("vehicle")) {
            return this.entity instanceof Vehicle;
        }
        if (ent.equalsIgnoreCase("projectile")) {
            return this.entity instanceof Projectile;
        }
        if (ent.equalsIgnoreCase("hanging")) {
            return this.entity instanceof Hanging;
        }
        if (ent.equalsIgnoreCase(this.getName())) {
            return true;
        }
        if (ent.equalsIgnoreCase(this.entity_type.getLowercaseName())) {
            return true;
        }
        if (this.entity != null && this.getEntityScript() != null) {
            return ent.equalsIgnoreCase(this.getEntityScript());
        }
        return this.uuid != null && this.uuid.toString().equals(ent);
    }

    public static void registerTags() {
        EntityTag.registerTag("type", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag("Entity");
            }
        });
        EntityTag.registerTag("entity_type", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.entity_type.getName());
            }
        });
        EntityTag.registerTag("is_spawned", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.isSpawned());
            }
        });
        EntityTag.registerTag("eid", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.entity.getEntityId());
            }
        });
        EntityTag.registerTag("uuid", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.getUUID().toString());
            }
        });
        EntityTag.registerTag("scriptname", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.entityScript == null) {
                    return null;
                }
                return new ElementTag(object.entityScript);
            }
        });
        EntityTag.registerSpawnedOnlyTag("has_flag", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String flag_name = attribute.getContext(1);
                if (object.isPlayer() || object.isCitizensNPC()) {
                    Debug.echoError("Reading flag for PLAYER or NPC as if it were an ENTITY!");
                    return null;
                }
                return new ElementTag(FlagManager.entityHasFlag(object, flag_name));
            }
        });
        EntityTag.registerSpawnedOnlyTag("flag", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String flag_name = attribute.getContext(1);
                if (object.isPlayer() || object.isCitizensNPC()) {
                    Debug.echoError("Reading flag for PLAYER or NPC as if it were an ENTITY!");
                    return null;
                }
                if (attribute.startsWith("is_expired", 2) || attribute.startsWith("isexpired", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(!FlagManager.entityHasFlag(object, flag_name));
                }
                if (attribute.startsWith("size", 2) && !FlagManager.entityHasFlag(object, flag_name)) {
                    attribute.fulfill(1);
                    return new ElementTag(0);
                }
                if (FlagManager.entityHasFlag(object, flag_name)) {
                    FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getEntityFlag(object, flag_name);
                    if (attribute.startsWith("expiration", 2)) {
                        attribute.fulfill(1);
                        return flag.expiration();
                    }
                    return new ListTag(flag.toString(), true, flag.values());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("list_flags", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                ListTag allFlags = new ListTag(DenizenAPI.getCurrentInstance().flagManager().listEntityFlags(object));
                ListTag searchFlags = null;
                if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                    searchFlags = new ListTag();
                    String search = attribute.getContext(1);
                    if (search.startsWith("regex:")) {
                        try {
                            Pattern pattern = Pattern.compile(search.substring(6), 2);
                            for (String flag : allFlags) {
                                if (!pattern.matcher(flag).matches()) continue;
                                searchFlags.add(flag);
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                        }
                    } else {
                        search = CoreUtilities.toLowerCase(search);
                        for (String flag : allFlags) {
                            if (!CoreUtilities.toLowerCase(flag).contains(search)) continue;
                            searchFlags.add(flag);
                        }
                    }
                    DenizenAPI.getCurrentInstance().flagManager().shrinkEntityFlags(object, searchFlags);
                } else {
                    DenizenAPI.getCurrentInstance().flagManager().shrinkEntityFlags(object, allFlags);
                }
                return searchFlags == null ? allFlags : searchFlags;
            }
        });
        EntityTag.registerSpawnedOnlyTag("custom_id", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (CustomNBT.hasCustomNBT((Entity)object.getLivingEntity(), "denizen-script-id")) {
                    return new ScriptTag(CustomNBT.getCustomNBT((Entity)object.getLivingEntity(), "denizen-script-id"));
                }
                return new ElementTag(object.entity.getType().name());
            }
        });
        EntityTag.registerSpawnedOnlyTag("name", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.getName());
            }
        });
        EntityTag.registerSpawnedOnlyTag("saddle", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.getLivingEntity().getType() == EntityType.HORSE) {
                    return new ItemTag(((Horse)object.getLivingEntity()).getInventory().getSaddle());
                }
                if (object.getLivingEntity().getType() == EntityType.PIG) {
                    return new ItemTag(((Pig)object.getLivingEntity()).hasSaddle() ? Material.SADDLE : Material.AIR);
                }
                return null;
            }
        });
        EntityTag.registerTag("horse_armor", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.getBukkitEntityType() == EntityType.HORSE) {
                    return new ItemTag(((Horse)object.getLivingEntity()).getInventory().getArmor());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("horse_armour", EntityTag.tagProcessor.registeredObjectTags.get("horse_armor"));
        EntityTag.registerSpawnedOnlyTag("has_saddle", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.getBukkitEntityType() == EntityType.HORSE) {
                    return new ElementTag(((Horse)object.getLivingEntity()).getInventory().getSaddle().getType() == Material.SADDLE);
                }
                if (object.getBukkitEntityType() == EntityType.PIG) {
                    return new ElementTag(((Pig)object.getLivingEntity()).hasSaddle());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("item_in_hand", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ItemTag(object.getLivingEntity().getEquipment().getItemInMainHand());
            }
        });
        EntityTag.registerSpawnedOnlyTag("iteminhand", EntityTag.tagProcessor.registeredObjectTags.get("item_in_hand"));
        EntityTag.registerSpawnedOnlyTag("item_in_offhand", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ItemTag(object.getLivingEntity().getEquipment().getItemInOffHand());
            }
        });
        EntityTag.registerSpawnedOnlyTag("iteminoffhand", EntityTag.tagProcessor.registeredObjectTags.get("item_in_offhand"));
        EntityTag.registerSpawnedOnlyTag("is_trading", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.entity instanceof Merchant) {
                    return new ElementTag(((Merchant)object.entity).isTrading());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("trading_with", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.entity instanceof Merchant && ((Merchant)object.entity).getTrader() != null) {
                    return new EntityTag((Entity)((Merchant)object.entity).getTrader());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("map_trace", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                EntityHelper.MapTraceResult mtr = NMSHandler.getEntityHelper().mapTrace(object.getLivingEntity(), 200.0);
                if (mtr != null) {
                    double x = 0.0;
                    double y = 0.0;
                    double basex = mtr.hitLocation.getX() - Math.floor(mtr.hitLocation.getX());
                    double basey = mtr.hitLocation.getY() - Math.floor(mtr.hitLocation.getY());
                    double basez = mtr.hitLocation.getZ() - Math.floor(mtr.hitLocation.getZ());
                    if (mtr.angle == BlockFace.NORTH) {
                        x = 128.0 - basex * 128.0;
                    } else if (mtr.angle == BlockFace.SOUTH) {
                        x = basex * 128.0;
                    } else if (mtr.angle == BlockFace.WEST) {
                        x = basez * 128.0;
                    } else if (mtr.angle == BlockFace.EAST) {
                        x = 128.0 - basez * 128.0;
                    }
                    y = 128.0 - basey * 128.0;
                    return new LocationTag(null, Math.round(x), Math.round(y));
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("can_see", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                EntityTag toEntity;
                if (object.isLivingEntity() && attribute.hasContext(1) && EntityTag.matches(attribute.getContext(1)) && (toEntity = EntityTag.valueOf(attribute.getContext(1))) != null && toEntity.isSpawnedOrValidForTag()) {
                    return new ElementTag(object.getLivingEntity().hasLineOfSight(toEntity.getBukkitEntity()));
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("eye_location", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new LocationTag(object.getEyeLocation());
            }
        });
        EntityTag.registerSpawnedOnlyTag("eye_height", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.isLivingEntity()) {
                    return new ElementTag(object.getLivingEntity().getEyeHeight());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("location", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (attribute.startsWith("cursor_on", 2)) {
                    int range = attribute.getIntContext(2);
                    if (range < 1) {
                        range = 50;
                    }
                    HashSet<Material> set = new HashSet<Material>();
                    set.add(Material.AIR);
                    if (attribute.startsWith("ignore", 3) && attribute.hasContext(3)) {
                        List<MaterialTag> ignoreList = ListTag.valueOf(attribute.getContext(3)).filter(MaterialTag.class, attribute.context);
                        for (MaterialTag material : ignoreList) {
                            set.add(material.getMaterial());
                        }
                        attribute.fulfill(1);
                    }
                    attribute.fulfill(1);
                    return new LocationTag(object.getTargetBlockSafe(set, range));
                }
                if (attribute.startsWith("standing_on", 2)) {
                    attribute.fulfill(1);
                    return new LocationTag(object.entity.getLocation().clone().add(0.0, -0.5, 0.0));
                }
                return new LocationTag(object.entity.getLocation());
            }
        });
        EntityTag.registerSpawnedOnlyTag("body_yaw", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(NMSHandler.getEntityHelper().getBaseYaw(object.entity));
            }
        });
        EntityTag.registerSpawnedOnlyTag("velocity", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new LocationTag(object.entity.getVelocity().toLocation(object.entity.getWorld()));
            }
        });
        EntityTag.registerSpawnedOnlyTag("world", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new WorldTag(object.entity.getWorld());
            }
        });
        EntityTag.registerSpawnedOnlyTag("can_pickup_items", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.isLivingEntity()) {
                    return new ElementTag(object.getLivingEntity().getCanPickupItems());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("fallingblock_material", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!(object.entity instanceof FallingBlock)) {
                    return null;
                }
                return new MaterialTag(NMSHandler.getEntityHelper().getBlockDataFor((FallingBlock)object.entity));
            }
        });
        EntityTag.registerSpawnedOnlyTag("fall_distance", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.entity.getFallDistance());
            }
        });
        EntityTag.registerSpawnedOnlyTag("fire_time", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new DurationTag(object.entity.getFireTicks() / 20);
            }
        });
        EntityTag.registerSpawnedOnlyTag("on_fire", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.entity.getFireTicks() > 0);
            }
        });
        EntityTag.registerSpawnedOnlyTag("leash_holder", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.isLivingEntity() && object.getLivingEntity().isLeashed()) {
                    return new EntityTag(object.getLivingEntity().getLeashHolder());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("get_leash_holder", EntityTag.tagProcessor.registeredObjectTags.get("leash_holder"));
        EntityTag.registerSpawnedOnlyTag("passengers", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                ArrayList<EntityTag> passengers = new ArrayList<EntityTag>();
                for (Entity ent : object.entity.getPassengers()) {
                    passengers.add(new EntityTag(ent));
                }
                return new ListTag((Collection<? extends ObjectTag>)passengers);
            }
        });
        EntityTag.registerSpawnedOnlyTag("get_passengers", EntityTag.tagProcessor.registeredObjectTags.get("passengers"));
        EntityTag.registerSpawnedOnlyTag("passenger", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!object.entity.isEmpty()) {
                    return new EntityTag(object.entity.getPassenger());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("get_passenger", EntityTag.tagProcessor.registeredObjectTags.get("passenger"));
        EntityTag.registerSpawnedOnlyTag("shooter", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return object.getShooter();
            }
        });
        EntityTag.registerSpawnedOnlyTag("get_shooter", EntityTag.tagProcessor.registeredObjectTags.get("shooter"));
        EntityTag.registerSpawnedOnlyTag("left_shoulder", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!(object.getLivingEntity() instanceof HumanEntity)) {
                    return null;
                }
                return new EntityTag(((HumanEntity)object.getLivingEntity()).getShoulderEntityLeft());
            }
        });
        EntityTag.registerSpawnedOnlyTag("right_shoulder", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!(object.getLivingEntity() instanceof HumanEntity)) {
                    return null;
                }
                return new EntityTag(((HumanEntity)object.getLivingEntity()).getShoulderEntityRight());
            }
        });
        EntityTag.registerSpawnedOnlyTag("vehicle", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.entity.isInsideVehicle()) {
                    return new EntityTag(object.entity.getVehicle());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("get_vehicle", EntityTag.tagProcessor.registeredObjectTags.get("vehicle"));
        EntityTag.registerSpawnedOnlyTag("can_breed", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(((Ageable)object.getLivingEntity()).canBreed());
            }
        });
        EntityTag.registerSpawnedOnlyTag("breeding", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(NMSHandler.getEntityHelper().isBreeding((Animals)object.getLivingEntity()));
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_breeding", EntityTag.tagProcessor.registeredObjectTags.get("breeding"));
        EntityTag.registerSpawnedOnlyTag("has_passenger", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(!object.entity.isEmpty());
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_empty", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.entity.isEmpty());
            }
        });
        EntityTag.registerSpawnedOnlyTag("empty", EntityTag.tagProcessor.registeredObjectTags.get("is_empty"));
        EntityTag.registerSpawnedOnlyTag("is_inside_vehicle", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.entity.isInsideVehicle());
            }
        });
        EntityTag.registerSpawnedOnlyTag("inside_vehicle", EntityTag.tagProcessor.registeredObjectTags.get("is_inside_vehicle"));
        EntityTag.registerSpawnedOnlyTag("is_leashed", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.isLivingEntity() && object.getLivingEntity().isLeashed());
            }
        });
        EntityTag.registerSpawnedOnlyTag("leashed", EntityTag.tagProcessor.registeredObjectTags.get("is_leashed"));
        EntityTag.registerSpawnedOnlyTag("is_sheared", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!(object.getBukkitEntity() instanceof Sheep)) {
                    return null;
                }
                return new ElementTag(((Sheep)object.getBukkitEntity()).isSheared());
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_on_ground", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.entity.isOnGround());
            }
        });
        EntityTag.registerSpawnedOnlyTag("on_ground", EntityTag.tagProcessor.registeredObjectTags.get("is_on_ground"));
        EntityTag.registerSpawnedOnlyTag("is_persistent", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.isLivingEntity() && !object.getLivingEntity().getRemoveWhenFarAway());
            }
        });
        EntityTag.registerSpawnedOnlyTag("persistent", EntityTag.tagProcessor.registeredObjectTags.get("is_persistent"));
        EntityTag.registerSpawnedOnlyTag("is_collidable", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.getLivingEntity().isCollidable());
            }
        });
        EntityTag.registerSpawnedOnlyTag("killer", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return EntityTag.getPlayerFrom((Entity)object.getLivingEntity().getKiller());
            }
        });
        EntityTag.registerSpawnedOnlyTag("last_damage", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (attribute.startsWith("amount", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(object.getLivingEntity().getLastDamage());
                }
                if (attribute.startsWith("cause", 2)) {
                    attribute.fulfill(1);
                    if (object.entity.getLastDamageCause() == null) {
                        return null;
                    }
                    return new ElementTag(object.entity.getLastDamageCause().getCause().name());
                }
                if (attribute.startsWith("duration", 2)) {
                    attribute.fulfill(1);
                    return new DurationTag((long)object.getLivingEntity().getNoDamageTicks());
                }
                if (attribute.startsWith("max_duration", 2)) {
                    attribute.fulfill(1);
                    return new DurationTag((long)object.getLivingEntity().getMaximumNoDamageTicks());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("max_oxygen", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new DurationTag((long)object.getLivingEntity().getMaximumAir());
            }
        });
        EntityTag.registerSpawnedOnlyTag("oxygen", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (attribute.startsWith("max", 2)) {
                    Deprecations.entityMaxOxygenTag.warn(attribute.context);
                    attribute.fulfill(1);
                    return new DurationTag((long)object.getLivingEntity().getMaximumAir());
                }
                return new DurationTag((long)object.getLivingEntity().getRemainingAir());
            }
        });
        EntityTag.registerSpawnedOnlyTag("remove_when_far", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.getLivingEntity().getRemoveWhenFarAway());
            }
        });
        EntityTag.registerSpawnedOnlyTag("target", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                LivingEntity target;
                if (object.getBukkitEntity() instanceof Creature && (target = ((Creature)object.getLivingEntity()).getTarget()) != null) {
                    return new EntityTag((Entity)target);
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("time_lived", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new DurationTag(object.entity.getTicksLived() / 20);
            }
        });
        EntityTag.registerSpawnedOnlyTag("pickup_delay", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!(object.getBukkitEntity() instanceof Item)) {
                    return null;
                }
                return new DurationTag(((Item)object.getBukkitEntity()).getPickupDelay() * 20);
            }
        });
        EntityTag.registerSpawnedOnlyTag("pickupdelay", EntityTag.tagProcessor.registeredObjectTags.get("pickup_delay"));
        EntityTag.registerSpawnedOnlyTag("is_in_block", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.getBukkitEntity() instanceof Arrow) {
                    return new ElementTag(((Arrow)object.getBukkitEntity()).isInBlock());
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("attached_block", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (object.getBukkitEntity() instanceof Arrow) {
                    Block attachedBlock = ((Arrow)object.getBukkitEntity()).getAttachedBlock();
                    if (attachedBlock != null) {
                        return new LocationTag(attachedBlock.getLocation());
                    }
                } else if (object.getBukkitEntity() instanceof Hanging) {
                    Vector dir = ((Hanging)object.getBukkitEntity()).getAttachedFace().getDirection();
                    return new LocationTag(object.getLocation().clone().add(dir.multiply(0.5))).getBlockLocation();
                }
                return null;
            }
        });
        EntityTag.registerSpawnedOnlyTag("gliding", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.getLivingEntity().isGliding());
            }
        });
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            EntityTag.registerSpawnedOnlyTag("swimming", new TagRunnable.ObjectForm<EntityTag>(){

                @Override
                public ObjectTag run(Attribute attribute, EntityTag object) {
                    return new ElementTag(object.getLivingEntity().isSwimming());
                }
            });
        }
        EntityTag.registerSpawnedOnlyTag("glowing", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.getBukkitEntity().isGlowing());
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_living", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.isLivingEntity());
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_monster", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.getBukkitEntity() instanceof Monster);
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_mob", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(!object.isPlayer() && !object.isNPC() && object.isLivingEntity());
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_npc", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.isCitizensNPC());
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_player", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.isPlayer());
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_projectile", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(object.isProjectile());
            }
        });
        EntityTag.registerSpawnedOnlyTag("tameable", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(EntityTame.describes(object));
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_tameable", EntityTag.tagProcessor.registeredObjectTags.get("tameable"));
        EntityTag.registerSpawnedOnlyTag("ageable", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(EntityAge.describes(object));
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_ageable", EntityTag.tagProcessor.registeredObjectTags.get("ageable"));
        EntityTag.registerSpawnedOnlyTag("colorable", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                return new ElementTag(EntityColor.describes(object));
            }
        });
        EntityTag.registerSpawnedOnlyTag("is_colorable", EntityTag.tagProcessor.registeredObjectTags.get("colorable"));
        EntityTag.registerSpawnedOnlyTag("experience", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!(object.getBukkitEntity() instanceof ExperienceOrb)) {
                    return null;
                }
                return new ElementTag(((ExperienceOrb)object.getBukkitEntity()).getExperience());
            }
        });
        EntityTag.registerSpawnedOnlyTag("fuse_ticks", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!(object.getBukkitEntity() instanceof TNTPrimed)) {
                    return null;
                }
                return new ElementTag(((TNTPrimed)object.getBukkitEntity()).getFuseTicks());
            }
        });
        EntityTag.registerSpawnedOnlyTag("dragon_phase", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!(object.getBukkitEntity() instanceof EnderDragon)) {
                    return null;
                }
                return new ElementTag(((EnderDragon)object.getLivingEntity()).getPhase().name());
            }
        });
        EntityTag.registerSpawnedOnlyTag("weapon_damage", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                Entity target = null;
                if (attribute.hasContext(1)) {
                    target = EntityTag.valueOf(attribute.getContext(1)).getBukkitEntity();
                }
                return new ElementTag(NMSHandler.getEntityHelper().getDamageTo(object.getLivingEntity(), target));
            }
        });
        EntityTag.registerSpawnedOnlyTag("describe", new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                String escript = object.getEntityScript();
                return new ElementTag("e@" + (escript != null && escript.length() > 0 ? escript : object.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(object));
            }
        });
    }

    public static void registerSpawnedOnlyTag(String name, final TagRunnable.ObjectForm<EntityTag> runnable) {
        TagRunnable.ObjectForm<EntityTag> newRunnable = new TagRunnable.ObjectForm<EntityTag>(){

            @Override
            public ObjectTag run(Attribute attribute, EntityTag object) {
                if (!object.isSpawnedOrValidForTag()) {
                    if (!attribute.hasAlternative()) {
                        com.denizenscript.denizen.utilities.debugging.Debug.echoError("Entity is not spawned, but tag '" + attribute.getAttributeWithoutContext(1) + "' requires the entity be spawned, for entity: " + object.debuggable());
                    }
                    return null;
                }
                return runnable.run(attribute, object);
            }
        };
        newRunnable.name = runnable.name;
        EntityTag.registerTag(name, newRunnable);
    }

    public static void registerTag(String name, TagRunnable.ObjectForm<EntityTag> runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public ArrayList<Mechanism> getWaitingMechanisms() {
        return this.mechanisms;
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
        } else {
            Debug.echoError("Cannot apply properties to an already-spawned entity!");
        }
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Entity bukkitEnt;
        EntityTag ent2;
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
            return;
        }
        if (this.getBukkitEntity() == null) {
            if (this.isCitizensNPC()) {
                Debug.echoError("Cannot adjust not-spawned NPC " + this.getDenizenNPC());
            } else {
                Debug.echoError("Cannot adjust entity " + this);
            }
            return;
        }
        if (mechanism.matches("item_in_hand")) {
            this.getLivingEntity().getEquipment().setItemInMainHand(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
        if (mechanism.matches("item_in_offhand")) {
            this.getLivingEntity().getEquipment().setItemInOffHand(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
        if (mechanism.matches("attach_to")) {
            if (mechanism.hasValue()) {
                Iterator list = mechanism.valueAsType(ListTag.class);
                Vector offset = null;
                boolean rotateWith = true;
                if (((ArrayList)((Object)list)).size() > 1) {
                    offset = LocationTag.valueOf((String)((ArrayList)((Object)list)).get(1)).toVector();
                    if (((ArrayList)((Object)list)).size() > 2) {
                        rotateWith = new ElementTag((String)((ArrayList)((Object)list)).get(2)).asBoolean();
                    }
                }
                NMSHandler.getInstance().forceAttachMove(this.entity, EntityTag.valueOf((String)((ArrayList)((Object)list)).get(0)).getBukkitEntity(), offset, rotateWith);
            } else {
                NMSHandler.getInstance().forceAttachMove(this.entity, null, null, false);
            }
        }
        if (mechanism.matches("shooter")) {
            this.setShooter(mechanism.valueAsType(EntityTag.class));
        }
        if (mechanism.matches("can_pickup_items") && mechanism.requireBoolean()) {
            this.getLivingEntity().setCanPickupItems(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fall_distance") && mechanism.requireFloat()) {
            this.entity.setFallDistance(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("fallingblock_drop_item") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setDropItem(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fallingblock_hurt_entities") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setHurtEntities(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fire_time") && mechanism.requireObject(DurationTag.class)) {
            this.entity.setFireTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("leash_holder") && mechanism.requireObject(EntityTag.class)) {
            this.getLivingEntity().setLeashHolder(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("can_breed") && mechanism.requireBoolean()) {
            ((Ageable)this.getLivingEntity()).setBreed(true);
        }
        if (mechanism.matches("breed") && mechanism.requireBoolean()) {
            NMSHandler.getEntityHelper().setBreeding((Animals)this.getLivingEntity(), mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("passengers")) {
            this.entity.eject();
            for (EntityTag ent2 : mechanism.valueAsType(ListTag.class).filter(EntityTag.class, mechanism.context)) {
                if (!ent2.isSpawned() || this.comparesTo(ent2) == 1) continue;
                this.entity.addPassenger(ent2.getBukkitEntity());
            }
        }
        if (mechanism.matches("passenger") && mechanism.requireObject(EntityTag.class)) {
            this.entity.setPassenger(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("time_lived") && mechanism.requireObject(DurationTag.class)) {
            this.entity.setTicksLived(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("remaining_air") && mechanism.requireInteger()) {
            this.getLivingEntity().setRemainingAir(mechanism.getValue().asInt());
        }
        if (mechanism.matches("remove_effects")) {
            for (PotionEffect potionEffect : this.getLivingEntity().getActivePotionEffects()) {
                this.getLivingEntity().removePotionEffect(potionEffect.getType());
            }
        }
        if (this.getLivingEntity() instanceof HumanEntity && mechanism.matches("release_left_shoulder") && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityLeft()) != null) {
            ent2 = new EntityTag(bukkitEnt);
            String escript = ent2.getEntityScript();
            ent2 = EntityTag.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : ent2.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(ent2));
            ent2.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
        }
        if (this.getLivingEntity() instanceof HumanEntity && mechanism.matches("release_right_shoulder") && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityRight()) != null) {
            ent2 = new EntityTag(bukkitEnt);
            String escript = ent2.getEntityScript();
            ent2 = EntityTag.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : ent2.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(ent2));
            ent2.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
        }
        if (this.getLivingEntity() instanceof HumanEntity && mechanism.matches("left_shoulder")) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(EntityTag.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
            }
        }
        if (this.getLivingEntity() instanceof HumanEntity && mechanism.matches("right_shoulder")) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(EntityTag.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
            }
        }
        if (mechanism.matches("remove_when_far_away") && mechanism.requireBoolean()) {
            this.getLivingEntity().setRemoveWhenFarAway(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("sheared") && mechanism.requireBoolean() && this.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.getBukkitEntity()).setSheared(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("collidable") && mechanism.requireBoolean()) {
            this.getLivingEntity().setCollidable(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("no_damage_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setNoDamageTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("max_no_damage_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setMaximumNoDamageTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("velocity") && mechanism.requireObject(LocationTag.class)) {
            this.setVelocity(mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("move") && mechanism.requireObject(LocationTag.class)) {
            NMSHandler.getEntityHelper().move(this.getBukkitEntity(), mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("interact_with") && mechanism.requireObject(LocationTag.class)) {
            LocationTag interactLocation = mechanism.valueAsType(LocationTag.class);
            NMSHandler.getEntityHelper().forceInteraction(this.getPlayer(), interactLocation);
        }
        if (mechanism.matches("play_death")) {
            this.getLivingEntity().playEffect(EntityEffect.DEATH);
        }
        if ((mechanism.matches("pickup_delay") || mechanism.matches("pickupdelay")) && this.getBukkitEntity() instanceof Item && mechanism.requireObject(DurationTag.class)) {
            ((Item)this.getBukkitEntity()).setPickupDelay(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("gliding") && mechanism.requireBoolean()) {
            this.getLivingEntity().setGliding(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("glowing") && mechanism.requireBoolean()) {
            this.getBukkitEntity().setGlowing(mechanism.getValue().asBoolean());
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)this.getLivingEntity())) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)this.getLivingEntity()).data().setPersistent("glowing", (Object)mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("dragon_phase")) {
            EnderDragon ed = (EnderDragon)this.getLivingEntity();
            ed.setPhase(EnderDragon.Phase.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("experience") && this.getBukkitEntity() instanceof ExperienceOrb && mechanism.requireInteger()) {
            ((ExperienceOrb)this.getBukkitEntity()).setExperience(mechanism.getValue().asInt());
        }
        if (mechanism.matches("fuse_ticks") && this.getBukkitEntity() instanceof TNTPrimed && mechanism.requireInteger()) {
            ((TNTPrimed)this.getBukkitEntity()).setFuseTicks(mechanism.getValue().asInt());
        }
        if (mechanism.matches("show_to_players")) {
            NMSHandler.getEntityHelper().unhideEntity(null, this.getBukkitEntity());
        }
        if (mechanism.matches("hide_from_players")) {
            NMSHandler.getEntityHelper().hideEntity(null, this.getBukkitEntity(), false);
        }
        if (mechanism.matches("mirror_player") && mechanism.requireBoolean()) {
            if (this.isNPC()) {
                NPC npc = this.getDenizenNPC().getCitizen();
                if (!npc.hasTrait(MirrorTrait.class)) {
                    npc.addTrait(MirrorTrait.class);
                }
                MirrorTrait mirror = (MirrorTrait)npc.getTrait(MirrorTrait.class);
                if (mechanism.getValue().asBoolean()) {
                    mirror.enableMirror();
                } else {
                    mirror.disableMirror();
                }
            } else if (mechanism.getValue().asBoolean()) {
                ProfileEditor.mirrorUUIDs.add(this.getUUID());
            } else {
                ProfileEditor.mirrorUUIDs.remove(this.getUUID());
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && mechanism.matches("swimming") && mechanism.requireBoolean()) {
            this.getLivingEntity().setSwimming(mechanism.getValue().asBoolean());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    private class DespawnedEntity {
        Double health = null;
        Location location = null;
        ItemStack[] equipment = null;
        String custom_script = null;

        public DespawnedEntity(EntityTag entity) {
            if (entity != null) {
                this.health = entity.getLivingEntity().getHealth();
                this.location = entity.getLivingEntity().getLocation();
                this.equipment = entity.getLivingEntity().getEquipment().getArmorContents();
                if (CustomNBT.hasCustomNBT((Entity)entity.getLivingEntity(), "denizen-script-id")) {
                    this.custom_script = CustomNBT.getCustomNBT((Entity)entity.getLivingEntity(), "denizen-script-id");
                }
            }
        }
    }
}

