/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.objects.properties.material.MaterialLeaves;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchFace;
import com.denizenscript.denizen.scripts.commands.world.SwitchCommand;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.DirectionalBlocksHelper;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizen.utilities.blocks.OldMaterialsHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.world.PathFinder;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Bed;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Dispenser;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Dropper;
import org.bukkit.block.Furnace;
import org.bukkit.block.Lockable;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Attachable;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class LocationTag
extends Location
implements ObjectTag,
Notable,
Adjustable {
    public String backupWorld;
    private boolean is2D = false;
    private boolean raw = false;
    String prefix = "Location";
    public static ObjectTagProcessor<LocationTag> tagProcessor = new ObjectTagProcessor();

    public String getWorldName() {
        if (this.getWorld() != null) {
            return this.getWorld().getName();
        }
        return this.backupWorld;
    }

    public LocationTag clone() {
        return (LocationTag)super.clone();
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    @Note(value="Locations")
    public String getSaveObject() {
        return this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getPitch() + "," + this.getYaw() + "," + this.getWorldName();
    }

    public static String getSaved(LocationTag location) {
        for (LocationTag saved : NotableManager.getAllType(LocationTag.class)) {
            if (saved.getX() != location.getX() || saved.getY() != location.getY() || saved.getZ() != location.getZ() || saved.getYaw() != location.getYaw() || saved.getPitch() != location.getPitch() || (saved.getWorldName() != null || location.getWorldName() != null) && (saved.getWorldName() == null || location.getWorldName() == null || !saved.getWorldName().equals(location.getWorldName()))) continue;
            return NotableManager.getSavedId(saved);
        }
        return null;
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    public static LocationTag valueOf(String string) {
        return LocationTag.valueOf(string, null);
    }

    @Fetchable(value="l")
    public static LocationTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("l@")) {
            string = string.substring(2);
        }
        if (NotableManager.isSaved(string) && NotableManager.isType(string, LocationTag.class)) {
            return (LocationTag)NotableManager.getSavedObject(string);
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() == 2) {
            try {
                return new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 3) {
            try {
                World world = Bukkit.getWorld((String)split.get(2));
                if (world != null) {
                    return new LocationTag(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
                }
                if (ArgumentHelper.matchesDouble(split.get(2))) {
                    return new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                }
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
                output.backupWorld = split.get(2);
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 4) {
            try {
                World world = Bukkit.getWorld((String)split.get(3));
                if (world != null) {
                    return new LocationTag(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                }
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                output.backupWorld = split.get(3);
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 5) {
            try {
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 6) {
            try {
                World world = Bukkit.getWorld((String)split.get(5));
                if (world != null) {
                    return new LocationTag(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
                }
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
                output.backupWorld = split.get(5);
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (context == null || context.debug) {
            Debug.log("Minor: valueOf LocationTag returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.startsWith("l@")) {
            return true;
        }
        return LocationTag.valueOf(string, new BukkitTagContext(null, null, false, null, false, null)) != null;
    }

    public LocationTag(Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public LocationTag(Vector vector) {
        super(null, vector.getX(), vector.getY(), vector.getZ());
    }

    public LocationTag(World world, double x, double y) {
        this(world, x, y, 0.0);
        this.is2D = true;
    }

    public LocationTag(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public LocationTag(World world, double x, double y, double z, float pitch, float yaw) {
        super(world, x, y, z, yaw, pitch);
    }

    public boolean isChunkLoaded() {
        return this.getWorld() != null && this.getWorld().isChunkLoaded(this.getBlockX() >> 4, this.getBlockZ() >> 4);
    }

    public boolean isChunkLoadedSafe() {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
            boolean bl = this.isChunkLoaded();
            return bl;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Block getBlock() {
        if (this.getWorld() == null) {
            Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
            return null;
        }
        return super.getBlock();
    }

    public Block getBlockForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Block block = null;
                return block;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Block block = null;
                return block;
            }
            Block block = super.getBlock();
            return block;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Material getBlockTypeForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Material material = null;
                return material;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Material material = null;
                return material;
            }
            Material material = super.getBlock().getType();
            return material;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public static BlockState getBlockStateFor(Block block) {
        return block.getState();
    }

    public static BlockState getBlockStateSafe(Block block) {
        NMSHandler.getChunkHelper().changeChunkServerThread(block.getWorld());
        try {
            BlockState blockState = block.getState();
            return blockState;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(block.getWorld());
        }
    }

    public Biome getBiomeForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Biome biome = null;
                return biome;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Biome biome = null;
                return biome;
            }
            Biome biome = super.getBlock().getBiome();
            return biome;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Location getHighestBlockForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Location location = null;
                return location;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Location location = null;
                return location;
            }
            Location location = this.getWorld().getHighestBlockAt((Location)this).getLocation();
            return location;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ItemStack> getDropsForTag(Attribute attribute, ItemStack item) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Collection<ItemStack> collection = null;
                return collection;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Collection<ItemStack> collection = null;
                return collection;
            }
            Collection collection = item == null ? super.getBlock().getDrops() : super.getBlock().getDrops(item);
            return collection;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public BlockState getBlockState() {
        return LocationTag.getBlockStateFor(this.getBlock());
    }

    public BlockState getBlockStateForTag(Attribute attribute) {
        Block block = this.getBlockForTag(attribute);
        if (block == null) {
            return null;
        }
        return LocationTag.getBlockStateSafe(block);
    }

    public LocationTag getBlockLocation() {
        return new LocationTag(this.getWorld(), this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    private void setRaw(boolean state) {
        this.raw = state;
    }

    public void setPitch(float pitch) {
        super.setPitch(pitch);
    }

    public void setYaw(float yaw) {
        super.setYaw(yaw);
    }

    public boolean hasInventory() {
        return this.getBlockState() instanceof InventoryHolder;
    }

    public Inventory getBukkitInventory() {
        return this.hasInventory() ? ((InventoryHolder)this.getBlockState()).getInventory() : null;
    }

    public InventoryTag getInventory() {
        return this.hasInventory() ? InventoryTag.mirrorBukkitInventory(this.getBukkitInventory()) : null;
    }

    public BlockFace getSkullBlockFace(int rotation) {
        switch (rotation) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 2: {
                return BlockFace.NORTH_EAST;
            }
            case 3: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH_EAST;
            }
            case 7: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case 8: {
                return BlockFace.SOUTH;
            }
            case 9: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 10: {
                return BlockFace.SOUTH_WEST;
            }
            case 11: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 12: {
                return BlockFace.WEST;
            }
            case 13: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 14: {
                return BlockFace.NORTH_WEST;
            }
            case 15: {
                return BlockFace.NORTH_NORTH_WEST;
            }
        }
        return null;
    }

    public byte getSkullRotation(BlockFace face) {
        switch (face) {
            case NORTH: {
                return 0;
            }
            case NORTH_NORTH_EAST: {
                return 1;
            }
            case NORTH_EAST: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case EAST_SOUTH_EAST: {
                return 5;
            }
            case SOUTH_EAST: {
                return 6;
            }
            case SOUTH_SOUTH_EAST: {
                return 7;
            }
            case SOUTH: {
                return 8;
            }
            case SOUTH_SOUTH_WEST: {
                return 9;
            }
            case SOUTH_WEST: {
                return 10;
            }
            case WEST_SOUTH_WEST: {
                return 11;
            }
            case WEST: {
                return 12;
            }
            case WEST_NORTH_WEST: {
                return 13;
            }
            case NORTH_WEST: {
                return 14;
            }
            case NORTH_NORTH_WEST: {
                return 15;
            }
        }
        return -1;
    }

    public int compare(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null || loc1.equals((Object)loc2)) {
            return 0;
        }
        double dist = this.distanceSquared(loc1) - this.distanceSquared(loc2);
        return dist == 0.0 ? 0 : (dist > 0.0 ? 1 : -1);
    }

    public int hashCode() {
        return (int)(Math.floor(this.getX()) + Math.floor(this.getY()) + Math.floor(this.getZ()));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof LocationTag)) {
            return false;
        }
        LocationTag other = (LocationTag)o;
        if (other.getWorldName() == null && this.getWorldName() != null || this.getWorldName() == null && other.getWorldName() != null || this.getWorldName() != null && other.getWorldName() != null && !this.getWorldName().equalsIgnoreCase(other.getWorldName())) {
            return false;
        }
        return Math.floor(this.getX()) == Math.floor(other.getX()) && Math.floor(this.getY()) == Math.floor(other.getY()) && Math.floor(this.getZ()) == Math.floor(other.getZ());
    }

    @Override
    public String getObjectType() {
        return "Location";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public LocationTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "<Y>" + LocationTag.getSaved(this) + "<GR> (" + this.identifyRaw().replace(",", "<G>,<GR> ") + "<GR>)";
        }
        return "<Y>" + this.identifyRaw().replace(",", "<G>,<Y> ");
    }

    @Override
    public boolean isUnique() {
        return LocationTag.getSaved(this) != null;
    }

    @Override
    public String identify() {
        if (!this.raw && this.isUnique()) {
            return "l@" + LocationTag.getSaved(this);
        }
        return this.identifyRaw();
    }

    @Override
    public String identifySimple() {
        if (this.isUnique()) {
            return "l@" + LocationTag.getSaved(this);
        }
        if (this.getWorldName() == null) {
            return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "");
        }
        return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "") + "," + this.getWorldName();
    }

    public String identifyRaw() {
        if ((double)this.getYaw() != 0.0 || (double)this.getPitch() != 0.0) {
            return "l@" + CoreUtilities.doubleToString(this.getX()) + "," + CoreUtilities.doubleToString(this.getY()) + "," + CoreUtilities.doubleToString(this.getZ()) + "," + CoreUtilities.doubleToString(this.getPitch()) + "," + CoreUtilities.doubleToString(this.getYaw()) + (this.getWorldName() != null ? "," + this.getWorldName() : "");
        }
        return "l@" + CoreUtilities.doubleToString(this.getX()) + "," + CoreUtilities.doubleToString(this.getY()) + (!this.is2D ? "," + CoreUtilities.doubleToString(this.getZ()) : "") + (this.getWorldName() != null ? "," + this.getWorldName() : "");
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        LocationTag.registerTag("block_facing", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                Vector facing = DirectionalBlocksHelper.getFacing(object.getBlockForTag(attribute));
                if (facing != null) {
                    return new LocationTag(object.getWorld(), facing.getX(), facing.getY(), facing.getZ());
                }
                return null;
            }
        });
        LocationTag.registerTag("above", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new LocationTag(object.clone().add(0.0, attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0, 0.0));
            }
        });
        LocationTag.registerTag("below", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new LocationTag(object.clone().subtract(0.0, attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0, 0.0));
            }
        });
        LocationTag.registerTag("forward_flat", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                LocationTag loc = object.clone();
                loc.setPitch(0.0f);
                Vector vector = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
                return new LocationTag(object.clone().add(vector));
            }
        });
        LocationTag.registerTag("backward_flat", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                LocationTag loc = object.clone();
                loc.setPitch(0.0f);
                Vector vector = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
                return new LocationTag(object.clone().subtract(vector));
            }
        });
        LocationTag.registerTag("forward", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                Vector vector = object.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
                return new LocationTag(object.clone().add(vector));
            }
        });
        LocationTag.registerTag("backward", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                Vector vector = object.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
                return new LocationTag(object.clone().subtract(vector));
            }
        });
        LocationTag.registerTag("left", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                LocationTag loc = object.clone();
                loc.setPitch(0.0f);
                Vector vector = loc.getDirection().rotateAroundY(1.5707963267948966).multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
                return new LocationTag(object.clone().add(vector));
            }
        });
        LocationTag.registerTag("right", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                LocationTag loc = object.clone();
                loc.setPitch(0.0f);
                Vector vector = loc.getDirection().rotateAroundY(1.5707963267948966).multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
                return new LocationTag(object.clone().subtract(vector));
            }
        });
        LocationTag.registerTag("up", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                LocationTag loc = object.clone();
                loc.setPitch(loc.getPitch() - 90.0f);
                Vector vector = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
                return new LocationTag(object.clone().add(vector));
            }
        });
        LocationTag.registerTag("down", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                LocationTag loc = object.clone();
                loc.setPitch(loc.getPitch() - 90.0f);
                Vector vector = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
                return new LocationTag(object.clone().subtract(vector));
            }
        });
        LocationTag.registerTag("relative", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag offsetLoc = LocationTag.valueOf(attribute.getContext(1));
                if (offsetLoc == null) {
                    return null;
                }
                LocationTag loc = object.clone();
                Vector offset = loc.getDirection().multiply(offsetLoc.getZ());
                loc.setPitch(loc.getPitch() - 90.0f);
                offset = offset.add(loc.getDirection().multiply(offsetLoc.getY()));
                loc.setPitch(0.0f);
                offset = offset.add(loc.getDirection().rotateAroundY(1.5707963267948966).multiply(offsetLoc.getX()));
                return new LocationTag(object.clone().add(offset));
            }
        });
        LocationTag.registerTag("block", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new LocationTag(object.getWorld(), object.getBlockX(), object.getBlockY(), object.getBlockZ());
            }
        });
        LocationTag.registerTag("center", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new LocationTag(object.getWorld(), (double)object.getBlockX() + 0.5, (double)object.getBlockY() + 0.5, (double)object.getBlockZ() + 0.5);
            }
        });
        LocationTag.registerTag("highest", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new LocationTag(object.getHighestBlockForTag(attribute).add(0.0, -1.0, 0.0));
            }
        });
        LocationTag.registerTag("base_color", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                DyeColor color;
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    Debug.echoError("Base_Color tag no longer relevant: banner types are now distinct materials.");
                }
                return new ElementTag((color = ((Banner)object.getBlockStateForTag(attribute)).getBaseColor()) != null ? color.name() : "BLACK");
            }
        });
        LocationTag.registerTag("has_inventory", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(object.getBlockStateForTag(attribute) instanceof InventoryHolder);
            }
        });
        LocationTag.registerTag("inventory", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!object.isChunkLoadedSafe()) {
                    return null;
                }
                InventoryTag obj = ElementTag.handleNull(object.identify() + ".inventory", object.getInventory(), "InventoryTag", attribute.hasAlternative());
                return obj == null ? null : obj;
            }
        });
        LocationTag.registerTag("material", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                Block block = object.getBlockForTag(attribute);
                if (block == null) {
                    return null;
                }
                return new MaterialTag(block);
            }
        });
        LocationTag.registerTag("patterns", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                ListTag list = new ListTag();
                for (Pattern pattern : ((Banner)object.getBlockStateForTag(attribute)).getPatterns()) {
                    list.add(pattern.getColor().name() + "/" + pattern.getPattern().name());
                }
                return list;
            }
        });
        LocationTag.registerTag("head_rotation", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(object.getSkullRotation(((Skull)object.getBlockStateForTag(attribute)).getRotation()) + 1);
            }
        });
        LocationTag.registerTag("switched", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(SwitchCommand.switchState(object.getBlockForTag(attribute)));
            }
        });
        LocationTag.registerTag("sign_contents", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (object.getBlockStateForTag(attribute) instanceof Sign) {
                    return new ListTag(Arrays.asList(((Sign)object.getBlockStateForTag(attribute)).getLines()));
                }
                return null;
            }
        });
        LocationTag.registerTag("spawner_type", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (object.getBlockStateForTag(attribute) instanceof CreatureSpawner) {
                    return new EntityTag(DenizenEntityType.getByName(((CreatureSpawner)object.getBlockStateForTag(attribute)).getSpawnedType().name()));
                }
                return null;
            }
        });
        LocationTag.registerTag("lock", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!(object.getBlockStateForTag(attribute) instanceof Lockable)) {
                    return null;
                }
                Lockable lock = (Lockable)object.getBlockStateForTag(attribute);
                return new ElementTag(lock.isLocked() ? lock.getLock() : null);
            }
        });
        LocationTag.registerTag("is_locked", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!(object.getBlockStateForTag(attribute) instanceof Lockable)) {
                    return null;
                }
                return new ElementTag(((Lockable)object.getBlockStateForTag(attribute)).isLocked());
            }
        });
        LocationTag.registerTag("is_lockable", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(object.getBlockStateForTag(attribute) instanceof Lockable);
            }
        });
        LocationTag.registerTag("drops", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                ItemStack inputItem = null;
                if (attribute.hasContext(1)) {
                    inputItem = ItemTag.valueOf(attribute.getContext(1), attribute.context).getItemStack();
                }
                ListTag list = new ListTag();
                for (ItemStack it : object.getDropsForTag(attribute, inputItem)) {
                    list.add(new ItemTag(it).identify());
                }
                return list;
            }
        });
        LocationTag.registerTag("flowerpot_contents", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    Debug.echoError("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
                } else if (object.getBlockTypeForTag(attribute) == Material.FLOWER_POT) {
                    MaterialData contents = NMSHandler.getBlockHelper().getFlowerpotContents(object.getBlockForTag(attribute));
                    return OldMaterialsHelper.getMaterialFrom(contents.getItemType(), contents.getData());
                }
                return null;
            }
        });
        LocationTag.registerTag("skull_type", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                BlockState blockState = object.getBlockStateForTag(attribute);
                if (blockState instanceof Skull) {
                    String t = ((Skull)blockState).getSkullType().name();
                    return new ElementTag(t);
                }
                return null;
            }
        });
        LocationTag.registerTag("skull_name", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                BlockState blockState = object.getBlockStateForTag(attribute);
                if (blockState instanceof Skull) {
                    PlayerProfile profile = NMSHandler.getBlockHelper().getPlayerProfile((Skull)blockState);
                    if (profile == null) {
                        return null;
                    }
                    String n = profile.getName();
                    if (n == null) {
                        n = ((Skull)blockState).getOwningPlayer().getName();
                    }
                    return new ElementTag(n);
                }
                return null;
            }
        });
        LocationTag.registerTag("skull_skin", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                BlockState blockState = object.getBlockStateForTag(attribute);
                if (blockState instanceof Skull) {
                    PlayerProfile profile = NMSHandler.getBlockHelper().getPlayerProfile((Skull)blockState);
                    if (profile == null) {
                        return null;
                    }
                    String name = profile.getName();
                    UUID uuid = profile.getUniqueId();
                    String texture = profile.getTexture();
                    if (attribute.startsWith("full", 2)) {
                        attribute.fulfill(1);
                        return new ElementTag((uuid != null ? uuid : name) + (texture != null ? "|" + texture : ""));
                    }
                    return new ElementTag(uuid != null ? uuid.toString() : name);
                }
                return null;
            }
        });
        LocationTag.registerTag("simple", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (attribute.startsWith("formatted", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag("X '" + object.getBlockX() + "', Y '" + object.getBlockY() + "', Z '" + object.getBlockZ() + "', in world '" + object.getWorldName() + "'");
                }
                if (object.getWorldName() == null) {
                    return new ElementTag(object.getBlockX() + "," + object.getBlockY() + "," + object.getBlockZ());
                }
                return new ElementTag(object.getBlockX() + "," + object.getBlockY() + "," + object.getBlockZ() + "," + object.getWorldName());
            }
        });
        LocationTag.registerTag("precise_impact_normal", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                int range = attribute.getIntContext(1);
                if (range < 1) {
                    range = 200;
                }
                double xzLen = Math.cos((double)(object.getPitch() % 360.0f) * (Math.PI / 180));
                double nx = xzLen * Math.sin((double)(-object.getYaw()) * (Math.PI / 180));
                double ny = Math.sin((double)object.getPitch() * (Math.PI / 180));
                double nz = xzLen * Math.cos((double)object.getYaw() * (Math.PI / 180));
                Location location = NMSHandler.getEntityHelper().getImpactNormal(object, new Vector(nx, -ny, nz), range);
                if (location != null) {
                    return new LocationTag(location);
                }
                return null;
            }
        });
        LocationTag.registerTag("precise_cursor_on_block", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                int range = attribute.getIntContext(1);
                if (range < 1) {
                    range = 200;
                }
                double xzLen = Math.cos((double)(object.getPitch() % 360.0f) * (Math.PI / 180));
                double nx = xzLen * Math.sin((double)(-object.getYaw()) * (Math.PI / 180));
                double ny = Math.sin((double)object.getPitch() * (Math.PI / 180));
                double nz = xzLen * Math.cos((double)object.getYaw() * (Math.PI / 180));
                Location location = NMSHandler.getEntityHelper().rayTraceBlock(object, new Vector(nx, -ny, nz), range);
                if (location != null) {
                    return new LocationTag(location).getBlockLocation();
                }
                return null;
            }
        });
        LocationTag.registerTag("precise_cursor_on", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                int range = attribute.getIntContext(1);
                if (range < 1) {
                    range = 200;
                }
                double xzLen = Math.cos((double)(object.getPitch() % 360.0f) * (Math.PI / 180));
                double nx = xzLen * Math.sin((double)(-object.getYaw()) * (Math.PI / 180));
                double ny = Math.sin((double)object.getPitch() * (Math.PI / 180));
                double nz = xzLen * Math.cos((double)object.getYaw() * (Math.PI / 180));
                Location location = NMSHandler.getEntityHelper().rayTrace(object, new Vector(nx, -ny, nz), range);
                if (location != null) {
                    return new LocationTag(location);
                }
                return null;
            }
        });
        LocationTag.registerTag("points_between", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                LocationTag target = LocationTag.valueOf(attribute.getContext(1));
                if (target == null) {
                    return null;
                }
                double rad = 1.0;
                if (attribute.startsWith("distance", 2)) {
                    rad = attribute.getDoubleContext(2);
                    attribute.fulfill(1);
                }
                ListTag list = new ListTag();
                Vector rel = target.toVector().subtract(object.toVector());
                double len = rel.length();
                rel = rel.multiply(1.0 / len);
                for (double i = 0.0; i <= len; i += rad) {
                    list.add(new LocationTag(object.clone().add(rel.clone().multiply(i))).identify());
                }
                return list;
            }
        });
        LocationTag.registerTag("facing_blocks", new TagRunnable.ObjectForm<LocationTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                int range = attribute.getIntContext(1);
                if (range < 1) {
                    range = 100;
                }
                ListTag list = new ListTag();
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                    BlockIterator iterator = new BlockIterator((Location)object, 0.0, range);
                    while (iterator.hasNext()) {
                        list.add(new LocationTag(iterator.next().getLocation()).identify());
                    }
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                }
                return list;
            }
        });
        LocationTag.registerTag("line_of_sight", new TagRunnable.ObjectForm<LocationTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag location = LocationTag.valueOf(attribute.getContext(1));
                if (location != null) {
                    try {
                        NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                        ElementTag elementTag = new ElementTag(NMSHandler.getEntityHelper().canTrace(object.getWorld(), object.toVector(), location.toVector()));
                        return elementTag;
                    }
                    finally {
                        NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                    }
                }
                return null;
            }
        });
        LocationTag.registerTag("direction", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (attribute.startsWith("vector", 2)) {
                    double xzLen = Math.cos((double)(object.getPitch() % 360.0f) * (Math.PI / 180));
                    double nx = xzLen * Math.sin((double)(-object.getYaw()) * (Math.PI / 180));
                    double ny = Math.sin((double)object.getPitch() * (Math.PI / 180));
                    double nz = xzLen * Math.cos((double)object.getYaw() * (Math.PI / 180));
                    attribute.fulfill(1);
                    return new LocationTag(object.getWorld(), nx, -ny, nz);
                }
                if (attribute.hasContext(1) && LocationTag.matches(attribute.getContext(1))) {
                    LocationTag target = LocationTag.valueOf(attribute.getContext(1));
                    EntityHelper entityHelper = NMSHandler.getEntityHelper();
                    if (attribute.startsWith("yaw", 2)) {
                        attribute.fulfill(1);
                        return new ElementTag(entityHelper.normalizeYaw(entityHelper.getYaw(target.toVector().subtract(object.toVector()).normalize())));
                    }
                    return new ElementTag(entityHelper.getCardinal(entityHelper.getYaw(target.toVector().subtract(object.toVector()).normalize())));
                }
                return new ElementTag(NMSHandler.getEntityHelper().getCardinal(object.getYaw()));
            }
        });
        LocationTag.registerTag("face", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag two = LocationTag.valueOf(attribute.getContext(1));
                return new LocationTag(NMSHandler.getEntityHelper().faceLocation(object, (Location)two));
            }
        });
        LocationTag.registerTag("facing", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (attribute.hasContext(1)) {
                    LocationTag facingLoc;
                    int degrees = 45;
                    if (LocationTag.matches(attribute.getContext(1))) {
                        facingLoc = LocationTag.valueOf(attribute.getContext(1));
                    } else if (EntityTag.matches(attribute.getContext(1))) {
                        facingLoc = EntityTag.valueOf(attribute.getContext(1)).getLocation();
                    } else {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Tag location.facing[...] was given an invalid facing target.");
                        }
                        return null;
                    }
                    if (attribute.startsWith("degrees", 2) && attribute.hasContext(2)) {
                        String context = attribute.getContext(2);
                        attribute.fulfill(1);
                        if (context.contains(",")) {
                            String yaw = context.substring(0, context.indexOf(44));
                            String pitch = context.substring(context.indexOf(44) + 1);
                            degrees = ArgumentHelper.getIntegerFrom(yaw);
                            int pitchDegrees = ArgumentHelper.getIntegerFrom(pitch);
                            return new ElementTag(NMSHandler.getEntityHelper().isFacingLocation(object, facingLoc, degrees, pitchDegrees));
                        }
                        degrees = attribute.getIntContext(2);
                    }
                    return new ElementTag(NMSHandler.getEntityHelper().isFacingLocation(object, (Location)facingLoc, (float)degrees));
                }
                return null;
            }
        });
        LocationTag.registerTag("pitch", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(object.getPitch());
            }
        });
        LocationTag.registerTag("with_pose", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                String context = attribute.getContext(1);
                float pitch = 0.0f;
                float yaw = 0.0f;
                if (EntityTag.matches(context)) {
                    EntityTag ent = EntityTag.valueOf(context);
                    if (ent.isSpawnedOrValidForTag()) {
                        pitch = ent.getBukkitEntity().getLocation().getPitch();
                        yaw = ent.getBukkitEntity().getLocation().getYaw();
                    }
                } else if (context.split(",").length == 2) {
                    String[] split = context.split(",");
                    pitch = Float.parseFloat(split[0]);
                    yaw = Float.parseFloat(split[1]);
                }
                LocationTag loc = LocationTag.valueOf(object.identify());
                loc.setPitch(pitch);
                loc.setYaw(yaw);
                return loc;
            }
        });
        LocationTag.registerTag("yaw", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (attribute.startsWith("simple", 2)) {
                    attribute.fulfill(1);
                    float yaw = NMSHandler.getEntityHelper().normalizeYaw(object.getYaw());
                    if (yaw < 45.0f) {
                        return new ElementTag("South");
                    }
                    if (yaw < 135.0f) {
                        return new ElementTag("West");
                    }
                    if (yaw < 225.0f) {
                        return new ElementTag("North");
                    }
                    if (yaw < 315.0f) {
                        return new ElementTag("East");
                    }
                    return new ElementTag("South");
                }
                if (attribute.startsWith("raw", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(object.getYaw());
                }
                return new ElementTag(NMSHandler.getEntityHelper().normalizeYaw(object.getYaw()));
            }
        });
        LocationTag.registerTag("rotate_around_x", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                double angle = attribute.getDoubleContext(1);
                double cos = Math.cos(angle);
                double sin = Math.sin(angle);
                double y = object.getY() * cos - object.getZ() * sin;
                double z = object.getY() * sin + object.getZ() * cos;
                LocationTag location = object.clone();
                location.setY(y);
                location.setZ(z);
                return new LocationTag(location);
            }
        });
        LocationTag.registerTag("rotate_around_y", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                double angle = attribute.getDoubleContext(1);
                double cos = Math.cos(angle);
                double sin = Math.sin(angle);
                double x = object.getX() * cos + object.getZ() * sin;
                double z = object.getX() * -sin + object.getZ() * cos;
                LocationTag location = object.clone();
                location.setX(x);
                location.setZ(z);
                return new LocationTag(location);
            }
        });
        LocationTag.registerTag("rotate_around_z", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                double angle = attribute.getDoubleContext(1);
                double cos = Math.cos(angle);
                double sin = Math.sin(angle);
                double x = object.getX() * cos - object.getY() * sin;
                double y = object.getZ() * sin + object.getY() * cos;
                LocationTag location = object.clone();
                location.setX(x);
                location.setY(y);
                return new LocationTag(location);
            }
        });
        LocationTag.registerTag("find", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, final LocationTag object) {
                if (!attribute.startsWith("within", 3) || !attribute.hasContext(3)) {
                    return null;
                }
                double radius = attribute.getDoubleContext(3);
                if (attribute.startsWith("blocks", 2)) {
                    ArrayList<LocationTag> found = new ArrayList<LocationTag>();
                    List<Object> materials = new ArrayList();
                    if (attribute.hasContext(2)) {
                        materials = ListTag.valueOf(attribute.getContext(2)).filter(MaterialTag.class, attribute.context);
                    }
                    if (materials == null) {
                        return null;
                    }
                    int max = Settings.blockTagsMaxBlocks();
                    int index = 0;
                    attribute.fulfill(2);
                    Location tstart = object.getBlockForTag(attribute).getLocation();
                    double tstartY = tstart.getY();
                    int radiusInt = (int)radius;
                    block0: for (int x = -radiusInt; x <= radiusInt; ++x) {
                        for (int y = -radiusInt; y <= radiusInt; ++y) {
                            double newY = (double)y + tstartY;
                            if (newY < 0.0 || newY > 255.0) continue;
                            for (int z = -radiusInt; z <= radiusInt; ++z) {
                                if (++index > max) break block0;
                                if (!Utilities.checkLocation(object, tstart.clone().add((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), radius)) continue;
                                if (!materials.isEmpty()) {
                                    for (MaterialTag materialTag : materials) {
                                        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && materialTag.hasData() && materialTag.getData() != 0) {
                                            BlockState bs = new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)).getBlockStateForTag(attribute);
                                            if (bs == null || !materialTag.matchesMaterialData(bs.getData())) continue;
                                            found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                                            continue;
                                        }
                                        if (materialTag.getMaterial() != new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)).getBlockTypeForTag(attribute)) continue;
                                        found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                                    }
                                    continue;
                                }
                                found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                            }
                        }
                    }
                    Collections.sort(found, new Comparator<LocationTag>(){

                        @Override
                        public int compare(LocationTag loc1, LocationTag loc2) {
                            return object.compare(loc1, loc2);
                        }
                    });
                    return new ListTag((Collection<? extends ObjectTag>)found);
                }
                if (attribute.startsWith("surface_blocks", 2)) {
                    ArrayList<LocationTag> found = new ArrayList<LocationTag>();
                    List<Object> materials = new ArrayList();
                    if (attribute.hasContext(2)) {
                        materials = ListTag.valueOf(attribute.getContext(2)).filter(MaterialTag.class, attribute.context);
                    }
                    if (materials == null) {
                        return null;
                    }
                    int max = Settings.blockTagsMaxBlocks();
                    int index = 0;
                    attribute.fulfill(2);
                    LocationTag blockLoc = object.getBlockLocation();
                    Location loc = blockLoc.clone().add(0.5, 0.5, 0.5);
                    block4: for (double x = -radius; x <= radius; x += 1.0) {
                        for (double y = -radius; y <= radius; y += 1.0) {
                            for (double z = -radius; z <= radius; z += 1.0) {
                                if (++index > max) break block4;
                                if (!Utilities.checkLocation(loc, blockLoc.clone().add(x + 0.5, y + 0.5, z + 0.5), radius)) continue;
                                LocationTag l = new LocationTag(blockLoc.clone().add(x, y, z));
                                if (!materials.isEmpty()) {
                                    for (MaterialTag materialTag : materials) {
                                        if (!materialTag.matchesBlock(l.getBlockForTag(attribute)) || new LocationTag(l.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || new LocationTag(l.clone().add(0.0, 2.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || l.getBlockTypeForTag(attribute) == Material.AIR) continue;
                                        found.add(new LocationTag(blockLoc.clone().add(x + 0.5, y, z + 0.5)));
                                    }
                                    continue;
                                }
                                if (new LocationTag(l.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || new LocationTag(l.clone().add(0.0, 2.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || l.getBlockTypeForTag(attribute) == Material.AIR) continue;
                                found.add(new LocationTag(blockLoc.clone().add(x + 0.5, y, z + 0.5)));
                            }
                        }
                    }
                    Collections.sort(found, new Comparator<LocationTag>(){

                        @Override
                        public int compare(LocationTag loc1, LocationTag loc2) {
                            return object.compare(loc1, loc2);
                        }
                    });
                    return new ListTag((Collection<? extends ObjectTag>)found);
                }
                if (attribute.startsWith("players", 2)) {
                    ArrayList<PlayerTag> found = new ArrayList<PlayerTag>();
                    attribute.fulfill(2);
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (player.isDead() || !Utilities.checkLocation(object, player.getLocation(), radius)) continue;
                        found.add(new PlayerTag(player));
                    }
                    Collections.sort(found, new Comparator<PlayerTag>(){

                        @Override
                        public int compare(PlayerTag pl1, PlayerTag pl2) {
                            return object.compare(pl1.getLocation(), pl2.getLocation());
                        }
                    });
                    return new ListTag((Collection<? extends ObjectTag>)found);
                }
                if (attribute.startsWith("npcs", 2)) {
                    ArrayList<NPCTag> found = new ArrayList<NPCTag>();
                    attribute.fulfill(2);
                    for (NPC npc : CitizensAPI.getNPCRegistry()) {
                        if (!npc.isSpawned() || !Utilities.checkLocation(object.getBlockForTag(attribute).getLocation(), npc.getStoredLocation(), radius)) continue;
                        found.add(new NPCTag(npc));
                    }
                    Collections.sort(found, new Comparator<NPCTag>(){

                        @Override
                        public int compare(NPCTag npc1, NPCTag npc2) {
                            return object.compare(npc1.getLocation(), npc2.getLocation());
                        }
                    });
                    return new ListTag((Collection<? extends ObjectTag>)found);
                }
                if (attribute.startsWith("entities", 2)) {
                    ListTag ent_list = new ListTag();
                    if (attribute.hasContext(2)) {
                        ent_list = ListTag.valueOf(attribute.getContext(2));
                    }
                    ArrayList<EntityTag> found = new ArrayList<EntityTag>();
                    attribute.fulfill(2);
                    block10: for (Entity entity : new WorldTag(object.getWorld()).getEntitiesForTag()) {
                        if (!Utilities.checkLocation(object, entity.getLocation(), radius)) continue;
                        EntityTag current = new EntityTag(entity);
                        if (!ent_list.isEmpty()) {
                            for (String ent : ent_list) {
                                if (!current.comparedTo(ent)) continue;
                                found.add(current);
                                continue block10;
                            }
                            continue;
                        }
                        found.add(current);
                    }
                    Collections.sort(found, new Comparator<EntityTag>(){

                        @Override
                        public int compare(EntityTag ent1, EntityTag ent2) {
                            return object.compare(ent1.getLocation(), ent2.getLocation());
                        }
                    });
                    return new ListTag((Collection<? extends ObjectTag>)found);
                }
                if (attribute.startsWith("living_entities", 2)) {
                    ArrayList<EntityTag> found = new ArrayList<EntityTag>();
                    attribute.fulfill(2);
                    for (Entity entity : new WorldTag(object.getWorld()).getEntitiesForTag()) {
                        if (!(entity instanceof LivingEntity) || !Utilities.checkLocation(object, entity.getLocation(), radius)) continue;
                        found.add(new EntityTag(entity));
                    }
                    Collections.sort(found, new Comparator<EntityTag>(){

                        @Override
                        public int compare(EntityTag ent1, EntityTag ent2) {
                            return object.compare(ent1.getLocation(), ent2.getLocation());
                        }
                    });
                    return new ListTag((Collection<? extends ObjectTag>)found);
                }
                return null;
            }
        });
        LocationTag.registerTag("find_path", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag two = LocationTag.valueOf(attribute.getContext(1));
                if (two == null) {
                    return null;
                }
                List<LocationTag> locs = PathFinder.getPath(object, two);
                ListTag list = new ListTag();
                for (LocationTag loc : locs) {
                    list.add(loc.identify());
                }
                return list;
            }
        });
        LocationTag.registerTag("formatted", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (attribute.startsWith("citzens", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(object.getX() + ":" + object.getY() + ":" + object.getZ() + ":" + object.getWorldName());
                }
                return new ElementTag("X '" + object.getX() + "', Y '" + object.getY() + "', Z '" + object.getZ() + "', in world '" + object.getWorldName() + "'");
            }
        });
        LocationTag.registerTag("chunk", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ChunkTag(object);
            }
        });
        LocationTag.registerTag("get_chunk", LocationTag.tagProcessor.registeredObjectTags.get("chunk"));
        LocationTag.registerTag("raw", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                LocationTag rawLocation = new LocationTag(object);
                rawLocation.setRaw(true);
                return rawLocation;
            }
        });
        LocationTag.registerTag("world", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return WorldTag.mirrorBukkitWorld(object.getWorld());
            }
        });
        LocationTag.registerTag("x", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(object.getX());
            }
        });
        LocationTag.registerTag("y", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(object.getY());
            }
        });
        LocationTag.registerTag("z", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(object.getZ());
            }
        });
        LocationTag.registerTag("with_x", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag output = object.clone();
                output.setX(attribute.getDoubleContext(1));
                return output;
            }
        });
        LocationTag.registerTag("with_y", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag output = object.clone();
                output.setY(attribute.getDoubleContext(1));
                return output;
            }
        });
        LocationTag.registerTag("with_z", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag output = object.clone();
                output.setZ(attribute.getDoubleContext(1));
                return output;
            }
        });
        LocationTag.registerTag("with_yaw", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag output = object.clone();
                output.setYaw((float)attribute.getDoubleContext(1));
                return output;
            }
        });
        LocationTag.registerTag("with_pitch", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag output = object.clone();
                output.setPitch((float)attribute.getDoubleContext(1));
                return output;
            }
        });
        LocationTag.registerTag("with_world", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                LocationTag output = object.clone();
                WorldTag world = WorldTag.valueOf(attribute.getContext(1));
                output.setWorld(world.getWorld());
                return output;
            }
        });
        LocationTag.registerTag("notable_name", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                String notname = NotableManager.getSavedId(object);
                if (notname == null) {
                    return null;
                }
                return new ElementTag(notname);
            }
        });
        LocationTag.registerTag("add", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
                if (ints.length >= 3) {
                    if ((ArgumentHelper.matchesDouble(ints[0]) || ArgumentHelper.matchesInteger(ints[0])) && (ArgumentHelper.matchesDouble(ints[1]) || ArgumentHelper.matchesInteger(ints[1])) && (ArgumentHelper.matchesDouble(ints[2]) || ArgumentHelper.matchesInteger(ints[2]))) {
                        return new LocationTag(object.clone().add(Double.valueOf(ints[0]), Double.valueOf(ints[1]), Double.valueOf(ints[2])));
                    }
                } else if (LocationTag.matches(attribute.getContext(1))) {
                    return new LocationTag(object.clone().add(LocationTag.valueOf(attribute.getContext(1))));
                }
                return null;
            }
        });
        LocationTag.registerTag("sub", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
                if (ints.length == 3 || ints.length == 4) {
                    if ((ArgumentHelper.matchesDouble(ints[0]) || ArgumentHelper.matchesInteger(ints[0])) && (ArgumentHelper.matchesDouble(ints[1]) || ArgumentHelper.matchesInteger(ints[1])) && (ArgumentHelper.matchesDouble(ints[2]) || ArgumentHelper.matchesInteger(ints[2]))) {
                        return new LocationTag(object.clone().subtract(Double.valueOf(ints[0]), Double.valueOf(ints[1]), Double.valueOf(ints[2])));
                    }
                } else if (LocationTag.matches(attribute.getContext(1))) {
                    return new LocationTag(object.clone().subtract(LocationTag.valueOf(attribute.getContext(1))));
                }
                return null;
            }
        });
        LocationTag.registerTag("mul", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                return new LocationTag(object.clone().multiply(Double.parseDouble(attribute.getContext(1))));
            }
        });
        LocationTag.registerTag("div", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                return new LocationTag(object.clone().multiply(1.0 / Double.parseDouble(attribute.getContext(1))));
            }
        });
        LocationTag.registerTag("normalize", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                double len = Math.sqrt(Math.pow(object.getX(), 2.0) + Math.pow(object.getY(), 2.0) + Math.pow(object.getZ(), 2.0));
                if (len == 0.0) {
                    len = 1.0;
                }
                return new LocationTag(object.clone().multiply(1.0 / len));
            }
        });
        LocationTag.registerTag("vector_length", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(Math.sqrt(Math.pow(object.getX(), 2.0) + Math.pow(object.getY(), 2.0) + Math.pow(object.getZ(), 2.0)));
            }
        });
        LocationTag.registerTag("vector_to_face", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                BlockFace face = Utilities.faceFor(object.toVector());
                if (face != null) {
                    return new ElementTag(face.name());
                }
                return null;
            }
        });
        LocationTag.registerTag("distance_squared", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                if (LocationTag.matches(attribute.getContext(1))) {
                    LocationTag toLocation = LocationTag.valueOf(attribute.getContext(1));
                    if (!object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Can't measure distance between two different worlds!");
                        }
                        return null;
                    }
                    return new ElementTag(object.distanceSquared(toLocation));
                }
                return null;
            }
        });
        LocationTag.registerTag("distance", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                if (LocationTag.matches(attribute.getContext(1))) {
                    LocationTag toLocation = LocationTag.valueOf(attribute.getContext(1));
                    if (attribute.startsWith("horizontal", 2)) {
                        if (attribute.startsWith("multiworld", 3)) {
                            attribute.fulfill(2);
                            return new ElementTag(Math.sqrt(Math.pow(object.getX() - toLocation.getX(), 2.0) + Math.pow(object.getZ() - toLocation.getZ(), 2.0)));
                        }
                        attribute.fulfill(1);
                        if (object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                            return new ElementTag(Math.sqrt(Math.pow(object.getX() - toLocation.getX(), 2.0) + Math.pow(object.getZ() - toLocation.getZ(), 2.0)));
                        }
                    } else if (attribute.startsWith("vertical", 2)) {
                        if (attribute.startsWith("multiworld", 3)) {
                            attribute.fulfill(2);
                            return new ElementTag(Math.abs(object.getY() - toLocation.getY()));
                        }
                        attribute.fulfill(1);
                        if (object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                            return new ElementTag(Math.abs(object.getY() - toLocation.getY()));
                        }
                    }
                    if (!object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Can't measure distance between two different worlds!");
                        }
                        return null;
                    }
                    return new ElementTag(object.distance(toLocation));
                }
                return null;
            }
        });
        LocationTag.registerTag("is_within_border", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(object.getWorld().getWorldBorder().isInside((Location)object));
            }
        });
        LocationTag.registerTag("is_within", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                if (EllipsoidTag.matches(attribute.getContext(1))) {
                    EllipsoidTag ellipsoid = EllipsoidTag.valueOf(attribute.getContext(1));
                    if (ellipsoid != null) {
                        return new ElementTag(ellipsoid.contains(object));
                    }
                } else {
                    CuboidTag cuboid = CuboidTag.valueOf(attribute.getContext(1));
                    if (cuboid != null) {
                        return new ElementTag(cuboid.isInsideCuboid(object));
                    }
                }
                return null;
            }
        });
        LocationTag.registerTag("biome", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (attribute.startsWith("formatted", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(CoreUtilities.toLowerCase(object.getBiomeForTag(attribute).name()).replace('_', ' '));
                }
                return new BiomeTag(object.getBiomeForTag(attribute));
            }
        });
        LocationTag.registerTag("cuboids", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                List<CuboidTag> cuboids = CuboidTag.getNotableCuboidsContaining(object);
                ListTag cuboid_list = new ListTag();
                for (CuboidTag cuboid : cuboids) {
                    cuboid_list.add(cuboid.identify());
                }
                return cuboid_list;
            }
        });
        LocationTag.registerTag("ellipsoids", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                List<EllipsoidTag> ellipsoids = EllipsoidTag.getNotableEllipsoidsContaining(object);
                ListTag ellipsoid_list = new ListTag();
                for (EllipsoidTag ellipsoid : ellipsoids) {
                    ellipsoid_list.add(ellipsoid.identify());
                }
                return ellipsoid_list;
            }
        });
        LocationTag.registerTag("is_liquid", new TagRunnable.ObjectForm<LocationTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                Block b = object.getBlockForTag(attribute);
                if (b != null) {
                    try {
                        NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                        ElementTag elementTag = new ElementTag(b.isLiquid());
                        return elementTag;
                    }
                    finally {
                        NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                    }
                }
                return null;
            }
        });
        LocationTag.registerTag("light", new TagRunnable.ObjectForm<LocationTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                Block b = object.getBlockForTag(attribute);
                if (b != null) {
                    try {
                        NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                        if (attribute.startsWith("blocks", 2)) {
                            attribute.fulfill(1);
                            ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightFromBlocks());
                            return elementTag;
                        }
                        if (attribute.startsWith("sky", 2)) {
                            attribute.fulfill(1);
                            ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightFromSky());
                            return elementTag;
                        }
                        ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightLevel());
                        return elementTag;
                    }
                    finally {
                        NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                    }
                }
                return null;
            }
        });
        LocationTag.registerTag("power", new TagRunnable.ObjectForm<LocationTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                Block b = object.getBlockForTag(attribute);
                if (b != null) {
                    try {
                        NMSHandler.getChunkHelper().changeChunkServerThread(object.getWorld());
                        ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getBlockPower());
                        return elementTag;
                    }
                    finally {
                        NMSHandler.getChunkHelper().restoreServerThread(object.getWorld());
                    }
                }
                return null;
            }
        });
        LocationTag.registerTag("tree_distance", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                MaterialTag material = new MaterialTag(object.getBlockForTag(attribute));
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && MaterialLeaves.describes(material)) {
                    return new ElementTag(MaterialLeaves.getFrom(material).getDistance());
                }
                return null;
            }
        });
        LocationTag.registerTag("type", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag("Location");
            }
        });
        LocationTag.registerTag("command_block_name", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!(object.getBlockStateForTag(attribute) instanceof CommandBlock)) {
                    return null;
                }
                return new ElementTag(((CommandBlock)object.getBlockStateForTag(attribute)).getName());
            }
        });
        LocationTag.registerTag("command_block", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (!(object.getBlockStateForTag(attribute) instanceof CommandBlock)) {
                    return null;
                }
                return new ElementTag(((CommandBlock)object.getBlockStateForTag(attribute)).getCommand());
            }
        });
        LocationTag.registerTag("furnace_burn_time", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getBurnTime());
            }
        });
        LocationTag.registerTag("furnace_cook_time", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getCookTime());
            }
        });
        LocationTag.registerTag("furnace_cook_time_total", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                return new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getCookTimeTotal());
            }
        });
        LocationTag.registerTag("attached_to", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                BlockFace face = BlockFace.SELF;
                MaterialTag material = new MaterialTag(object.getBlockForTag(attribute));
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && MaterialSwitchFace.describes(material)) {
                    face = MaterialSwitchFace.getFrom(material).getAttachedTo();
                } else {
                    MaterialData data = object.getBlockStateForTag(attribute).getData();
                    if (data instanceof Attachable) {
                        face = ((Attachable)data).getAttachedFace();
                    }
                }
                if (face != BlockFace.SELF) {
                    return new LocationTag(object.getBlockForTag(attribute).getRelative(face).getLocation());
                }
                return null;
            }
        });
        LocationTag.registerTag("other_block", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                BlockState state = object.getBlockStateForTag(attribute);
                if (state instanceof Chest && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    Vector direction = DirectionalBlocksHelper.getFacing(object.getBlockForTag(attribute));
                    if (DirectionalBlocksHelper.isLeftHalf(object.getBlockForTag(attribute))) {
                        direction = new Vector(-direction.getZ(), 0.0, direction.getX());
                    } else if (DirectionalBlocksHelper.isRightHalf(object.getBlockForTag(attribute))) {
                        direction = new Vector(direction.getZ(), 0.0, -direction.getX());
                    } else {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Block is a single-block chest.");
                        }
                        return null;
                    }
                    return new LocationTag(object.clone().add(direction));
                }
                if (state instanceof Chest) {
                    InventoryHolder holder = ((Chest)state).getBlockInventory().getHolder();
                    if (holder instanceof DoubleChest) {
                        Location left = ((DoubleChest)holder).getLeftSide().getInventory().getLocation();
                        Location right = ((DoubleChest)holder).getRightSide().getInventory().getLocation();
                        if (left.getBlockX() == object.getBlockX() && left.getBlockY() == object.getBlockY() && left.getBlockZ() == object.getBlockZ()) {
                            return new LocationTag(right);
                        }
                        return new LocationTag(left);
                    }
                } else {
                    if (state instanceof Bed && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                        boolean isTop = DirectionalBlocksHelper.isTopHalf(object.getBlockForTag(attribute));
                        BlockFace direction = DirectionalBlocksHelper.getFace(object.getBlockForTag(attribute));
                        if (!isTop) {
                            direction = direction.getOppositeFace();
                        }
                        return new LocationTag(object.clone().add(direction.getDirection()));
                    }
                    if (state.getData() instanceof Door) {
                        if (((Door)state.getData()).isTopHalf()) {
                            return new LocationTag(object.clone().subtract(0.0, 1.0, 0.0));
                        }
                        return new LocationTag(object.clone().add(0.0, 1.0, 0.0));
                    }
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Block of type " + object.getBlockTypeForTag(attribute).name() + " isn't supported by other_block.");
                    }
                    return null;
                }
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Block of type " + object.getBlockTypeForTag(attribute).name() + " doesn't have an other block.");
                }
                return null;
            }
        });
        LocationTag.registerTag("custom_name", new TagRunnable.ObjectForm<LocationTag>(){

            @Override
            public ObjectTag run(Attribute attribute, LocationTag object) {
                if (object.getBlockStateForTag(attribute) instanceof Nameable) {
                    return new ElementTag(((Nameable)object.getBlockStateForTag(attribute)).getCustomName());
                }
                return null;
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm<LocationTag> runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a location!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        boolean generated;
        Furnace furnace;
        CommandBlock block;
        ListTag list;
        BlockState state;
        if (mechanism.matches("data") && mechanism.hasValue()) {
            Deprecations.materialIds.warn(mechanism.context);
            BlockData blockData = NMSHandler.getBlockHelper().getBlockData(this.getBlock().getType(), (byte)mechanism.getValue().asInt());
            blockData.setBlock(this.getBlock(), false);
        }
        if (mechanism.matches("block_facing") && mechanism.requireObject(LocationTag.class)) {
            LocationTag faceVec = mechanism.valueAsType(LocationTag.class);
            DirectionalBlocksHelper.setFacing(this.getBlock(), faceVec.toVector());
        }
        if (mechanism.matches("block_type") && mechanism.requireObject(MaterialTag.class)) {
            MaterialTag mat = mechanism.valueAsType(MaterialTag.class);
            mat.getNmsBlockData().setBlock(this.getBlock(), false);
        }
        if (mechanism.matches("biome") && mechanism.requireObject(BiomeTag.class)) {
            mechanism.valueAsType(BiomeTag.class).getBiome().changeBlockBiome(this);
        }
        if (mechanism.matches("spawner_type") && mechanism.requireObject(EntityTag.class) && this.getBlockState() instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)this.getBlockState();
            spawner.setSpawnedType(mechanism.valueAsType(EntityTag.class).getBukkitEntityType());
            spawner.update();
        }
        if (mechanism.matches("lock") && this.getBlockState() instanceof Lockable) {
            state = this.getBlockState();
            ((Lockable)state).setLock(mechanism.hasValue() ? mechanism.getValue().asString() : null);
            state.update();
        }
        if (mechanism.matches("sign_contents") && this.getBlockState() instanceof Sign) {
            state = (Sign)this.getBlockState();
            for (int i = 0; i < 4; ++i) {
                state.setLine(i, "");
            }
            list = mechanism.valueAsType(ListTag.class);
            if (list.size() > 4) {
                Debug.echoError("Sign can only hold four lines!");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    state.setLine(i, EscapeTagBase.unEscape((String)list.get(i)));
                }
            }
            state.update();
        }
        if (mechanism.matches("skull_skin")) {
            BlockState blockState = this.getBlockState();
            Material material = this.getBlock().getType();
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && material != Material.PLAYER_HEAD && material != Material.PLAYER_WALL_HEAD) {
                Deprecations.skullSkinMaterials.warn(mechanism.context);
            } else if (blockState instanceof Skull) {
                PlayerProfile profile;
                ListTag list2 = mechanism.valueAsType(ListTag.class);
                String idString = (String)list2.get(0);
                String texture = null;
                if (list2.size() > 1) {
                    texture = (String)list2.get(1);
                }
                if (idString.contains("-")) {
                    UUID uuid = UUID.fromString(idString);
                    String name = null;
                    if (list2.size() > 2) {
                        name = (String)list2.get(2);
                    }
                    profile = new PlayerProfile(name, uuid, texture);
                } else {
                    profile = new PlayerProfile(idString, null, texture);
                }
                profile = NMSHandler.getInstance().fillPlayerProfile(profile);
                if (texture != null) {
                    profile.setTexture(texture);
                }
                NMSHandler.getBlockHelper().setPlayerProfile((Skull)blockState, profile);
            } else {
                Debug.echoError("Unable to set skull_skin on block of type " + material.name() + " with state " + blockState.getClass().getCanonicalName());
            }
        }
        if (mechanism.matches("flowerpot_contents") && mechanism.requireObject(MaterialTag.class)) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Deprecations.flowerpotMechanism.warn(mechanism.context);
            } else if (this.getBlock().getType() == Material.FLOWER_POT) {
                MaterialData data = mechanism.valueAsType(MaterialTag.class).getMaterialData();
                NMSHandler.getBlockHelper().setFlowerpotContents(this.getBlock(), data);
            }
        }
        if (mechanism.matches("command_block_name") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            block = (CommandBlock)this.getBlockState();
            block.setName(mechanism.getValue().asString());
            block.update();
        }
        if (mechanism.matches("command_block") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            block = (CommandBlock)this.getBlockState();
            block.setCommand(mechanism.getValue().asString());
            block.update();
        }
        if (mechanism.matches("custom_name") && this.getBlockState() instanceof Nameable) {
            String title = null;
            if (mechanism.hasValue()) {
                title = mechanism.getValue().asString();
            }
            BlockState state2 = this.getBlockState();
            ((Nameable)state2).setCustomName(title);
            state2.update(true);
        }
        if (mechanism.matches("furnace_burn_time") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlockState();
            furnace.setBurnTime((short)mechanism.getValue().asInt());
            furnace.update();
        }
        if (mechanism.matches("furnace_cook_time") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlockState();
            furnace.setCookTime((short)mechanism.getValue().asInt());
            furnace.update();
        }
        if (mechanism.matches("furnace_cook_time_total") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlockState();
            furnace.setCookTimeTotal((int)((short)mechanism.getValue().asInt()));
            furnace.update();
        }
        if (mechanism.matches("base_color")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Debug.echoError("Base_Color mechanism no longer relevant: banner types are now distinct materials.");
            }
            Banner banner = (Banner)this.getBlockState();
            banner.setBaseColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            banner.update();
        }
        if (mechanism.matches("patterns")) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            list = mechanism.valueAsType(ListTag.class);
            for (String string : list) {
                try {
                    List<String> split = CoreUtilities.split(string, '/', 2);
                    patterns.add(new Pattern(DyeColor.valueOf((String)split.get(0).toUpperCase()), PatternType.valueOf((String)split.get(1).toUpperCase())));
                }
                catch (Exception e) {
                    Debug.echoError("Could not apply pattern to banner: " + string);
                }
            }
            Banner banner = (Banner)this.getBlockState();
            banner.setPatterns(patterns);
            banner.update();
        }
        if (mechanism.matches("head_rotation") && mechanism.requireInteger()) {
            Skull sk = (Skull)this.getBlockState();
            sk.setRotation(this.getSkullBlockFace(mechanism.getValue().asInt() - 1));
            sk.update();
        }
        if (mechanism.matches("generate_tree") && mechanism.requireEnum(false, (Enum<?>[])TreeType.values()) && !(generated = this.getWorld().generateTree((Location)this, TreeType.valueOf((String)mechanism.getValue().asString().toUpperCase())))) {
            Debug.echoError("Could not generate tree at " + this.identifySimple() + ". Make sure this location can naturally generate a tree!");
        }
        if (mechanism.matches("activate")) {
            BlockState state3 = this.getBlockState();
            if (state3 instanceof Dispenser) {
                ((Dispenser)state3).dispense();
            } else if (state3 instanceof Dropper) {
                ((Dropper)state3).drop();
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

