/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PluginTag
implements ObjectTag {
    private Plugin plugin;
    private String prefix = "Plugin";
    public static ObjectTagProcessor<PluginTag> tagProcessor = new ObjectTagProcessor();

    public static PluginTag valueOf(String string) {
        return PluginTag.valueOf(string, null);
    }

    @Fetchable(value="pl")
    public static PluginTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = CoreUtilities.toLowerCase(string).replace("pl@", "");
        try {
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                if (!string.equalsIgnoreCase(plugin.getName())) continue;
                return new PluginTag(plugin);
            }
        }
        catch (Exception e) {
            Debug.echoError("Invalid plugin name specified, or plugin is not enabled: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (CoreUtilities.toLowerCase(arg).startsWith("pl@")) {
            return true;
        }
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            if (!arg.equalsIgnoreCase(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    public PluginTag(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getObjectType() {
        return "Plugin";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "pl@" + this.plugin.getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public PluginTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        PluginTag.registerTag("name", new TagRunnable.ObjectForm<PluginTag>(){

            @Override
            public ObjectTag run(Attribute attribute, PluginTag object) {
                return new ElementTag(object.plugin.getName());
            }
        });
        PluginTag.registerTag("version", new TagRunnable.ObjectForm<PluginTag>(){

            @Override
            public ObjectTag run(Attribute attribute, PluginTag object) {
                return new ElementTag(object.plugin.getDescription().getVersion());
            }
        });
        PluginTag.registerTag("description", new TagRunnable.ObjectForm<PluginTag>(){

            @Override
            public ObjectTag run(Attribute attribute, PluginTag object) {
                return new ElementTag(object.plugin.getDescription().getDescription());
            }
        });
        PluginTag.registerTag("authors", new TagRunnable.ObjectForm<PluginTag>(){

            @Override
            public ObjectTag run(Attribute attribute, PluginTag object) {
                return new ListTag(object.plugin.getDescription().getAuthors());
            }
        });
        PluginTag.registerTag("type", new TagRunnable.ObjectForm<PluginTag>(){

            @Override
            public ObjectTag run(Attribute attribute, PluginTag object) {
                return new ElementTag("Plugin");
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm<PluginTag> runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

