/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Iterator;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.util.EulerAngle;

public class EntityArmorPose
implements Property {
    public static final String[] handledTags = new String[]{"armor_pose_list", "armor_pose"};
    public static final String[] handledMechs = new String[]{"armor_pose"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntityType() == EntityType.ARMOR_STAND;
    }

    public static EntityArmorPose getFrom(ObjectTag entity) {
        if (!EntityArmorPose.describes(entity)) {
            return null;
        }
        return new EntityArmorPose((EntityTag)entity);
    }

    private EntityArmorPose(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.getPoseList().identify();
    }

    @Override
    public String getPropertyId() {
        return "armor_pose";
    }

    private ListTag getPoseList() {
        ArmorStand armorStand = (ArmorStand)this.entity.getBukkitEntity();
        ListTag list = new ListTag();
        for (PosePart posePart : PosePart.values()) {
            list.add(CoreUtilities.toLowerCase(posePart.name()));
            list.add(EntityArmorPose.fromEulerAngle(posePart.getAngle(armorStand)).identify());
        }
        return list;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("armor_pose_list")) {
            return this.getPoseList().getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("armor_pose") && attribute.hasContext(1)) {
            String name = attribute.getContext(1);
            PosePart posePart = PosePart.fromName(name);
            if (posePart == null) {
                Debug.echoError("Invalid pose part specified: " + name);
                return null;
            }
            return EntityArmorPose.fromEulerAngle(posePart.getAngle((ArmorStand)this.entity.getBukkitEntity())).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("armor_pose")) {
            ArmorStand armorStand = (ArmorStand)this.entity.getBukkitEntity();
            ListTag list = mechanism.valueAsType(ListTag.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                String angle = (String)iterator.next();
                PosePart posePart = PosePart.fromName(name);
                if (posePart == null) {
                    Debug.echoError("Invalid pose part specified: " + name + "; ignoring next: " + angle);
                    continue;
                }
                posePart.setAngle(armorStand, EntityArmorPose.toEulerAngle(LocationTag.valueOf(angle)));
            }
        }
    }

    private static LocationTag fromEulerAngle(EulerAngle eulerAngle) {
        return new LocationTag(null, eulerAngle.getX(), eulerAngle.getY(), eulerAngle.getZ());
    }

    private static EulerAngle toEulerAngle(LocationTag location) {
        return new EulerAngle(location.getX(), location.getY(), location.getZ());
    }

    private static enum PosePart {
        HEAD{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getHeadPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setHeadPose(eulerAngle);
            }
        }
        ,
        BODY{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getBodyPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setBodyPose(eulerAngle);
            }
        }
        ,
        LEFT_ARM{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getLeftArmPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setLeftArmPose(eulerAngle);
            }
        }
        ,
        RIGHT_ARM{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getRightArmPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setRightArmPose(eulerAngle);
            }
        }
        ,
        LEFT_LEG{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getLeftLegPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setLeftLegPose(eulerAngle);
            }
        }
        ,
        RIGHT_LEG{

            @Override
            EulerAngle getAngle(ArmorStand armorStand) {
                return armorStand.getRightLegPose();
            }

            @Override
            void setAngle(ArmorStand armorStand, EulerAngle eulerAngle) {
                armorStand.setRightLegPose(eulerAngle);
            }
        };


        abstract EulerAngle getAngle(ArmorStand var1);

        abstract void setAngle(ArmorStand var1, EulerAngle var2);

        static PosePart fromName(String name) {
            for (PosePart posePart : PosePart.values()) {
                if (!posePart.name().equalsIgnoreCase(name)) continue;
                return posePart;
            }
            return null;
        }
    }
}

