/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.inventory;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class InventoryContents
implements Property {
    public static final String[] handledTags = new String[]{"list_contents"};
    public static final String[] handledMechs = new String[]{"contents"};
    InventoryTag inventory;

    public static boolean describes(ObjectTag inventory) {
        return inventory instanceof InventoryTag;
    }

    public static InventoryContents getFrom(ObjectTag inventory) {
        if (!InventoryContents.describes(inventory)) {
            return null;
        }
        return new InventoryContents((InventoryTag)inventory);
    }

    public InventoryContents(InventoryTag inventory) {
        this.inventory = inventory;
    }

    public ListTag getContents(int simpleOrFull) {
        if (this.inventory.getInventory() == null) {
            return null;
        }
        ListTag contents = new ListTag();
        boolean containsNonAir = false;
        for (ItemStack item : this.inventory.getInventory().getContents()) {
            if (item != null && item.getType() != Material.AIR) {
                containsNonAir = true;
                if (simpleOrFull == 1) {
                    contents.add(new ItemTag(item).identifySimple());
                    continue;
                }
                if (simpleOrFull == 2) {
                    contents.add(new ItemTag(item).getFullString());
                    continue;
                }
                contents.add(new ItemTag(item).identify());
                continue;
            }
            contents.add("i@air");
        }
        if (!containsNonAir) {
            contents.clear();
        } else {
            contents = ListTag.valueOf(contents.identify().replaceAll("(\\|i@air)*$", ""));
        }
        return contents;
    }

    public ListTag getContentsWithLore(String lore, boolean simple) {
        if (this.inventory.getInventory() == null) {
            return null;
        }
        ListTag contents = new ListTag();
        lore = ChatColor.stripColor((String)lore);
        block0: for (ItemStack item : this.inventory.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
            for (String line : item.getItemMeta().getLore()) {
                if (!ChatColor.stripColor((String)line).equalsIgnoreCase(lore)) continue;
                if (simple) {
                    contents.add(new ItemTag(item).identifySimple());
                    continue block0;
                }
                contents.add(new ItemTag(item).identify());
                continue block0;
            }
        }
        return contents;
    }

    @Override
    public String getPropertyString() {
        if (!this.inventory.getIdType().equals("generic") && !this.inventory.isUnique()) {
            return null;
        }
        ListTag contents = this.getContents(0);
        if (contents == null || contents.isEmpty()) {
            return null;
        }
        return contents.identify();
    }

    @Override
    public String getPropertyId() {
        return "contents";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("list_contents")) {
            attribute.fulfill(1);
            if (attribute.startsWith("simple")) {
                return this.getContents(1).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("full")) {
                return this.getContents(2).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("with_lore")) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String lore = attribute.getContext(1);
                attribute.fulfill(1);
                if (attribute.startsWith("simple")) {
                    return this.getContentsWithLore(lore, true).getObjectAttribute(attribute.fulfill(1));
                }
                return this.getContentsWithLore(lore, false).getObjectAttribute(attribute);
            }
            return this.getContents(0).getObjectAttribute(attribute);
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("contents") && this.inventory.getIdType().equals("generic")) {
            this.inventory.setContents(mechanism.valueAsType(ListTag.class), mechanism.context);
        }
    }
}

