/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;

public class ItemMap
implements Property {
    public static Material MAP_MATERIAL = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) ? Material.FILLED_MAP : Material.MAP;
    public static final String[] handledTags = new String[]{"map"};
    public static final String[] handledMechs = new String[]{"map"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getType() == MAP_MATERIAL;
    }

    public static ItemMap getFrom(ObjectTag _item) {
        if (!ItemMap.describes(_item)) {
            return null;
        }
        return new ItemMap((ItemTag)_item);
    }

    private ItemMap(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("map")) {
            if (!this.hasMapId()) {
                return null;
            }
            return new ElementTag(this.getMapId()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public boolean hasMapId() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            MapMeta map = (MapMeta)this.item.getItemStack().getItemMeta();
            return map.hasMapId();
        }
        return true;
    }

    public int getMapId() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            MapMeta map = (MapMeta)this.item.getItemStack().getItemMeta();
            if (!map.hasMapId()) {
                return 0;
            }
            return map.getMapId();
        }
        return this.item.getItemStack().getDurability();
    }

    public void setMapId(int id) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            MapMeta map = (MapMeta)this.item.getItemStack().getItemMeta();
            map.setMapId(id);
            this.item.getItemStack().setItemMeta((ItemMeta)map);
        }
        this.item.getItemStack().setDurability((short)id);
    }

    @Override
    public String getPropertyString() {
        if (!this.hasMapId()) {
            return null;
        }
        return String.valueOf(this.getMapId());
    }

    @Override
    public String getPropertyId() {
        return "map";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("map") && mechanism.requireInteger()) {
            this.setMapId(mechanism.getValue().asInt());
        }
    }
}

