/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.data.Ageable;

public class MaterialAge
implements Property {
    public static final String[] handledTags = new String[]{"maximum_age", "age", "maximum_plant_growth", "plant_growth"};
    public static final String[] handledMechs = new String[]{"age", "plant_growth"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData().data instanceof Ageable;
    }

    public static MaterialAge getFrom(ObjectTag _material) {
        if (!MaterialAge.describes(_material)) {
            return null;
        }
        return new MaterialAge((MaterialTag)_material);
    }

    private MaterialAge(MaterialTag _material) {
        this.material = _material;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("maximum_age") || attribute.startsWith("maximum_plant_growth")) {
            return new ElementTag(this.getMax()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("age") || attribute.startsWith("plant_growth")) {
            return new ElementTag(this.getCurrent()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public Ageable getAgeable() {
        return (Ageable)this.material.getModernData().data;
    }

    public int getCurrent() {
        return this.getAgeable().getAge();
    }

    public int getMax() {
        return this.getAgeable().getMaximumAge();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("age") || mechanism.matches("plant_growth")) && mechanism.requireInteger()) {
            int age = mechanism.getValue().asInt();
            if (age < 0 || age > this.getMax()) {
                Debug.echoError("Age value '" + age + "' is not valid. Must be between 0 and " + this.getMax() + " for material '" + this.material.realName() + "'.");
                return;
            }
            this.getAgeable().setAge(age);
        }
    }
}

