/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.npc.traits.HungerTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;

public class FeedCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrimitive(ArgumentHelper.PrimitiveType.Integer) && !scriptEntry.hasObject("amount")) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(PlayerTag.class) && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
                scriptEntry.addObject("targetplayer", arg.asType(PlayerTag.class));
                continue;
            }
            if (Depends.citizens != null && arg.matchesArgumentType(NPCTag.class) && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
                scriptEntry.addObject("targetnpc", arg.asType(NPCTag.class));
                continue;
            }
            if (arg.matches("NPC") && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc") && Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("targetnpc", Utilities.getEntryNPC(scriptEntry));
                continue;
            }
            if (arg.matches("PLAYER") && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc") && Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("targetplayer", Utilities.getEntryPlayer(scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
            if (Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("targetplayer", Utilities.getEntryPlayer(scriptEntry));
            } else if (Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("targetnpc", Utilities.getEntryNPC(scriptEntry));
            } else {
                throw new InvalidArgumentsException("Must specify a player!");
            }
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", new ElementTag(9999));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        PlayerTag player = (PlayerTag)scriptEntry.getObject("targetplayer");
        NPCTag npc = (NPCTag)scriptEntry.getObject("targetnpc");
        ElementTag amount = scriptEntry.getElement("amount");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (player == null ? "" : player.debug()) + (npc == null ? "" : npc.debug()) + amount.debug());
        }
        if (npc != null) {
            if (!npc.getCitizen().hasTrait(HungerTrait.class)) {
                Debug.echoError(scriptEntry.getResidingQueue(), "This NPC does not have the HungerTrait enabled! Use /trait hunger");
                return;
            }
            ((HungerTrait)npc.getCitizen().getTrait(HungerTrait.class)).feed(amount.asInt());
        } else if (player != null) {
            if (95999 - player.getPlayerEntity().getFoodLevel() < amount.asInt()) {
                amount = new ElementTag(95999 - player.getPlayerEntity().getFoodLevel());
            }
            player.getPlayerEntity().setFoodLevel(player.getPlayerEntity().getFoodLevel() + amount.asInt());
        } else {
            Debug.echoError(scriptEntry.getResidingQueue(), "No target?");
        }
    }
}

