/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.AbstractMap;
import java.util.List;

public class InventoryCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean isAdjust = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("actions") && arg.matchesEnumList(Action.values())) {
                scriptEntry.addObject("actions", arg.asType(ListTag.class).filter(Action.values()));
                isAdjust = arg.toString().equalsIgnoreCase("adjust");
                continue;
            }
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o", "source", "items", "item", "i", "from", "f") && (arg.matchesArgumentTypes(InventoryTag.class, EntityTag.class, LocationTag.class) || arg.matchesArgumentList(ItemTag.class))) {
                scriptEntry.addObject("origin", Conversion.getInventory(arg, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesPrefix("destination", "dest", "d", "target", "to", "t") && arg.matchesArgumentTypes(InventoryTag.class, EntityTag.class, LocationTag.class)) {
                scriptEntry.addObject("destination", Conversion.getInventory(arg, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot, s")) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("mechanism") && isAdjust) {
                if (arg.hasPrefix()) {
                    scriptEntry.addObject("mechanism", new ElementTag(arg.getPrefix().getValue()));
                    scriptEntry.addObject("mechanism_value", arg.asElement());
                    continue;
                }
                scriptEntry.addObject("mechanism", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("actions")) {
            throw new InvalidArgumentsException("Must specify an Inventory action!");
        }
        if (isAdjust && !scriptEntry.hasObject("mechanism")) {
            throw new InvalidArgumentsException("Inventory adjust must have a mechanism!");
        }
        if (isAdjust && !scriptEntry.hasObject("slot")) {
            throw new InvalidArgumentsException("Inventory adjust must have an explicit slot!");
        }
        scriptEntry.defaultObject("slot", new ElementTag(1));
        scriptEntry.defaultObject("destination", Utilities.entryHasPlayer(scriptEntry) ? new AbstractMap.SimpleEntry<Integer, InventoryTag>(0, Utilities.getEntryPlayer(scriptEntry).getDenizenEntity().getInventory()) : null);
        if (!scriptEntry.hasObject("destination")) {
            throw new InvalidArgumentsException("Must specify a Destination Inventory!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        int slotId;
        List actions = (List)scriptEntry.getObject("actions");
        AbstractMap.SimpleEntry originentry = (AbstractMap.SimpleEntry)scriptEntry.getObject("origin");
        InventoryTag origin = originentry != null ? (InventoryTag)originentry.getValue() : null;
        AbstractMap.SimpleEntry destinationentry = (AbstractMap.SimpleEntry)scriptEntry.getObject("destination");
        InventoryTag destination = (InventoryTag)destinationentry.getValue();
        ElementTag slot = scriptEntry.getElement("slot");
        ElementTag mechanism = scriptEntry.getElement("mechanism");
        ElementTag mechanismValue = scriptEntry.getElement("mechanism_value");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("actions", actions.toString()) + destination.debug() + (origin != null ? origin.debug() : "") + (mechanism != null ? mechanism.debug() : "") + (mechanismValue != null ? mechanismValue.debug() : "") + slot.debug());
        }
        if ((slotId = SlotHelper.nameToIndex(slot.asString())) < 0) {
            if (slotId == -1) {
                Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot (unrecognized)!");
            } else {
                Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot (negative values are invalid)!");
            }
            return;
        }
        for (String action : actions) {
            switch (Action.valueOf(action.toUpperCase())) {
                case OPEN: {
                    if (destination.getIdType().equals("workbench") || destination.getIdHolder().equalsIgnoreCase("workbench")) {
                        Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().openWorkbench(null, true);
                        break;
                    }
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().openInventory(destination.getInventory());
                    break;
                }
                case CLOSE: {
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().closeInventory();
                    break;
                }
                case COPY: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    origin.replace(destination);
                    break;
                }
                case MOVE: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    origin.replace(destination);
                    origin.clear();
                    break;
                }
                case SWAP: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    InventoryTag temp = new InventoryTag(destination.getInventory());
                    origin.replace(destination);
                    temp.replace(origin);
                    break;
                }
                case ADD: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.add(slotId, origin.getContents());
                    break;
                }
                case REMOVE: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.remove(origin.getContents());
                    break;
                }
                case SET: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.setSlots(slotId, origin.getContents(), (Integer)originentry.getKey());
                    break;
                }
                case KEEP: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.keep(origin.getContents());
                    break;
                }
                case EXCLUDE: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.exclude(origin.getContents());
                    break;
                }
                case FILL: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.fill(origin.getContents());
                    break;
                }
                case CLEAR: {
                    destination.clear();
                    break;
                }
                case UPDATE: {
                    if (destination.update()) break;
                    Debug.echoError("Only player inventories can be force-updated!");
                    break;
                }
                case ADJUST: {
                    ItemTag toAdjust = new ItemTag(destination.getInventory().getItem(slotId));
                    toAdjust.safeAdjust(new Mechanism(mechanism, mechanismValue, scriptEntry.entryData.getTagContext()));
                    NMSHandler.getItemHelper().setInventoryItem(destination.getInventory(), toAdjust.getItemStack(), slotId);
                }
            }
        }
    }

    private static enum Action {
        OPEN,
        CLOSE,
        COPY,
        MOVE,
        SWAP,
        ADD,
        REMOVE,
        SET,
        KEEP,
        EXCLUDE,
        FILL,
        CLEAR,
        UPDATE,
        ADJUST;

    }
}

