/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;

public class WeatherCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesEnum(Value.values())) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
        scriptEntry.defaultObject("world", Utilities.entryHasNPC(scriptEntry) ? new WorldTag(Utilities.getEntryNPC(scriptEntry).getWorld()) : null, Utilities.entryHasPlayer(scriptEntry) ? new WorldTag(Utilities.getEntryPlayer(scriptEntry).getWorld()) : null, Bukkit.getWorlds().get(0));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Type type;
        Value value = Value.valueOf(((ElementTag)scriptEntry.getObject("value")).asString().toUpperCase());
        WorldTag world = (WorldTag)scriptEntry.getObject("world");
        Type type2 = type = scriptEntry.hasObject("type") ? (Type)((Object)scriptEntry.getObject("type")) : Type.GLOBAL;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("type", type.name()) + (type.name().equalsIgnoreCase("player") ? ArgumentHelper.debugObj("player", Utilities.getEntryPlayer(scriptEntry)) : "") + (type.name().equalsIgnoreCase("global") ? ArgumentHelper.debugObj("world", world) : "") + ArgumentHelper.debugObj("value", (Object)value));
        }
        switch (value) {
            case SUNNY: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setStorm(false);
                    world.getWorld().setThundering(false);
                    break;
                }
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setPlayerWeather(WeatherType.CLEAR);
                break;
            }
            case STORM: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setStorm(true);
                    break;
                }
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setPlayerWeather(WeatherType.DOWNFALL);
                break;
            }
            case THUNDER: {
                if (type.equals((Object)Type.GLOBAL)) {
                    world.getWorld().setThundering(true);
                    break;
                }
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setPlayerWeather(WeatherType.DOWNFALL);
            }
        }
    }

    private static enum Value {
        SUNNY,
        STORM,
        THUNDER;

    }

    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

