/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.command.DenizenCommand;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommandScriptContainer
extends ScriptContainer {
    public CommandScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        CommandScriptHelper.registerDenizenCommand(new DenizenCommand(this));
    }

    public String getCommandName() {
        return CoreUtilities.toLowerCase(this.getString("NAME", null));
    }

    public String getDescription() {
        return TagManager.tag(this.getString("DESCRIPTION", "").replace("\n", " \n"), new BukkitTagContext(null, null, new ScriptTag(this)));
    }

    public String getUsage() {
        return TagManager.tag(this.getString("USAGE", ""), new BukkitTagContext(null, null, new ScriptTag(this)));
    }

    public List<String> getAliases() {
        ArrayList aliases = this.getStringList("ALIASES");
        return aliases != null ? aliases : new ArrayList();
    }

    public String getPermission() {
        return this.getString("PERMISSION");
    }

    public String getPermissionMessage() {
        return this.getString("PERMISSION MESSAGE");
    }

    public ScriptQueue runCommandScript(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context) {
        ScriptQueue queue = new InstantQueue(this.getName()).addEntries(this.getBaseEntries(new BukkitScriptEntryData(player, npc)));
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        return queue;
    }

    public boolean runAllowedHelpProcedure(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context) {
        List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(player, npc), "ALLOWED HELP");
        ScriptQueue queue = new InstantQueue(this.getName()).addEntries(entries);
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        return queue.determinations != null && queue.determinations.size() > 0 && ((String)queue.determinations.get(0)).equalsIgnoreCase("true");
    }

    public List<String> runTabCompleteProcedure(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context) {
        List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(player, npc), "TAB COMPLETE");
        ScriptQueue queue = new InstantQueue(this.getName()).addEntries(entries);
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        if (queue.determinations != null && queue.determinations.size() > 0) {
            return ListTag.getListFor(queue.determinations.getObject(0));
        }
        return new ArrayList<String>();
    }

    public boolean hasAllowedHelpProcedure() {
        return this.contains("ALLOWED HELP");
    }

    public boolean hasTabCompleteProcedure() {
        return this.contains("TAB COMPLETE");
    }
}

