/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.core.NPCNavigationSmartEvent;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class NPCTagBase
implements Listener {
    public static Map<Integer, LocationTag> previousLocations = new HashMap<Integer, LocationTag>();

    public NPCTagBase() {
        if (Depends.citizens != null) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
            TagManager.registerTagHandler(new TagRunnable.RootForm(){

                @Override
                public void run(ReplaceableTagEvent event) {
                    NPCTagBase.this.npcTags(event);
                }
            }, "npc");
        }
    }

    public void npcTags(ReplaceableTagEvent event) {
        if (!event.matches("npc") || event.replaced()) {
            return;
        }
        Attribute attribute = event.getAttributes();
        NPCTag n = ((BukkitTagContext)event.getContext()).npc;
        if (attribute.hasContext(1)) {
            if (NPCTag.matches(attribute.getContext(1))) {
                n = NPCTag.valueOf(attribute.getContext(1), attribute.context);
            } else {
                if (!event.hasAlternative()) {
                    Debug.echoError("Could not match '" + attribute.getContext(1) + "' to a valid NPC!");
                }
                return;
            }
        }
        if (n == null || !n.isValid()) {
            if (!event.hasAlternative()) {
                Debug.echoError("Invalid or missing NPC for tag <" + event.raw_tag + ">!");
            }
            return;
        }
        event.setReplacedObject(CoreUtilities.autoAttrib(n, attribute.fulfill(1)));
    }

    @EventHandler
    public void navComplete(NavigationCompleteEvent event) {
        NPCTag npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (NPCNavigationSmartEvent.IsActive()) {
            OldEventManager.doEvents(Arrays.asList("npc completes navigation"), new BukkitScriptEntryData(null, npc), null);
        }
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        npc.action("complete navigation", null);
    }

    @EventHandler
    public void navBegin(NavigationBeginEvent event) {
        NPCTag npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (NPCNavigationSmartEvent.IsActive()) {
            OldEventManager.doEvents(Arrays.asList("npc begins navigation"), new BukkitScriptEntryData(null, npc), null);
        }
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        npc.action("begin navigation", null);
        if (event.getNPC().getNavigator().getTargetType() == TargetType.ENTITY) {
            LivingEntity entity = (LivingEntity)event.getNPC().getNavigator().getEntityTarget().getTarget();
            if (event.getNPC().getNavigator().getEntityTarget().isAggressive() && !entity.isDead()) {
                PlayerTag player = null;
                if (entity instanceof Player) {
                    player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
                }
                npc.action("attack", player);
                npc.action("attack on " + entity.getType().toString(), player);
            }
            previousLocations.put(event.getNPC().getId(), npc.getLocation());
        }
    }

    @EventHandler
    public void navCancel(NavigationCancelEvent event) {
        NPCTag npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (NPCNavigationSmartEvent.IsActive()) {
            OldEventManager.doEvents(Arrays.asList("npc cancels navigation"), new BukkitScriptEntryData(null, npc), null);
        }
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        npc.action("cancel navigation", null);
        npc.action("cancel navigation due to " + event.getCancelReason().toString(), null);
    }

    @EventHandler
    public void navStuck(NavigationStuckEvent event) {
        NPCTag npc = DenizenAPI.getDenizenNPC(event.getNPC());
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("action", new ElementTag(event.getAction() == TeleportStuckAction.INSTANCE ? "teleport" : "none"));
        if (NPCNavigationSmartEvent.IsActive()) {
            List<String> determinations = OldEventManager.doEvents(Arrays.asList("npc stuck"), new BukkitScriptEntryData(null, npc), context);
            for (String determination : determinations) {
                if (determination.equalsIgnoreCase("none")) {
                    event.setAction(null);
                }
                if (!determination.equalsIgnoreCase("teleport")) continue;
                event.setAction((StuckAction)TeleportStuckAction.INSTANCE);
            }
        }
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        String determination2 = npc.action("stuck", null, context);
        if (determination2.equalsIgnoreCase("none")) {
            event.setAction(null);
        }
        if (determination2.equalsIgnoreCase("teleport")) {
            event.setAction((StuckAction)TeleportStuckAction.INSTANCE);
        }
    }
}

