/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.ChatColor;

public class TextTagBase {
    public TextTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                TextTagBase.this.specialCharacterTags(event);
            }
        }, "&auml", "&Auml", "&ouml", "&Ouml", "&uuml", "&Uuml", "&nl", "&amp", "&cm", "&ss", "&sq", "&sp", "&nbsp", "&dq", "&co", "&sc", "&rb", "&lb", "&rc", "&lc", "&ns", "&pc", "&pipe", "&ds", "&lt", "&gt", "&bs", "&at", "&dot", "&hrt", "&chr");
        for (ChatColor color : ChatColor.values()) {
            String nameVal = CoreUtilities.toLowerCase(color.name());
            final String retVal = color.toString();
            TagManager.registerTagHandler(new TagRunnable.RootForm(){

                @Override
                public void run(ReplaceableTagEvent event) {
                    event.setReplacedObject(new ElementTag(retVal).getObjectAttribute(event.getAttributes().fulfill(1)));
                }
            }, nameVal, "&" + color.getChar());
        }
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                event.setReplaced(new ElementTag("\n").getAttribute(event.getAttributes().fulfill(1)));
            }
        }, "n");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                event.setReplaced(new ElementTag("\n " + ChatColor.RESET + " \n").getAttribute(event.getAttributes().fulfill(1)));
            }
        }, "p");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String hoverText = attribute.getContext(1);
                String type = "SHOW_TEXT";
                if (attribute.startsWith("type", 2)) {
                    type = attribute.getContext(2);
                    attribute.fulfill(1);
                }
                event.setReplacedObject(new ElementTag("\u00a7[hover=" + type + ";" + FormattedTextHelper.escape(hoverText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&hover");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String clickText = attribute.getContext(1);
                String type = "RUN_COMMAND";
                if (attribute.startsWith("type", 2)) {
                    type = attribute.getContext(2);
                    attribute.fulfill(1);
                }
                event.setReplacedObject(new ElementTag("\u00a7[click=" + type + ";" + FormattedTextHelper.escape(clickText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&click");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String insertText = attribute.getContext(1);
                event.setReplacedObject(new ElementTag("\u00a7[insertion=" + FormattedTextHelper.escape(insertText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&insertion");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                event.setReplacedObject(new ElementTag("\u00a7[/click]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&end_click");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                event.setReplacedObject(new ElementTag("\u00a7[/hover]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&end_hover");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                event.setReplacedObject(new ElementTag("\u00a7[/insertion]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&end_insertion");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String keybindText = attribute.getContext(1);
                event.setReplacedObject(new ElementTag("\u00a7[keybind=" + FormattedTextHelper.escape(keybindText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&keybind");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String selectorText = attribute.getContext(1);
                event.setReplacedObject(new ElementTag("\u00a7[selector=" + FormattedTextHelper.escape(selectorText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&selector");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String translateText = attribute.getContext(1);
                StringBuilder with = new StringBuilder();
                if (attribute.startsWith("with", 2)) {
                    ListTag withList = ListTag.valueOf(attribute.getContext(2));
                    attribute.fulfill(1);
                    for (String str : withList) {
                        with.append(";").append(FormattedTextHelper.escape(EscapeTagBase.unEscape(str)));
                    }
                }
                event.setReplacedObject(new ElementTag("\u00a7[translate=" + FormattedTextHelper.escape(translateText) + with.toString() + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&translate");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                ListTag scoreList = ListTag.valueOf(attribute.getContext(1));
                if (scoreList.size() < 2) {
                    return;
                }
                String name = FormattedTextHelper.escape(EscapeTagBase.unEscape((String)scoreList.get(0)));
                String objective = FormattedTextHelper.escape(EscapeTagBase.unEscape((String)scoreList.get(1)));
                String value = scoreList.size() >= 3 ? FormattedTextHelper.escape(EscapeTagBase.unEscape((String)scoreList.get(2))) : "";
                event.setReplacedObject(new ElementTag("\u00a7[score=" + name + ";" + objective + ";" + value + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&score");
    }

    @TagManager.TagEvents
    public void specialCharacterTags(ReplaceableTagEvent event) {
        if (!event.getName().startsWith("&")) {
            return;
        }
        String lower = CoreUtilities.toLowerCase(event.getName());
        Attribute attribute = event.getAttributes();
        if (event.getName().equals("&auml")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("\u00e4").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&Auml")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("\u00c4").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&ouml")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("\u00f6").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&Ouml")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("\u00d6").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&uuml")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("\u00fc").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&Uuml")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("\u00dc").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&amp")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("&").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&cm")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag(",").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&sc")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag(String.valueOf('\u2011')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&pipe")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("|").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&ds")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("$").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&at")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("@").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&dot")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag(".").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&hrt")) {
            Deprecations.pointlessTextTags.warn(event.getScriptEntry());
            event.setReplaced(new ElementTag("\u2665").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&pc")) {
            event.setReplaced(new ElementTag("%").getAttribute(attribute.fulfill(1)));
        }
        if (lower.equals("&nl")) {
            event.setReplaced(new ElementTag("\n").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&ss")) {
            event.setReplaced(new ElementTag("\u00a7").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&sq")) {
            event.setReplaced(new ElementTag("'").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&sp")) {
            event.setReplaced(new ElementTag(String.valueOf(' ')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&nbsp")) {
            event.setReplaced(new ElementTag(String.valueOf('\u00a0')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&dq")) {
            event.setReplaced(new ElementTag("\"").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&co")) {
            event.setReplaced(new ElementTag(":").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&rb")) {
            event.setReplaced(new ElementTag("]").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&lb")) {
            event.setReplaced(new ElementTag("[").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&rc")) {
            event.setReplaced(new ElementTag("}").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&lc")) {
            event.setReplaced(new ElementTag("{").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&ns")) {
            event.setReplaced(new ElementTag("#").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&lt")) {
            event.setReplaced(new ElementTag(String.valueOf('\u0001')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&gt")) {
            event.setReplaced(new ElementTag(String.valueOf('\u0002')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&bs")) {
            event.setReplaced(new ElementTag("\\").getAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("&chr") && attribute.hasContext(1)) {
            event.setReplaced(new ElementTag(String.valueOf((char)Integer.parseInt(attribute.getContext(1), 16))).getAttribute(attribute.fulfill(1)));
        }
    }
}

