/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.scripts.commands.world.SchematicCommand;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.blocks.BlockSet;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CuboidBlockSet
implements BlockSet {
    public BlockData[] blocks = null;
    public int x_width;
    public int y_length;
    public int z_height;
    public int center_x;
    public int center_y;
    public int center_z;

    public CuboidBlockSet() {
    }

    public CuboidBlockSet(CuboidTag cuboid, Location center) {
        LocationTag low = cuboid.pairs.get((int)0).low;
        LocationTag high = cuboid.pairs.get((int)0).high;
        this.x_width = (int)(high.getX() - low.getX() + 1.0);
        this.y_length = (int)(high.getY() - low.getY() + 1.0);
        this.z_height = (int)(high.getZ() - low.getZ() + 1.0);
        this.center_x = (int)(center.getX() - low.getX());
        this.center_y = (int)(center.getY() - low.getY());
        this.center_z = (int)(center.getZ() - low.getZ());
        this.blocks = new BlockData[this.x_width * this.y_length * this.z_height];
        int index = 0;
        for (int x = 0; x < this.x_width; ++x) {
            for (int y = 0; y < this.y_length; ++y) {
                for (int z = 0; z < this.z_height; ++z) {
                    this.blocks[index++] = NMSHandler.getBlockHelper().getBlockData(low.clone().add((double)x, (double)y, (double)z).getBlock());
                }
            }
        }
    }

    public void buildDelayed(CuboidTag cuboid, Location center, final Runnable runme) {
        final LocationTag low = cuboid.pairs.get((int)0).low;
        LocationTag high = cuboid.pairs.get((int)0).high;
        this.x_width = (int)(high.getX() - low.getX() + 1.0);
        this.y_length = (int)(high.getY() - low.getY() + 1.0);
        this.z_height = (int)(high.getZ() - low.getZ() + 1.0);
        this.center_x = (int)(center.getX() - low.getX());
        this.center_y = (int)(center.getY() - low.getY());
        this.center_z = (int)(center.getZ() - low.getZ());
        final long goal = this.x_width * this.y_length * this.z_height;
        new BukkitRunnable(){
            int index = 0;

            public void run() {
                long start = System.currentTimeMillis();
                while ((long)this.index < goal) {
                    long z = (long)this.index % (long)CuboidBlockSet.this.z_height;
                    long y = ((long)this.index - z) % (long)(CuboidBlockSet.this.y_length * CuboidBlockSet.this.z_height) / (long)CuboidBlockSet.this.z_height;
                    long x = ((long)this.index - y - z) / (long)(CuboidBlockSet.this.y_length * CuboidBlockSet.this.z_height);
                    CuboidBlockSet.this.blocks[this.index] = NMSHandler.getBlockHelper().getBlockData(low.clone().add((double)x, (double)y, (double)z).getBlock());
                    ++this.index;
                    if (System.currentTimeMillis() - start <= 50L) continue;
                    SchematicCommand.noPhys = false;
                    return;
                }
                if (runme != null) {
                    runme.run();
                }
                this.cancel();
            }
        }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 1L, 1L);
    }

    @Override
    public BlockData[] getBlocks() {
        return this.blocks;
    }

    public CuboidTag getCuboid(Location loc) {
        Location low = loc.clone().subtract((double)this.center_x, (double)this.center_y, (double)this.center_z);
        Location high = low.clone().add((double)this.x_width, (double)this.y_length, (double)this.z_height);
        return new CuboidTag(low, high);
    }

    public void setBlockSingle(BlockData block, int x, int y, int z, BlockSet.InputParams input) {
        if (input.noAir && block.getMaterial() == Material.AIR) {
            return;
        }
        int finalY = input.centerLocation.getBlockY() + y - this.center_y;
        if (finalY < 0 || finalY > 255) {
            return;
        }
        Block destBlock = input.centerLocation.clone().add((double)(x - this.center_x), (double)(y - this.center_y), (double)(z - this.center_z)).getBlock();
        if (input.mask != null && !input.mask.contains(destBlock.getType())) {
            return;
        }
        if (input.fakeTo == null) {
            block.setBlock(destBlock, false);
        } else {
            FakeBlock.showFakeBlockTo(input.fakeTo, destBlock.getLocation(), new MaterialTag(block.modern()), input.fakeDuration);
        }
    }

    @Override
    public void setBlocksDelayed(final Runnable runme, final BlockSet.InputParams input) {
        final long goal = this.x_width * this.y_length * this.z_height;
        new BukkitRunnable(){
            int index = 0;

            public void run() {
                SchematicCommand.noPhys = true;
                long start = System.currentTimeMillis();
                while ((long)this.index < goal) {
                    int z = this.index % CuboidBlockSet.this.z_height;
                    int y = (this.index - z) % (CuboidBlockSet.this.y_length * CuboidBlockSet.this.z_height) / CuboidBlockSet.this.z_height;
                    int x = (this.index - y - z) / (CuboidBlockSet.this.y_length * CuboidBlockSet.this.z_height);
                    CuboidBlockSet.this.setBlockSingle(CuboidBlockSet.this.blocks[this.index], x, y, z, input);
                    ++this.index;
                    if (System.currentTimeMillis() - start <= 50L) continue;
                    SchematicCommand.noPhys = false;
                    return;
                }
                SchematicCommand.noPhys = false;
                if (runme != null) {
                    runme.run();
                }
                this.cancel();
            }
        }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 1L, 1L);
    }

    @Override
    public void setBlocks(BlockSet.InputParams input) {
        SchematicCommand.noPhys = true;
        int index = 0;
        for (int x = 0; x < this.x_width; ++x) {
            for (int y = 0; y < this.y_length; ++y) {
                for (int z = 0; z < this.z_height; ++z) {
                    this.setBlockSingle(this.blocks[index], x, y, z, input);
                    ++index;
                }
            }
        }
        SchematicCommand.noPhys = false;
    }

    public void rotateOne() {
        BlockData[] bd = new BlockData[this.blocks.length];
        int index = 0;
        int cx = this.center_x;
        this.center_x = this.center_z;
        this.center_z = cx;
        for (int x = 0; x < this.z_height; ++x) {
            for (int y = 0; y < this.y_length; ++y) {
                for (int z = this.x_width - 1; z >= 0; --z) {
                    bd[index++] = this.blockAt(z, y, x);
                }
            }
        }
        int xw = this.x_width;
        this.x_width = this.z_height;
        this.z_height = xw;
        this.blocks = bd;
    }

    public void flipX() {
        BlockData[] bd = new BlockData[this.blocks.length];
        int index = 0;
        this.center_x = this.x_width - this.center_x;
        for (int x = this.x_width - 1; x >= 0; --x) {
            for (int y = 0; y < this.y_length; ++y) {
                for (int z = 0; z < this.z_height; ++z) {
                    bd[index++] = this.blockAt(x, y, z);
                }
            }
        }
        this.blocks = bd;
    }

    public void flipY() {
        BlockData[] bd = new BlockData[this.blocks.length];
        int index = 0;
        this.center_x = this.x_width - this.center_x;
        for (int x = 0; x < this.x_width; ++x) {
            for (int y = this.y_length - 1; y >= 0; --y) {
                for (int z = 0; z < this.z_height; ++z) {
                    bd[index++] = this.blockAt(x, y, z);
                }
            }
        }
        this.blocks = bd;
    }

    public void flipZ() {
        BlockData[] bd = new BlockData[this.blocks.length];
        int index = 0;
        this.center_x = this.x_width - this.center_x;
        for (int x = 0; x < this.x_width; ++x) {
            for (int y = 0; y < this.y_length; ++y) {
                for (int z = this.z_height - 1; z >= 0; --z) {
                    bd[index++] = this.blockAt(x, y, z);
                }
            }
        }
        this.blocks = bd;
    }

    public BlockData blockAt(double X, double Y, double Z) {
        return this.blocks[(int)(Z + Y * (double)this.z_height + X * (double)this.z_height * (double)this.y_length)];
    }
}

