/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizencore.objects.core.DurationTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class FakeBlock {
    private static final Map<UUID, Map<Location, FakeBlock>> blocks = new HashMap<UUID, Map<Location, FakeBlock>>();
    private final PlayerTag player;
    private final Location location;
    private MaterialTag material;
    private long cancelTime = -1L;
    private BukkitTask currentTask = null;

    private FakeBlock(PlayerTag player, Location location) {
        this.player = player;
        this.location = location;
    }

    public static void showFakeBlockTo(List<PlayerTag> players, Location location, MaterialTag material, DurationTag duration) {
        for (PlayerTag player : players) {
            Map<Location, FakeBlock> playerBlocks;
            if (!player.isOnline() || !player.isValid()) continue;
            UUID uuid = player.getPlayerEntity().getUniqueId();
            if (!blocks.containsKey(uuid)) {
                blocks.put(uuid, new HashMap());
            }
            if (!(playerBlocks = blocks.get(uuid)).containsKey(location)) {
                playerBlocks.put(location, new FakeBlock(player, location));
            }
            playerBlocks.get(location).updateBlock(material, duration.getTicks());
        }
    }

    public static void stopShowingTo(List<PlayerTag> players, final LocationTag location) {
        final ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (PlayerTag player : players) {
            Map<Location, FakeBlock> playerBlocks;
            if (!player.isOnline() || !player.isValid()) continue;
            UUID uuid = player.getPlayerEntity().getUniqueId();
            uuids.add(uuid);
            if (!blocks.containsKey(uuid) || !(playerBlocks = blocks.get(uuid)).containsKey(location)) continue;
            playerBlocks.get(location).cancelBlock();
        }
        new BukkitRunnable(){

            public void run() {
                for (UUID uuid : blocks.keySet()) {
                    Map playerBlocks;
                    if (uuids.contains(uuid) || !(playerBlocks = (Map)blocks.get(uuid)).containsKey(location)) continue;
                    ((FakeBlock)playerBlocks.get(location)).updateBlock();
                }
            }
        }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 2L);
    }

    public static Map<UUID, Map<Location, FakeBlock>> getBlocks() {
        return blocks;
    }

    private void cancelBlock() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
        this.cancelTime = -1L;
        this.material = null;
        this.location.getBlock().getState().update();
        blocks.get(this.player.getOfflinePlayer().getUniqueId()).remove(this.location);
    }

    public void updateBlock() {
        if (this.material != null) {
            this.updateBlock(this.material, this.cancelTime == -1L ? 0L : this.cancelTime - this.location.getWorld().getFullTime());
        }
    }

    private void updateBlock(MaterialTag material, long ticks) {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.material = material;
        if (!this.player.hasChunkLoaded(this.location.getChunk())) {
            return;
        }
        if (material.hasModernData()) {
            material.getModernData().sendFakeChangeTo(this.player.getPlayerEntity(), this.location);
        } else {
            this.player.getPlayerEntity().sendBlockChange(this.location, material.getMaterial(), material.getMaterialData().getData());
        }
        if (ticks > 0L) {
            this.cancelTime = this.location.getWorld().getFullTime() + ticks;
            this.currentTask = new BukkitRunnable(){

                public void run() {
                    FakeBlock.this.currentTask = null;
                    if (FakeBlock.this.player.isValid() && FakeBlock.this.player.isOnline()) {
                        FakeBlock.this.cancelBlock();
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), ticks);
        }
    }

    static {
        FakeBlockListeners fakeBlockListeners = new FakeBlockListeners();
    }

    public static class FakeBlockListeners
    implements Listener {
        public FakeBlockListeners() {
            DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        }

        @EventHandler
        public void playerQuit(PlayerQuitEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            if (blocks.containsKey(uuid)) {
                blocks.remove(uuid);
            }
        }
    }
}

