/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.util.jnbt.ByteArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.IntTag;
import com.denizenscript.denizen.nms.util.jnbt.ListTag;
import com.denizenscript.denizen.nms.util.jnbt.NBTInputStream;
import com.denizenscript.denizen.nms.util.jnbt.NBTOutputStream;
import com.denizenscript.denizen.nms.util.jnbt.NamedTag;
import com.denizenscript.denizen.nms.util.jnbt.ShortTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.utilities.blocks.CuboidBlockSet;
import com.denizenscript.denizen.utilities.blocks.ModernBlockData;
import com.denizenscript.denizen.utilities.debugging.Debug;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bukkit.util.BlockVector;

public class SpongeSchematicHelper {
    public static CuboidBlockSet fromSpongeStream(InputStream is) {
        CuboidBlockSet cbs = new CuboidBlockSet();
        try {
            int z;
            int y;
            NBTInputStream nbtStream = new NBTInputStream(new GZIPInputStream(is));
            NamedTag rootTag = nbtStream.readNamedTag();
            nbtStream.close();
            if (!rootTag.getName().equals("Schematic")) {
                throw new Exception("Tag 'Schematic' does not exist or is not first!");
            }
            CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
            Object schematic = schematicTag.getValue();
            short width = SpongeSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue();
            short length = SpongeSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue();
            short height = SpongeSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue();
            int originX = 0;
            int originY = 0;
            int originZ = 0;
            try {
                int[] offsetArr = SpongeSchematicHelper.getChildTag((Map<String, Tag>)schematic, "DenizenOffset", IntArrayTag.class).getValue();
                originX = offsetArr[0];
                originY = offsetArr[1];
                originZ = offsetArr[2];
            }
            catch (Exception offsetArr) {
                // empty catch block
            }
            cbs.x_width = width;
            cbs.z_height = length;
            cbs.y_length = height;
            cbs.center_x = originX;
            cbs.center_y = originY;
            cbs.center_z = originZ;
            cbs.blocks = new BlockData[width * length * height];
            Object paletteMap = SpongeSchematicHelper.getChildTag((Map<String, Tag>)schematic, "Palette", CompoundTag.class).getValue();
            HashMap<Integer, ModernBlockData> palette = new HashMap<Integer, ModernBlockData>(256);
            for (String key : paletteMap.keySet()) {
                int id = SpongeSchematicHelper.getChildTag((Map<String, Tag>)paletteMap, key, IntTag.class).getValue();
                ModernBlockData data = NMSHandler.getBlockHelper().parseBlockData(key);
                palette.put(id, data);
            }
            HashMap<BlockVector, Object> tileEntitiesMap = new HashMap<BlockVector, Object>();
            if (schematic.containsKey("BlockEntities")) {
                Object tileEntities = SpongeSchematicHelper.getChildTag((Map<String, Tag>)schematic, "BlockEntities", ListTag.class).getValue();
                Iterator id = tileEntities.iterator();
                while (id.hasNext()) {
                    Tag tag = (Tag)id.next();
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag t = (CompoundTag)tag;
                    int[] pos = SpongeSchematicHelper.getChildTag((Map<String, Tag>)t.getValue(), "Pos", IntArrayTag.class).getValue();
                    int x = pos[0];
                    y = pos[1];
                    z = pos[2];
                    BlockVector vec = new BlockVector(x, y, z);
                    tileEntitiesMap.put(vec, t.getValue());
                }
            }
            byte[] blocks = SpongeSchematicHelper.getChildTag((Map<String, Tag>)schematic, "BlockData", ByteArrayTag.class).getValue();
            int i = 0;
            int index = 0;
            while (i < blocks.length) {
                int value = 0;
                int varintLength = 0;
                while (true) {
                    value |= (blocks[i] & 0x7F) << varintLength++ * 7;
                    if (varintLength > 5) {
                        throw new Exception("Schem file blocks tag data corrupted");
                    }
                    if ((blocks[i] & 0x80) != 128) {
                        ++i;
                        break;
                    }
                    ++i;
                }
                BlockData block = NMSHandler.getBlockHelper().getBlockData((ModernBlockData)palette.get(value));
                y = index / (width * length);
                z = index % (width * length) / width;
                int x = index % (width * length) % width;
                int cbsIndex = z + y * cbs.z_height + x * cbs.z_height * cbs.y_length;
                BlockVector pt = new BlockVector(x, y, z);
                if (tileEntitiesMap.containsKey(pt)) {
                    CompoundTag otag = NMSHandler.getInstance().createCompoundTag((Map)tileEntitiesMap.get(pt));
                    block.setCompoundTag(otag);
                }
                cbs.blocks[cbsIndex] = block;
                ++index;
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        return cbs;
    }

    private static <T extends Tag> T getChildTag(Map<String, Tag> items, String key, Class<T> expected) throws Exception {
        if (!items.containsKey(key)) {
            throw new Exception("Schem file is missing a '" + key + "' tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new Exception(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((Tag)expected.cast(tag));
    }

    public static void saveToSpongeStream(CuboidBlockSet blockSet, OutputStream os) {
        try {
            HashMap<String, Tag> schematic = new HashMap<String, Tag>();
            schematic.put("Width", new ShortTag((short)blockSet.x_width));
            schematic.put("Length", new ShortTag((short)blockSet.z_height));
            schematic.put("Height", new ShortTag((short)blockSet.y_length));
            schematic.put("DenizenOffset", new IntArrayTag(new int[]{blockSet.center_x, blockSet.center_y, blockSet.center_z}));
            HashMap<String, Tag> palette = new HashMap<String, Tag>();
            ByteArrayOutputStream blocksBuffer = new ByteArrayOutputStream(blockSet.x_width * blockSet.y_length * blockSet.z_height);
            ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
            int paletteMax = 0;
            for (int y = 0; y < blockSet.y_length; ++y) {
                for (int z = 0; z < blockSet.z_height; ++z) {
                    for (int x = 0; x < blockSet.x_width; ++x) {
                        int cbsIndex = z + y * blockSet.z_height + x * blockSet.z_height * blockSet.y_length;
                        BlockData bd = blockSet.blocks[cbsIndex];
                        String dataStr = bd.modern().data.getAsString();
                        Tag blockIdTag = (Tag)palette.get(dataStr);
                        if (blockIdTag == null) {
                            blockIdTag = new IntTag(paletteMax++);
                            palette.put(dataStr, blockIdTag);
                        }
                        int blockId = ((IntTag)blockIdTag).getValue();
                        while ((blockId & 0xFFFFFF80) != 0) {
                            blocksBuffer.write(blockId & 0x7F | 0x80);
                            blockId >>>= 7;
                        }
                        blocksBuffer.write(blockId);
                        CompoundTag rawTag = bd.getCompoundTag();
                        if (rawTag == null) continue;
                        HashMap<String, Tag> values = new HashMap<String, Tag>();
                        for (Map.Entry entry : rawTag.getValue().entrySet()) {
                            values.put((String)entry.getKey(), (Tag)entry.getValue());
                        }
                        values.put("Pos", new IntArrayTag(new int[]{x, y, z}));
                        CompoundTag tileEntityTag = NMSHandler.getInstance().createCompoundTag(values);
                        tileEntities.add(tileEntityTag);
                    }
                }
            }
            schematic.put("PaletteMax", new IntTag(paletteMax));
            schematic.put("Palette", NMSHandler.getInstance().createCompoundTag(palette));
            schematic.put("BlockData", new ByteArrayTag(blocksBuffer.toByteArray()));
            schematic.put("BlockEntities", new ListTag(CompoundTag.class, tileEntities));
            CompoundTag schematicTag = NMSHandler.getInstance().createCompoundTag(schematic);
            NBTOutputStream stream = new NBTOutputStream(new GZIPOutputStream(os));
            stream.writeNamedTag("Schematic", schematicTag);
            os.flush();
            stream.close();
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
    }
}

