/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.CustomObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.commands.Comparable;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.SQLEscaper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public class ElementTag
implements ObjectTag {
    @Deprecated
    public static final ElementTag TRUE = new ElementTag(Boolean.TRUE);
    @Deprecated
    public static final ElementTag FALSE = new ElementTag(Boolean.FALSE);
    @Deprecated
    public static final ElementTag SERVER = new ElementTag("server");
    @Deprecated
    public static final ElementTag NULL = new ElementTag("null");
    static final Pattern VALUE_PATTERN = Pattern.compile("el@val(?:ue)?\\[([^\\[\\]]+)\\].*", 42);
    private final String element;
    static final BigDecimal max = new BigDecimal("10E1000");
    private String prefix;
    public static ObjectTagProcessor<ElementTag> tagProcessor = new ObjectTagProcessor();

    public static ElementTag valueOf(String string) {
        return ElementTag.valueOf(string, null);
    }

    @Fetchable(value="el")
    public static ElementTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Matcher m = VALUE_PATTERN.matcher(string);
        if (m.matches()) {
            String value = m.group(1);
            return new ElementTag(value);
        }
        return new ElementTag(CoreUtilities.toLowerCase(string).startsWith("el@") ? string.substring(3) : string);
    }

    public static boolean matches(String string) {
        return string != null;
    }

    public static <T extends ObjectTag> T handleNull(String tag, T object, String type, boolean has_fallback) {
        if (object == null) {
            if (!has_fallback) {
                Debug.echoError("'" + tag + "' is an invalid " + type + "!");
            }
            return null;
        }
        return object;
    }

    public ElementTag(String string) {
        this.prefix = "element";
        if (string == null) {
            if (Debug.verbose) {
                try {
                    throw new RuntimeException("Trace");
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                    Debug.log("Element - Null construction!");
                }
            }
            this.element = "null";
        } else {
            this.element = TagManager.cleanOutput(string);
        }
    }

    public ElementTag(boolean bool) {
        this.prefix = "boolean";
        this.element = String.valueOf(bool);
    }

    public ElementTag(int integer) {
        this.prefix = "number";
        this.element = String.valueOf(integer);
    }

    public ElementTag(byte byt) {
        this.prefix = "number";
        this.element = String.valueOf(byt);
    }

    public ElementTag(short shrt) {
        this.prefix = "number";
        this.element = String.valueOf(shrt);
    }

    public ElementTag(long lng) {
        this.prefix = "number";
        this.element = String.valueOf(lng);
    }

    public ElementTag(BigDecimal bdl) {
        this.prefix = "decimal";
        this.element = CoreUtilities.bigDecToString(bdl);
    }

    public ElementTag(double dbl) {
        this.prefix = "decimal";
        this.element = CoreUtilities.doubleToString(dbl);
    }

    public ElementTag(float flt) {
        this.prefix = "decimal";
        this.element = CoreUtilities.doubleToString(flt);
    }

    public ElementTag(String prefix, String string) {
        this.prefix = prefix == null ? "element" : prefix;
        this.element = TagManager.cleanOutput(string);
    }

    private BigDecimal getBD(String text) {
        BigDecimal bd = new BigDecimal(text);
        if (bd.compareTo(max) >= 1) {
            Debug.echoError("Unreasonably large number detected!");
            return max;
        }
        return bd;
    }

    public BigDecimal asBigDecimal() {
        return this.getBD(this.element.replaceAll("%", ""));
    }

    public double asDouble() {
        return Double.valueOf(this.element.replaceAll("%", ""));
    }

    public float asFloat() {
        return Float.valueOf(this.element.replaceAll("%", "")).floatValue();
    }

    public int asInt() {
        try {
            return Integer.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", ""));
        }
        catch (NumberFormatException ex) {
            Debug.echoError("'" + this.element + "' is not a valid integer!");
            return 0;
        }
    }

    public long asLong() {
        try {
            return Long.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", ""));
        }
        catch (NumberFormatException ex) {
            Debug.echoError("'" + this.element + "' is not a valid integer!");
            return 0L;
        }
    }

    public boolean asBoolean() {
        return Boolean.valueOf(this.element.replaceAll("el@", ""));
    }

    public String asString() {
        return this.element;
    }

    public boolean isBoolean() {
        return this.element != null && (this.element.equalsIgnoreCase("true") || this.element.equalsIgnoreCase("false"));
    }

    public boolean isDouble() {
        try {
            if (!Double.valueOf(this.element).isNaN()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isFloat() {
        try {
            if (!Float.valueOf(this.element).isNaN()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isInt() {
        try {
            Integer val = Integer.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", ""));
            if ((double)val.hashCode() != 0.5) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isString() {
        return this.element != null && !this.element.isEmpty();
    }

    public boolean matchesType(Class<? extends ObjectTag> dClass) {
        return ObjectFetcher.checkMatch(dClass, this.element);
    }

    public <T extends ObjectTag> T asType(Class<T> dClass) {
        return ObjectFetcher.getObjectFrom(dClass, this.element);
    }

    public <T extends ObjectTag> T asType(Class<T> dClass, TagContext context) {
        return ObjectFetcher.getObjectFrom(dClass, this.element, context);
    }

    public boolean matchesEnum(Enum[] values) {
        for (Enum value : values) {
            if (!value.name().equalsIgnoreCase(this.element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getObjectType() {
        return "Element";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String identify() {
        return this.element;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    public static void registerTags() {
        ElementTag.registerTag("is", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (attribute.hasContext(1) && (attribute.startsWith("to", 2) || attribute.startsWith("than", 2)) && attribute.hasContext(2)) {
                    String operator;
                    Comparable com = new Comparable();
                    if (attribute.getContext(1).startsWith("!")) {
                        operator = attribute.getContext(1).substring(1);
                        com.setNegativeLogic();
                    } else {
                        operator = attribute.getContext(1);
                    }
                    Comparable.Operator comparableOperator = null;
                    try {
                        comparableOperator = Comparable.Operator.valueOf(operator.replace("==", "EQUALS").replace(">=", "OR_MORE").replace("<=", "OR_LESS").replace("<", "LESS").replace(">", "MORE").replace("=", "EQUALS").toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (comparableOperator != null) {
                        com.setOperator(comparableOperator);
                        com.setComparable(object.toString());
                        com.setComparedto(attribute.getContext(2));
                        attribute.fulfill(1);
                        return new ElementTag(com.determineOutcome());
                    }
                    Debug.echoError("Unknown operator '" + operator + "'.");
                }
                return null;
            }
        });
        ElementTag.registerTag("is_boolean", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(element.equalsIgnoreCase("true") || element.equalsIgnoreCase("false"));
            }
        });
        ElementTag.registerTag("is_integer", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(ArgumentHelper.integerPrimitive.matcher(element).matches());
            }
        });
        ElementTag.registerTag("is_decimal", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(ArgumentHelper.doublePrimitive.matcher(element).matches());
            }
        });
        ElementTag.registerTag("is_odd", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(ArgumentHelper.doublePrimitive.matcher(element).matches() && object.asBigDecimal().longValue() % 2L == 1L);
            }
        });
        ElementTag.registerTag("is_even", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(ArgumentHelper.doublePrimitive.matcher(element).matches() && object.asBigDecimal().longValue() % 2L == 0L);
            }
        });
        ElementTag.registerTag("as_element", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return object;
            }
        });
        ElementTag.registerTag("aselement", ElementTag.tagProcessor.registeredObjectTags.get("as_element"));
        ElementTag.registerTag("as_boolean", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(element.equalsIgnoreCase("true") || element.equalsIgnoreCase("t") || element.equalsIgnoreCase("1"));
            }
        });
        ElementTag.registerTag("asboolean", ElementTag.tagProcessor.registeredObjectTags.get("as_boolean"));
        ElementTag.registerTag("as_decimal", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                try {
                    return new ElementTag(Double.valueOf(element));
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("'" + element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        ElementTag.registerTag("as_double", ElementTag.tagProcessor.registeredObjectTags.get("as_decimal"));
        ElementTag.registerTag("asdouble", ElementTag.tagProcessor.registeredObjectTags.get("as_decimal"));
        ElementTag.registerTag("as_int", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                Deprecations.elementAsInTag.warn(attribute.context);
                String element = object.element;
                try {
                    return new ElementTag(Double.valueOf(element).longValue());
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("'" + element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        ElementTag.registerTag("asint", ElementTag.tagProcessor.registeredObjectTags.get("as_int"));
        ElementTag.registerTag("truncate", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                try {
                    return new ElementTag(object.asBigDecimal().longValue());
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("'" + object.element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        ElementTag.registerTag("as_money", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                try {
                    DecimalFormat d = new DecimalFormat("0.00");
                    return new ElementTag(d.format(Double.valueOf(element)));
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("'" + element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        ElementTag.registerTag("asmoney", ElementTag.tagProcessor.registeredObjectTags.get("as_money"));
        ElementTag.registerTag("as_list", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                ListTag obj = ElementTag.handleNull(element, ListTag.valueOf(element), "dList", attribute.hasAlternative());
                if (obj != null) {
                    return obj;
                }
                return null;
            }
        });
        ElementTag.registerTag("aslist", ElementTag.tagProcessor.registeredObjectTags.get("as_list"));
        ElementTag.registerTag("as_custom", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                CustomObjectTag obj = ElementTag.handleNull(element, CustomObjectTag.valueOf(element, null), "Custom", attribute.hasAlternative());
                if (obj != null) {
                    return obj;
                }
                return null;
            }
        });
        ElementTag.registerTag("ascustom", ElementTag.tagProcessor.registeredObjectTags.get("as_custom"));
        ElementTag.registerTag("as_script", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                ScriptTag obj = ElementTag.handleNull(element, ScriptTag.valueOf(element), "dScript", attribute.hasAlternative());
                return obj;
            }
        });
        ElementTag.registerTag("asscript", ElementTag.tagProcessor.registeredObjectTags.get("as_script"));
        ElementTag.registerTag("as_queue", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                QueueTag obj = ElementTag.handleNull(element, QueueTag.valueOf(element), "ScriptQueue", attribute.hasAlternative());
                return obj;
            }
        });
        ElementTag.registerTag("asqueue", ElementTag.tagProcessor.registeredObjectTags.get("as_queue"));
        ElementTag.registerTag("as_duration", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                DurationTag obj = ElementTag.handleNull(element, DurationTag.valueOf(element), "Duration", attribute.hasAlternative());
                return obj;
            }
        });
        ElementTag.registerTag("asduration", ElementTag.tagProcessor.registeredObjectTags.get("as_duration"));
        ElementTag.registerTag("escaped", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(EscapeTagBase.escape(element));
            }
        });
        ElementTag.registerTag("sql_escaped", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(SQLEscaper.escapeSQL(element));
            }
        });
        ElementTag.registerTag("unescaped", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                return new ElementTag(EscapeTagBase.unEscape(element));
            }
        });
        ElementTag.registerTag("parsed", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ObjectTag read = TagManager.tagObject(TagManager.cleanOutputFully(object.element), attribute.context);
                return read;
            }
        });
        ElementTag.registerTag("difference", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                String two = attribute.getContext(1);
                return new ElementTag(CoreUtilities.getLevenshteinDistance(element, two));
            }
        });
        ElementTag.registerTag("contains_any_case_sensitive", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                ListTag list = ListTag.valueOf(attribute.getContext(1));
                for (String list_element : list) {
                    if (!element.contains(list_element)) continue;
                    return new ElementTag(true);
                }
                return new ElementTag(false);
            }
        });
        Object r = ElementTag.tagProcessor.registeredObjectTags.get("contains_any_case_sensitive").clone();
        ((TagRunnable.ObjectForm)r).name = null;
        ElementTag.registerTag("contains_any_case_sensitive_text", (TagRunnable.ObjectForm<ElementTag>)r);
        ElementTag.registerTag("contains_any", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                ListTag list = ListTag.valueOf(CoreUtilities.toLowerCase(attribute.getContext(1)));
                String ellow = CoreUtilities.toLowerCase(element);
                for (String list_element : list) {
                    if (!ellow.contains(list_element)) continue;
                    return new ElementTag(true);
                }
                return new ElementTag(false);
            }
        });
        r = ElementTag.tagProcessor.registeredObjectTags.get("contains_any").clone();
        ((TagRunnable.ObjectForm)r).name = null;
        ElementTag.registerTag("contains_any_text", (TagRunnable.ObjectForm<ElementTag>)r);
        ElementTag.registerTag("contains_case_sensitive", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String contains;
                String element = object.element;
                if (element.contains(contains = attribute.getContext(1))) {
                    return new ElementTag("true");
                }
                return new ElementTag("false");
            }
        });
        r = ElementTag.tagProcessor.registeredObjectTags.get("contains_case_sensitive").clone();
        ((TagRunnable.ObjectForm)r).name = null;
        ElementTag.registerTag("contains_case_sensitive_text", (TagRunnable.ObjectForm<ElementTag>)r);
        ElementTag.registerTag("contains", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                String contains = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(contains).startsWith("regex:")) {
                    if (Pattern.compile(contains.substring("regex:".length()), 2).matcher(element).matches()) {
                        return new ElementTag("true");
                    }
                    return new ElementTag("false");
                }
                if (CoreUtilities.toLowerCase(element).contains(CoreUtilities.toLowerCase(contains))) {
                    return new ElementTag("true");
                }
                return new ElementTag("false");
            }
        });
        r = ElementTag.tagProcessor.registeredObjectTags.get("contains").clone();
        ((TagRunnable.ObjectForm)r).name = null;
        ElementTag.registerTag("contains_text", (TagRunnable.ObjectForm<ElementTag>)r);
        ElementTag.registerTag("contains_all", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                ListTag list = ListTag.valueOf(CoreUtilities.toLowerCase(attribute.getContext(1)));
                String ellow = CoreUtilities.toLowerCase(element);
                for (String list_element : list) {
                    if (ellow.contains(list_element)) continue;
                    return new ElementTag("false");
                }
                return new ElementTag("true");
            }
        });
        r = ElementTag.tagProcessor.registeredObjectTags.get("contains_all").clone();
        ((TagRunnable.ObjectForm)r).name = null;
        ElementTag.registerTag("contains_all_text", (TagRunnable.ObjectForm<ElementTag>)r);
        ElementTag.registerTag("contains_all_case_sensitive", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String element = object.element;
                ListTag list = ListTag.valueOf(attribute.getContext(1));
                for (String list_element : list) {
                    if (element.contains(list_element)) continue;
                    return new ElementTag("false");
                }
                return new ElementTag("true");
            }
        });
        r = ElementTag.tagProcessor.registeredObjectTags.get("contains_all_case_sensitive").clone();
        ((TagRunnable.ObjectForm)r).name = null;
        ElementTag.registerTag("contains_all_case_sensitive_text", (TagRunnable.ObjectForm<ElementTag>)r);
        ElementTag.registerTag("ends_with", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(CoreUtilities.toLowerCase(object.element).endsWith(CoreUtilities.toLowerCase(attribute.getContext(1))));
            }
        });
        ElementTag.registerTag("endswith", ElementTag.tagProcessor.registeredObjectTags.get("ends_with"));
        ElementTag.registerTag("equals_case_sensitive", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.equals_case_sensitive[...] must have a value.");
                    return null;
                }
                return new ElementTag(object.element.equals(attribute.getContext(1)));
            }
        });
        ElementTag.registerTag("equals_with_case", ElementTag.tagProcessor.registeredObjectTags.get("equals_case_sensitive"));
        ElementTag.registerTag("matches", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.matches[...] must have a value.");
                    return null;
                }
                return new ElementTag(object.element.matches(attribute.getContext(1)));
            }
        });
        ElementTag.registerTag("regex", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1) || !attribute.hasContext(2)) {
                    Debug.echoError("The tag ElementTag.regex[...] must have a value.");
                    return null;
                }
                String regex = attribute.getContext(1);
                Matcher m = Pattern.compile(regex).matcher(object.element);
                if (!m.matches()) {
                    return null;
                }
                int group = new ElementTag(attribute.getContext(2)).asInt();
                if (group < 0) {
                    group = 0;
                }
                if (group > m.groupCount()) {
                    group = m.groupCount();
                }
                attribute.fulfill(1);
                return new ElementTag(m.group(group));
            }
        });
        ElementTag.registerTag("length", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(object.element.length());
            }
        });
        ElementTag.registerTag("not", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(!object.element.equalsIgnoreCase("true"));
            }
        });
        ElementTag.registerTag("and", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(object.element.equalsIgnoreCase("true") && attribute.getContext(1).equalsIgnoreCase("true"));
            }
        });
        ElementTag.registerTag("or", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(object.element.equalsIgnoreCase("true") || attribute.getContext(1).equalsIgnoreCase("true"));
            }
        });
        ElementTag.registerTag("xor", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(object.element.equalsIgnoreCase("true") != attribute.getContext(1).equalsIgnoreCase("true"));
            }
        });
        ElementTag.registerTag("starts_with", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(CoreUtilities.toLowerCase(object.element).startsWith(CoreUtilities.toLowerCase(attribute.getContext(1))));
            }
        });
        ElementTag.registerTag("startswith", ElementTag.tagProcessor.registeredObjectTags.get("starts_with"));
        ElementTag.registerTag("index_of", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.index_of[...] must have a value.");
                    return null;
                }
                return new ElementTag(CoreUtilities.toLowerCase(object.element).indexOf(CoreUtilities.toLowerCase(attribute.getContext(1))) + 1);
            }
        });
        ElementTag.registerTag("last_index_of", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.last_index_of[...] must have a value.");
                    return null;
                }
                return new ElementTag(CoreUtilities.toLowerCase(object.element).lastIndexOf(CoreUtilities.toLowerCase(attribute.getContext(1))) + 1);
            }
        });
        ElementTag.registerTag("char_at", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.char_at[...] must have a value.");
                    return null;
                }
                int index = attribute.getIntContext(1) - 1;
                if (index < 0 || index >= object.element.length()) {
                    return null;
                }
                return new ElementTag(String.valueOf(object.element.charAt(index)));
            }
        });
        ElementTag.registerTag("after_last", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.after_last[...] must have a value.");
                    return null;
                }
                String delimiter = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(object.element).contains(CoreUtilities.toLowerCase(delimiter))) {
                    return new ElementTag(object.element.substring(CoreUtilities.toLowerCase(object.element).lastIndexOf(CoreUtilities.toLowerCase(delimiter)) + delimiter.length()));
                }
                return new ElementTag("");
            }
        });
        ElementTag.registerTag("after", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.after[...] must have a value.");
                    return null;
                }
                String delimiter = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(object.element).contains(CoreUtilities.toLowerCase(delimiter))) {
                    return new ElementTag(object.element.substring(CoreUtilities.toLowerCase(object.element).indexOf(CoreUtilities.toLowerCase(delimiter)) + delimiter.length()));
                }
                return new ElementTag("");
            }
        });
        ElementTag.registerTag("before_last", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.before_last[...] must have a value.");
                    return null;
                }
                String delimiter = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(object.element).contains(CoreUtilities.toLowerCase(delimiter))) {
                    return new ElementTag(object.element.substring(0, CoreUtilities.toLowerCase(object.element).lastIndexOf(CoreUtilities.toLowerCase(delimiter))));
                }
                return new ElementTag(object.element);
            }
        });
        ElementTag.registerTag("before", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.before[...] must have a value.");
                    return null;
                }
                String delimiter = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(object.element).contains(CoreUtilities.toLowerCase(delimiter))) {
                    return new ElementTag(object.element.substring(0, CoreUtilities.toLowerCase(object.element).indexOf(CoreUtilities.toLowerCase(delimiter))));
                }
                return new ElementTag(object.element);
            }
        });
        ElementTag.registerTag("replace", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.replace[...] must have a value.");
                    return null;
                }
                String replace = attribute.getContext(1);
                String replacement = "";
                if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                    replacement = attribute.getContext(2);
                    if (replacement == null) {
                        Debug.echoError("The tag ElementTag.replace[...].with[...] must have a value.");
                        return null;
                    }
                    attribute.fulfill(1);
                }
                if (replace.startsWith("regex:")) {
                    return new ElementTag(object.element.replaceAll(replace.substring("regex:".length()), replacement));
                }
                if (replace.startsWith("firstregex:")) {
                    return new ElementTag(object.element.replaceFirst(replace.substring("firstregex:".length()), replacement));
                }
                return new ElementTag(object.element.replaceAll("(?i)" + Pattern.quote(replace), replacement));
            }
        });
        r = ElementTag.tagProcessor.registeredObjectTags.get("replace").clone();
        ((TagRunnable.ObjectForm)r).name = null;
        ElementTag.registerTag("replace_text", (TagRunnable.ObjectForm<ElementTag>)r);
        ElementTag.registerTag("format_number", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                try {
                    String afterdecimal;
                    String shortelement;
                    int decimal = object.element.indexOf(46);
                    if (decimal != -1) {
                        shortelement = object.element.substring(0, decimal);
                        afterdecimal = object.element.substring(decimal);
                    } else {
                        shortelement = object.element;
                        afterdecimal = "";
                    }
                    String intform = Long.valueOf(shortelement.replace("%", "")).toString();
                    String negative = "";
                    if (intform.startsWith("-")) {
                        negative = "-";
                        intform = intform.substring(1);
                    }
                    for (int i = intform.length() - 3; i > 0; i -= 3) {
                        intform = intform.substring(0, i) + "," + intform.substring(i);
                    }
                    return new ElementTag(negative + intform + afterdecimal);
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                    return null;
                }
            }
        });
        ElementTag.registerTag("to_list", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ListTag list = new ListTag();
                for (int i = 0; i < object.element.length(); ++i) {
                    list.add(String.valueOf(object.element.charAt(i)));
                }
                return list;
            }
        });
        ElementTag.registerTag("trim", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(object.element.trim());
            }
        });
        ElementTag.registerTag("to_uppercase", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(object.element.toUpperCase());
            }
        });
        ElementTag.registerTag("upper", ElementTag.tagProcessor.registeredObjectTags.get("to_uppercase"));
        ElementTag.registerTag("to_lowercase", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag(CoreUtilities.toLowerCase(object.element));
            }
        });
        ElementTag.registerTag("lower", ElementTag.tagProcessor.registeredObjectTags.get("to_lowercase"));
        ElementTag.registerTag("to_titlecase", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (object.element.length() == 0) {
                    return new ElementTag("");
                }
                StringBuilder TitleCase = new StringBuilder(object.element.length());
                String Upper = object.element.toUpperCase();
                String Lower = CoreUtilities.toLowerCase(object.element);
                TitleCase.append(Upper.charAt(0));
                for (int i = 1; i < object.element.length(); ++i) {
                    if (object.element.charAt(i - 1) == ' ') {
                        TitleCase.append(Upper.charAt(i));
                        continue;
                    }
                    TitleCase.append(Lower.charAt(i));
                }
                return new ElementTag(TitleCase.toString());
            }
        });
        ElementTag.registerTag("totitlecase", ElementTag.tagProcessor.registeredObjectTags.get("to_titlecase"));
        ElementTag.registerTag("substring", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.substring[...] must have a value.");
                    return null;
                }
                int beginning_index = new ElementTag(attribute.getContext(1).split(",")[0]).asInt() - 1;
                int ending_index = attribute.getContext(1).split(",").length > 1 ? new ElementTag(attribute.getContext(1).split(",")[1]).asInt() : object.element.length();
                if (beginning_index < 0) {
                    beginning_index = 0;
                }
                if (beginning_index > object.element.length()) {
                    beginning_index = object.element.length();
                }
                if (ending_index > object.element.length()) {
                    ending_index = object.element.length();
                }
                if (ending_index < beginning_index) {
                    ending_index = beginning_index;
                }
                return new ElementTag(object.element.substring(beginning_index, ending_index));
            }
        });
        ElementTag.registerTag("substr", ElementTag.tagProcessor.registeredObjectTags.get("substring"));
        ElementTag.registerTag("split", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String[] split;
                String split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
                split_string = CoreUtilities.toLowerCase(split_string).startsWith("regex:") ? split_string.split(":", 2)[1] : "(?i)" + Pattern.quote(split_string);
                if (attribute.startsWith("limit", 2)) {
                    int limit = attribute.hasContext(2) ? attribute.getIntContext(2) : 1;
                    attribute.fulfill(1);
                    split = object.element.split(split_string, limit);
                } else {
                    split = object.element.split(split_string);
                }
                return new ListTag(Arrays.asList(split));
            }
        });
        ElementTag.registerTag("pad_left", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.pad_left[...] must have a value.");
                    return null;
                }
                String with = String.valueOf('\u00a0');
                int length = attribute.getIntContext(1);
                if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                    with = String.valueOf(attribute.getContext(2).charAt(0));
                    attribute.fulfill(1);
                }
                StringBuilder padded = new StringBuilder();
                length -= object.element.length();
                while (padded.length() < length) {
                    padded.append(with);
                }
                padded.append(object.element);
                return new ElementTag(padded.toString());
            }
        });
        ElementTag.registerTag("pad_right", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.pad_right[...] must have a value.");
                    return null;
                }
                String with = String.valueOf('\u00a0');
                int length = attribute.getIntContext(1);
                if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                    with = String.valueOf(attribute.getContext(2).charAt(0));
                    attribute.fulfill(1);
                }
                StringBuilder padded = new StringBuilder(object.element);
                while (padded.length() < length) {
                    padded.append(with);
                }
                return new ElementTag(padded.toString());
            }
        });
        ElementTag.registerTag("abs", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.abs(ele.asDouble()));
            }
        });
        ElementTag.registerTag("max", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.max(ele.asDouble(), new ElementTag(attribute.getContext(1)).asDouble()));
            }
        });
        ElementTag.registerTag("min", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.min(ele.asDouble(), new ElementTag(attribute.getContext(1)).asDouble()));
            }
        });
        ElementTag.registerTag("add_int", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(ele.asLong() + ArgumentHelper.getLongFrom(attribute.getContext(1)));
            }
        });
        ElementTag.registerTag("div_int", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(ele.asLong() / ArgumentHelper.getLongFrom(attribute.getContext(1)));
            }
        });
        ElementTag.registerTag("mul_int", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(ele.asLong() * ArgumentHelper.getLongFrom(attribute.getContext(1)));
            }
        });
        ElementTag.registerTag("sub_int", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(ele.asLong() - ArgumentHelper.getLongFrom(attribute.getContext(1)));
            }
        });
        TagRunnable.ObjectForm<ElementTag> addRunnable = new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.add[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                try {
                    return new ElementTag(ele.asBigDecimal().add(ele.getBD(attribute.getContext(1))));
                }
                catch (Throwable e) {
                    return new ElementTag(ele.asDouble() + ArgumentHelper.getDoubleFrom(attribute.getContext(1)));
                }
            }
        };
        ElementTag.registerTag("add", (TagRunnable.ObjectForm<ElementTag>)addRunnable.clone());
        ElementTag.registerTag("+", (TagRunnable.ObjectForm<ElementTag>)addRunnable.clone());
        TagRunnable.ObjectForm<ElementTag> divRunnable = new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.div[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                try {
                    return new ElementTag(ele.asBigDecimal().divide(ele.getBD(attribute.getContext(1)), 64, RoundingMode.HALF_UP));
                }
                catch (Throwable e) {
                    return new ElementTag(ele.asDouble() / ArgumentHelper.getDoubleFrom(attribute.getContext(1)));
                }
            }
        };
        ElementTag.registerTag("div", (TagRunnable.ObjectForm<ElementTag>)divRunnable.clone());
        ElementTag.registerTag("/", (TagRunnable.ObjectForm<ElementTag>)divRunnable.clone());
        TagRunnable.ObjectForm<ElementTag> modRunnable = new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.mod[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(ele.asDouble() % ArgumentHelper.getDoubleFrom(attribute.getContext(1)));
            }
        };
        ElementTag.registerTag("mod", (TagRunnable.ObjectForm<ElementTag>)modRunnable.clone());
        ElementTag.registerTag("%", (TagRunnable.ObjectForm<ElementTag>)modRunnable.clone());
        TagRunnable.ObjectForm<ElementTag> mulRunnable = new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.mul[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                try {
                    return new ElementTag(ele.asBigDecimal().multiply(ele.getBD(attribute.getContext(1))));
                }
                catch (Throwable e) {
                    return new ElementTag(ele.asDouble() * ArgumentHelper.getDoubleFrom(attribute.getContext(1)));
                }
            }
        };
        ElementTag.registerTag("mul", (TagRunnable.ObjectForm<ElementTag>)mulRunnable.clone());
        ElementTag.registerTag("*", (TagRunnable.ObjectForm<ElementTag>)mulRunnable.clone());
        TagRunnable.ObjectForm<ElementTag> subRunnable = new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.sub[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                try {
                    return new ElementTag(ele.asBigDecimal().subtract(ele.getBD(attribute.getContext(1))));
                }
                catch (Throwable e) {
                    return new ElementTag(ele.asDouble() - ArgumentHelper.getDoubleFrom(attribute.getContext(1)));
                }
            }
        };
        ElementTag.registerTag("sub", (TagRunnable.ObjectForm<ElementTag>)subRunnable.clone());
        ElementTag.registerTag("-", (TagRunnable.ObjectForm<ElementTag>)subRunnable.clone());
        ElementTag.registerTag("sqrt", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.sqrt(ele.asDouble()));
            }
        });
        ElementTag.registerTag("log", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.log[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.log(ele.asDouble()) / Math.log(ArgumentHelper.getDoubleFrom(attribute.getContext(1))));
            }
        });
        ElementTag.registerTag("ln", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.log(ele.asDouble()));
            }
        });
        TagRunnable.ObjectForm<ElementTag> powerRunnable = new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.power[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.pow(ele.asDouble(), ArgumentHelper.getDoubleFrom(attribute.getContext(1))));
            }
        };
        ElementTag.registerTag("power", (TagRunnable.ObjectForm<ElementTag>)powerRunnable.clone());
        ElementTag.registerTag("^", (TagRunnable.ObjectForm<ElementTag>)powerRunnable.clone());
        ElementTag.registerTag("asin", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.asin(ele.asDouble()));
            }
        });
        ElementTag.registerTag("acos", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.acos(ele.asDouble()));
            }
        });
        ElementTag.registerTag("atan", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.atan(ele.asDouble()));
            }
        });
        ElementTag.registerTag("atan2", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.atan2[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.atan2(ele.asDouble(), attribute.getDoubleContext(1)));
            }
        });
        ElementTag.registerTag("cos", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.cos(ele.asDouble()));
            }
        });
        ElementTag.registerTag("sin", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.sin(ele.asDouble()));
            }
        });
        ElementTag.registerTag("tan", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.tan(ele.asDouble()));
            }
        });
        ElementTag.registerTag("to_degrees", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.toDegrees(ele.asDouble()));
            }
        });
        ElementTag.registerTag("to_radians", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.toRadians(ele.asDouble()));
            }
        });
        ElementTag.registerTag("round_up", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag((long)Math.ceil(ele.asDouble()));
            }
        });
        ElementTag.registerTag("round_down", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag((long)Math.floor(ele.asDouble()));
            }
        });
        ElementTag.registerTag("round_to", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.round_to[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                int ten = (int)Math.pow(10.0, attribute.getIntContext(1));
                return new ElementTag((double)Math.round(ele.asDouble() * (double)ten) / (double)ten);
            }
        });
        ElementTag.registerTag("round", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new ElementTag(Math.round(ele.asDouble()));
            }
        });
        ElementTag.registerTag("round_to_precision", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.round_to_precision[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                double precision = attribute.getDoubleContext(1);
                return new ElementTag((double)Math.round(ele.asDouble() / precision) * precision);
            }
        });
        ElementTag.registerTag("round_down_to_precision", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.round_down_to_precision[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                double precision = attribute.getDoubleContext(1);
                return new ElementTag(Math.floor(ele.asDouble() / precision) * precision);
            }
        });
        ElementTag.registerTag("round_up_to_precision", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ElementTag.round_up_to_precision[...] must have a value.");
                    return null;
                }
                ElementTag ele = object;
                if (!ele.isDouble()) {
                    Debug.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                double precision = attribute.getDoubleContext(1);
                return new ElementTag(Math.ceil(ele.asDouble() / precision) * precision);
            }
        });
        ElementTag.registerTag("base64_encode", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String encoded = Base64.getEncoder().encodeToString(object.element.getBytes());
                return new ElementTag(encoded);
            }
        });
        ElementTag.registerTag("base64_decode", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String decoded = new String(Base64.getDecoder().decode(object.element));
                return new ElementTag(decoded);
            }
        });
        ElementTag.registerTag("hex_encode", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String encoded = DatatypeConverter.printHexBinary((byte[])object.element.getBytes());
                return new ElementTag(encoded);
            }
        });
        ElementTag.registerTag("hex_decode", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                String decoded = new String(DatatypeConverter.parseHexBinary((String)object.element));
                return new ElementTag(decoded);
            }
        });
        ElementTag.registerTag("url_encode", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                try {
                    String encoded = URLEncoder.encode(object.element, "UTF-8");
                    return new ElementTag(encoded);
                }
                catch (Exception e) {
                    Debug.echoError(e);
                    return null;
                }
            }
        });
        ElementTag.registerTag("url_decode", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                try {
                    String decoded = URLDecoder.decode(object.element, "UTF-8");
                    return new ElementTag(decoded);
                }
                catch (Exception e) {
                    Debug.echoError(e);
                    return null;
                }
            }
        });
        ElementTag.registerTag("type", new TagRunnable.ObjectForm<ElementTag>(){

            @Override
            public ObjectTag run(Attribute attribute, ElementTag object) {
                return new ElementTag("Element");
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm<ElementTag> runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag getNextObjectTypeDown() {
        return new FailedObjectTag();
    }

    public static class FailedObjectTag
    implements ObjectTag {
        @Override
        public String getPrefix() {
            return null;
        }

        @Override
        public boolean isUnique() {
            return false;
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public String identify() {
            return null;
        }

        @Override
        public String identifySimple() {
            return null;
        }

        @Override
        public ObjectTag setPrefix(String prefix) {
            return null;
        }

        @Override
        public ObjectTag getObjectAttribute(Attribute attribute) {
            if (!attribute.hasAlternative()) {
                Debug.echoDebug((Debuggable)attribute.getScriptEntry(), "Unfilled attributes '" + attribute.unfilledString() + "' for tag <" + attribute.getOrigin() + ">!");
                if (attribute.seemingSuccesses.size() > 0) {
                    String almost = attribute.seemingSuccesses.get(attribute.seemingSuccesses.size() - 1);
                    if (attribute.hasContextFailed) {
                        Debug.echoDebug((Debuggable)attribute.getScriptEntry(), "Almost matched but failed (missing [context] parameter?): " + almost);
                    } else {
                        Debug.echoDebug((Debuggable)attribute.getScriptEntry(), "Almost matched but failed (possibly bad input?): " + almost);
                    }
                }
            }
            if (Debug.verbose) {
                Debug.log("Element - Unfilled! Null!");
            }
            return null;
        }
    }
}

