/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.Delayable;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class QueueTag
implements ObjectTag,
Adjustable {
    public ScriptQueue queue;
    String prefix = "Queue";
    public static ObjectTagProcessor<QueueTag> tagProcessor = new ObjectTagProcessor();

    public static QueueTag valueOf(String string) {
        return QueueTag.valueOf(string, null);
    }

    @Fetchable(value="q")
    public static QueueTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("q@") && string.length() > 2) {
            string = string.substring(2);
        }
        if (ScriptQueue.queueExists(string)) {
            return new QueueTag(ScriptQueue.getExistingQueue(string));
        }
        return null;
    }

    public static boolean matches(String string) {
        return CoreUtilities.toLowerCase(string).startsWith("q@");
    }

    public QueueTag(ScriptQueue queue) {
        this.queue = queue;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public QueueTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "queue";
    }

    @Override
    public String identify() {
        return "q@" + this.queue.id;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        QueueTag.registerTag("id", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                return new ElementTag(object.getQueue().id);
            }
        });
        QueueTag.registerTag("size", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                return new ElementTag(object.getQueue().script_entries.size());
            }
        });
        QueueTag.registerTag("start_time", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                return new DurationTag(object.getQueue().startTimeMilli / 50L);
            }
        });
        QueueTag.registerTag("time_ran", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                long timeNano = System.nanoTime() - object.getQueue().startTime;
                return new DurationTag((double)timeNano / 1.0E9);
            }
        });
        QueueTag.registerTag("state", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                String state = object.getQueue() instanceof Delayable && ((Delayable)((Object)object.getQueue())).isPaused() ? "paused" : (object.getQueue().is_started ? "running" : (object.getQueue().is_stopping ? "stopping" : "unknown"));
                return new ElementTag(state);
            }
        });
        QueueTag.registerTag("script", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                if (object.getQueue().script == null) {
                    return null;
                }
                return object.getQueue().script;
            }
        });
        QueueTag.registerTag("commands", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                ListTag commands = new ListTag();
                for (ScriptEntry entry : object.getQueue().script_entries) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(entry.getCommandName()).append(" ");
                    for (String arg : entry.getOriginalArguments()) {
                        sb.append(arg).append(" ");
                    }
                    commands.add(sb.substring(0, sb.length() - 1));
                }
                return commands;
            }
        });
        QueueTag.registerTag("definitions", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                return new ListTag(object.getQueue().getAllDefinitions().keySet());
            }
        });
        QueueTag.registerTag("definition", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag QueueTag.definition[...] must have a value.");
                    return null;
                }
                return object.getQueue().getDefinitionObject(attribute.getContext(1));
            }
        });
        QueueTag.registerTag("determination", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                if (object.getQueue().determinations == null) {
                    return null;
                }
                return object.getQueue().determinations;
            }
        });
        QueueTag.registerTag("speed", new TagRunnable.ObjectForm<QueueTag>(){

            @Override
            public ObjectTag run(Attribute attribute, QueueTag object) {
                if (!(object.getQueue() instanceof TimedQueue)) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("The tag QueueTag.speed is only valid for Timed queues.");
                    }
                    return null;
                }
                return ((TimedQueue)object.getQueue()).getSpeed();
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm<QueueTag> runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public ScriptQueue getQueue() {
        this.ensure();
        return this.queue;
    }

    public void ensure() {
        while (this.queue.replacementQueue != null) {
            this.queue = this.queue.replacementQueue;
        }
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("QueueTags can not hold properties.");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        this.ensure();
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

