/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;

public class PlayerKickedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerKickedScriptEvent instance;
    public PlayerTag player;
    public PlayerKickEvent event;

    public PlayerKickedScriptEvent() {
        instance = this;
    }

    public boolean isFlying() {
        return NMSHandler.getPlayerHelper().getFlyKickCooldown(this.player.getPlayerEntity()) == 0;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player kicked");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(3).equals("flying")) {
            return this.isFlying();
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerKicked";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            DurationTag duration;
            String lower = CoreUtilities.toLowerCase(determinationObj.toString());
            if (lower.startsWith("message:")) {
                this.event.setLeaveMessage(lower.substring("message:".length()));
                return true;
            }
            if (lower.startsWith("reason:")) {
                this.event.setReason(lower.substring("reason:".length()));
                return true;
            }
            if (lower.startsWith("fly_cooldown:") && (duration = DurationTag.valueOf(lower.substring("fly_cooldown:".length()))) != null) {
                NMSHandler.getPlayerHelper().setFlyKickCooldown(this.player.getPlayerEntity(), (int)duration.getTicks());
                this.cancelled = true;
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("message")) {
            return new ElementTag(this.event.getLeaveMessage());
        }
        if (name.equals("reason")) {
            return new ElementTag(this.event.getReason());
        }
        if (name.equals("flying")) {
            return new ElementTag(this.isFlying());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerKicked(PlayerKickEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.event = event;
        this.fire((Event)event);
    }
}

