/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;

public class ChunkUnloadScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ChunkUnloadScriptEvent instance;
    public ChunkTag chunk;
    public ChunkUnloadEvent event;

    public ChunkUnloadScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("chunk unloads");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.chunk.getCenter())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "ChunkUnloads";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("chunk")) {
            return this.chunk;
        }
        if (name.equals("world")) {
            Deprecations.worldContext.warn();
            return new WorldTag(this.event.getWorld());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        this.chunk = new ChunkTag(event.getChunk());
        this.event = event;
        this.fire((Event)event);
    }
}

