/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.material.MaterialAge;
import com.denizenscript.denizen.objects.properties.material.MaterialCampfire;
import com.denizenscript.denizen.objects.properties.material.MaterialCount;
import com.denizenscript.denizen.objects.properties.material.MaterialDirectional;
import com.denizenscript.denizen.objects.properties.material.MaterialDrags;
import com.denizenscript.denizen.objects.properties.material.MaterialFaces;
import com.denizenscript.denizen.objects.properties.material.MaterialHalf;
import com.denizenscript.denizen.objects.properties.material.MaterialLeafSize;
import com.denizenscript.denizen.objects.properties.material.MaterialLevel;
import com.denizenscript.denizen.objects.properties.material.MaterialLightable;
import com.denizenscript.denizen.objects.properties.material.MaterialPersistent;
import com.denizenscript.denizen.objects.properties.material.MaterialSlab;
import com.denizenscript.denizen.objects.properties.material.MaterialSnowable;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchable;
import com.denizenscript.denizen.objects.properties.material.MaterialWaterlogged;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.blocks.ModernBlockData;
import com.denizenscript.denizen.utilities.blocks.OldMaterialsHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.material.MaterialData;

public class MaterialTag
implements ObjectTag,
Adjustable {
    private String forcedIdentity = null;
    private String forcedIdentityLow = null;
    public static TagContext noDebugContext = new BukkitTagContext(null, null, null, false, null);
    private Material material;
    private Byte data = 0;
    private ModernBlockData modernData;
    String prefix = "material";
    public static ObjectTagProcessor<MaterialTag> tagProcessor = new ObjectTagProcessor();

    public MaterialTag forceIdentifyAs(String string) {
        this.forcedIdentity = string;
        this.forcedIdentityLow = CoreUtilities.toLowerCase(string);
        return this;
    }

    public static MaterialTag valueOf(String string) {
        return MaterialTag.valueOf(string, null);
    }

    @Fetchable(value="m")
    public static MaterialTag valueOf(String string, TagContext context) {
        int matid;
        MaterialTag mat;
        Material m;
        String dataStr;
        if (ObjectFetcher.isObjectWithProperties(string)) {
            return ObjectFetcher.getObjectFrom(MaterialTag.class, string, context);
        }
        if ((string = string.toUpperCase()).startsWith("M@")) {
            string = string.substring("M@".length());
        }
        if (string.equals("RANDOM")) {
            return OldMaterialsHelper.getMaterialFrom(Material.values()[CoreUtilities.getRandom().nextInt(Material.values().length)]);
        }
        int index = string.indexOf(44);
        if (index < 0) {
            index = string.indexOf(58);
        }
        int data = 0;
        if (index >= 0 && ArgumentHelper.matchesInteger(dataStr = string.substring(index + 1))) {
            data = Integer.parseInt(dataStr);
            string = string.substring(0, index);
        }
        if ((m = Material.getMaterial((String)string)) == null && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && (m = Material.getMaterial((String)string, (boolean)true)) != null) {
            m = Bukkit.getUnsafe().fromLegacy(m);
            if (context == null || context.debug) {
                Debug.log("'" + string + "' is a legacy (pre-1.13) material name. It is now '" + m.name() + "'.");
            }
        }
        if (m != null) {
            if (index >= 0) {
                if (context != noDebugContext && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    Deprecations.materialIdsSuggestProperties.warn(context);
                }
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                return new MaterialTag(m);
            }
            return OldMaterialsHelper.getMaterialFrom(m, data);
        }
        if (OldMaterialsHelper.all_dMaterials != null && (mat = OldMaterialsHelper.all_dMaterials.get(string)) != null) {
            if (index >= 0 && context != noDebugContext && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Deprecations.materialIdsSuggestProperties.warn(context);
            }
            if (data == 0) {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    return new MaterialTag(mat.material);
                }
                return mat;
            }
            return OldMaterialsHelper.getMaterialFrom(mat.material, data);
        }
        if (ArgumentHelper.matchesInteger(string) && (matid = Integer.parseInt(string)) != 0) {
            if (context != noDebugContext) {
                Deprecations.materialIdsSuggestNames.warn(context);
            }
            if ((m = OldMaterialsHelper.getLegacyMaterial(matid)) != null) {
                return OldMaterialsHelper.getMaterialFrom(m, data);
            }
        }
        return null;
    }

    public static MaterialTag quickOfNamed(String string) {
        Material m;
        String dataStr;
        int index = (string = string.toUpperCase()).indexOf(44);
        if (index < 0) {
            index = string.indexOf(58);
        }
        int data = 0;
        if (index >= 0 && ArgumentHelper.matchesInteger(dataStr = string.substring(index + 1))) {
            data = Integer.parseInt(dataStr);
            string = string.substring(0, index);
        }
        if ((m = Material.getMaterial((String)string)) != null) {
            return OldMaterialsHelper.getMaterialFrom(m, data);
        }
        MaterialTag mat = OldMaterialsHelper.all_dMaterials.get(string);
        if (mat != null) {
            if (data == 0) {
                return mat;
            }
            return OldMaterialsHelper.getMaterialFrom(mat.material, data);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return MaterialTag.valueOf(arg, noDebugContext) != null;
    }

    @Override
    public ObjectTag duplicate() {
        if (this.hasModernData()) {
            return new MaterialTag(this.getModernData());
        }
        return new MaterialTag(this.getMaterial());
    }

    public boolean equals(Object object) {
        if (object instanceof MaterialTag) {
            return this.getMaterial() == ((MaterialTag)object).getMaterial() && this.getData((byte)0) == ((MaterialTag)object).getData((byte)0);
        }
        MaterialTag parsed = MaterialTag.valueOf(object.toString());
        return this.equals(parsed);
    }

    public boolean matchesBlock(Block b) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            return this.getMaterial() == b.getType();
        }
        return this.matchesMaterialData(b.getType().getNewData(b.getData()));
    }

    public MaterialTag(Material material, int data) {
        this.material = material;
        this.data = data < 0 ? null : Byte.valueOf((byte)data);
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && material.isBlock()) {
            this.modernData = new ModernBlockData(material);
        }
    }

    public MaterialTag(Material material) {
        this(material, 0);
    }

    public MaterialTag(BlockState state) {
        this.material = state.getType();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            this.modernData = new ModernBlockData(state);
        } else {
            this.data = state.getRawData();
        }
    }

    public MaterialTag(BlockData block) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            this.modernData = block.modern();
            this.material = this.modernData.getMaterial();
        } else {
            this.material = block.getMaterial();
            this.data = block.getData();
        }
    }

    public MaterialTag(Block block) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            this.modernData = new ModernBlockData(block);
            this.material = this.modernData.getMaterial();
        } else {
            this.material = block.getType();
            this.data = block.getData();
        }
    }

    public MaterialTag(ModernBlockData data) {
        this.modernData = data;
        this.material = data.getMaterial();
    }

    public boolean hasModernData() {
        return this.modernData != null;
    }

    public ModernBlockData getModernData() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            return this.modernData;
        }
        throw new IllegalStateException("Modern block data handler is not available prior to MC 1.13.");
    }

    public void setModernData(ModernBlockData data) {
        this.modernData = data;
    }

    public Material getMaterial() {
        return this.material;
    }

    public BlockData getNmsBlockData() {
        if (this.modernData != null) {
            return NMSHandler.getBlockHelper().getBlockData(this.modernData);
        }
        return NMSHandler.getBlockHelper().getBlockData(this.getMaterial(), this.getData((byte)0));
    }

    public String name() {
        return this.material.name();
    }

    public byte getData(byte fallback) {
        if (this.data == null) {
            return fallback;
        }
        return this.data;
    }

    public Byte getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean matchesMaterialData(MaterialData data) {
        if (this.hasData()) {
            return this.material == data.getItemType() && this.data.byteValue() == data.getData();
        }
        return this.material == data.getItemType();
    }

    public MaterialData getMaterialData() {
        return new MaterialData(this.material, this.data != null ? this.data : (byte)0);
    }

    public boolean isStructure() {
        if (this.material == Material.CHORUS_PLANT) {
            return true;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && (this.material == Material.RED_MUSHROOM_BLOCK || this.material == Material.BROWN_MUSHROOM_BLOCK)) {
            return true;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12)) {
            if (this.material == Material.RED_MUSHROOM || this.material == Material.BROWN_MUSHROOM) {
                return true;
            }
            String name = this.material.name();
            return name.equals("SAPLING") || name.equals("HUGE_MUSHROOM_1") || name.equals("HUGE_MUSHROOM_2");
        }
        return false;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Material";
    }

    @Override
    public String identify() {
        return "m@" + this.identifyNoIdentifier();
    }

    public String identifyFull() {
        return "m@" + this.identifyFullNoIdentifier();
    }

    @Override
    public String identifySimple() {
        return "m@" + this.identifySimpleNoIdentifier();
    }

    public String identifyNoPropertiesNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    public String identifyNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name()) + PropertyParser.getPropertiesString(this);
    }

    public String identifySimpleNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    public String identifyFullNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow + (this.getData() != null ? "," + this.getData() : "");
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name()) + PropertyParser.getPropertiesString(this);
    }

    public String toString() {
        return this.identify();
    }

    public String realName() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        MaterialTag.registerTag("id", (attribute, object) -> {
            Deprecations.materialIdsSuggestNames.warn(attribute.getScriptEntry());
            return new ElementTag(object.material.getId());
        }, new String[0]);
        MaterialTag.registerTag("data", (attribute, object) -> {
            if (attribute.context == null || attribute.context.debug) {
                Deprecations.materialIdsSuggestProperties.warn(attribute.getScriptEntry());
            }
            return new ElementTag(object.getData());
        }, new String[0]);
        MaterialTag.registerTag("is_ageable", (attribute, object) -> new ElementTag(MaterialAge.describes(object)), "is_plant");
        MaterialTag.registerTag("is_campfire", (attribute, object) -> new ElementTag(MaterialCampfire.describes(object)), new String[0]);
        MaterialTag.registerTag("is_directional", (attribute, object) -> new ElementTag(MaterialDirectional.describes(object)), new String[0]);
        MaterialTag.registerTag("has_multiple_faces", (attribute, object) -> new ElementTag(MaterialFaces.describes(object)), new String[0]);
        MaterialTag.registerTag("can_drag", (attribute, object) -> new ElementTag(MaterialDrags.describes(object)), new String[0]);
        MaterialTag.registerTag("is_bisected", (attribute, object) -> new ElementTag(MaterialHalf.describes(object)), new String[0]);
        MaterialTag.registerTag("is_bamboo", (attribute, object) -> new ElementTag(MaterialLeafSize.describes(object)), new String[0]);
        MaterialTag.registerTag("is_levelable", (attribute, object) -> new ElementTag(MaterialLevel.describes(object)), new String[0]);
        MaterialTag.registerTag("is_lightable", (attribute, object) -> new ElementTag(MaterialLightable.describes(object)), new String[0]);
        MaterialTag.registerTag("is_leaves", (attribute, object) -> new ElementTag(MaterialPersistent.describes(object)), new String[0]);
        MaterialTag.registerTag("has_count", (attribute, object) -> new ElementTag(MaterialCount.describes(object)), "is_pickle");
        MaterialTag.registerTag("is_slab", (attribute, object) -> new ElementTag(MaterialSlab.describes(object)), new String[0]);
        MaterialTag.registerTag("is_snowable", (attribute, object) -> new ElementTag(MaterialSnowable.describes(object)), new String[0]);
        MaterialTag.registerTag("is_switch", (attribute, object) -> new ElementTag(MaterialSnowable.describes(object)), new String[0]);
        MaterialTag.registerTag("is_waterloggable", (attribute, object) -> new ElementTag(MaterialWaterlogged.describes(object)), new String[0]);
        MaterialTag.registerTag("has_gravity", (attribute, object) -> new ElementTag(object.material.hasGravity()), new String[0]);
        MaterialTag.registerTag("is_block", (attribute, object) -> new ElementTag(object.material.isBlock()), new String[0]);
        MaterialTag.registerTag("is_item", (attribute, object) -> new ElementTag(object.material.isItem()), new String[0]);
        MaterialTag.registerTag("is_burnable", (attribute, object) -> new ElementTag(object.material.isBurnable()), new String[0]);
        MaterialTag.registerTag("is_edible", (attribute, object) -> new ElementTag(object.material.isEdible()), new String[0]);
        MaterialTag.registerTag("is_flammable", (attribute, object) -> new ElementTag(object.material.isFlammable()), new String[0]);
        MaterialTag.registerTag("is_fuel", (attribute, object) -> new ElementTag(object.material.isFuel()), new String[0]);
        MaterialTag.registerTag("fuel_burn_time", (attribute, object) -> {
            Integer ticks = NMSHandler.getItemHelper().burnTime(object.getMaterial());
            if (ticks != null) {
                return new DurationTag(ticks.longValue());
            }
            return null;
        }, new String[0]);
        MaterialTag.registerTag("is_occluding", (attribute, object) -> new ElementTag(object.material.isOccluding()), new String[0]);
        MaterialTag.registerTag("is_record", (attribute, object) -> new ElementTag(object.material.isRecord()), new String[0]);
        MaterialTag.registerTag("is_solid", (attribute, object) -> new ElementTag(object.material.isSolid()), new String[0]);
        MaterialTag.registerTag("is_switchable", (attribute, object) -> new ElementTag(MaterialSwitchable.describes(object)), new String[0]);
        MaterialTag.registerTag("is_transparent", (attribute, object) -> new ElementTag(object.material.isTransparent()), new String[0]);
        MaterialTag.registerTag("max_durability", (attribute, object) -> new ElementTag(object.material.getMaxDurability()), new String[0]);
        MaterialTag.registerTag("block_resistance", (attribute, object) -> {
            if (!NMSHandler.getBlockHelper().hasBlock(object.getMaterial())) {
                Debug.echoError("Provided material does not have a placeable block.");
                return null;
            }
            return new ElementTag(NMSHandler.getBlockHelper().getBlockResistance(object.getMaterial()));
        }, new String[0]);
        MaterialTag.registerTag("hardness", (attribute, object) -> {
            if (!object.getMaterial().isBlock()) {
                Debug.echoError("Provided material does not have a placeable block.");
                return null;
            }
            return new ElementTag(object.getMaterial().getHardness());
        }, new String[0]);
        MaterialTag.registerTag("max_stack_size", (attribute, object) -> new ElementTag(object.material.getMaxStackSize()), new String[0]);
        MaterialTag.registerTag("is_made_of", (attribute, object) -> {
            MaterialTag compared = MaterialTag.valueOf(attribute.getContext(1));
            return new ElementTag(compared != null && object.material == compared.getMaterial());
        }, new String[0]);
        MaterialTag.registerTag("bukkit_enum", (attribute, object) -> new ElementTag(object.material.name()), new String[0]);
        MaterialTag.registerTag("translated_name", (attribute, object) -> {
            String key = object.material.getKey().getKey();
            key = key.replace("wall_banner", "banner");
            String type = object.material.isBlock() ? "block" : "item";
            return new ElementTag("\u00a7[translate=" + type + ".minecraft." + key + "]");
        }, new String[0]);
        MaterialTag.registerTag("name", (attribute, object) -> new ElementTag(object.forcedIdentity != null ? object.forcedIdentityLow : CoreUtilities.toLowerCase(object.material.name())), new String[0]);
        MaterialTag.registerTag("full", (attribute, object) -> {
            if (object.hasData()) {
                return new ElementTag(object.identifyFull());
            }
            return new ElementTag(object.identify());
        }, new String[0]);
        MaterialTag.registerTag("item", (attribute, object) -> {
            ItemTag item = new ItemTag((MaterialTag)object, 1);
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && item.getItemStack().hasItemMeta() && item.getItemStack().getItemMeta() instanceof BlockStateMeta) {
                ((BlockStateMeta)item.getItemStack().getItemMeta()).setBlockState(object.modernData.getBlockState());
            }
            return item;
        }, new String[0]);
        MaterialTag.registerTag("piston_reaction", (attribute, object) -> {
            String res = NMSHandler.getBlockHelper().getPushReaction(object.material);
            if (res == null) {
                return null;
            }
            return new ElementTag(res);
        }, new String[0]);
        MaterialTag.registerTag("block_strength", (attribute, object) -> {
            float res = NMSHandler.getBlockHelper().getBlockStength(object.material);
            return new ElementTag(res);
        }, new String[0]);
        MaterialTag.registerTag("type", (attribute, object) -> new ElementTag("Material"), new String[0]);
        MaterialTag.registerTag("with", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("MaterialTag.with[...] tag must have an input mechanism list.");
            }
            MaterialTag mat = new MaterialTag(object.getModernData().clone());
            List<String> properties = ObjectFetcher.separateProperties("[" + attribute.getContext(1) + "]");
            for (int i = 1; i < properties.size(); ++i) {
                List<String> data = CoreUtilities.split(properties.get(i), '=', 2);
                if (data.size() != 2) {
                    Debug.echoError("Invalid property string '" + properties.get(i) + "'!");
                    continue;
                }
                mat.safeApplyProperty(new Mechanism(new ElementTag(data.get(0)), new ElementTag(data.get(1)), attribute.context));
            }
            return mat;
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<MaterialTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (!mechanism.isProperty && mechanism.matches("block_resistance") && mechanism.requireFloat() && !NMSHandler.getBlockHelper().setBlockResistance(this.material, mechanism.getValue().asFloat())) {
            Debug.echoError("Provided material does not have a placeable block.");
        }
        if (!mechanism.isProperty && mechanism.matches("block_strength") && mechanism.requireFloat()) {
            if (!this.material.isBlock()) {
                Debug.echoError("'block_strength' mechanism is only valid for block types.");
            }
            NMSHandler.getBlockHelper().setBlockStrength(this.material, mechanism.getValue().asFloat());
        }
        if (!mechanism.isProperty && mechanism.matches("piston_reaction")) {
            if (!this.material.isBlock()) {
                Debug.echoError("'piston_reaction' mechanism is only valid for block types.");
            }
            NMSHandler.getBlockHelper().setPushReaction(this.material, mechanism.getValue().asString().toUpperCase());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

