/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.server;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.command.scripted.DenizenCommandSender;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

public class ExecuteCommand
extends AbstractCommand {
    public DenizenCommandSender dcs = new DenizenCommandSender();
    public static final List<UUID> silencedPlayers = new ArrayList<UUID>();

    public ExecuteCommand() {
        this.setName("execute");
        this.setSyntax("execute [as_player/as_op/as_npc/as_server] [<Bukkit-command>] (silent)");
        this.setRequiredArguments(2, 3);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matches("asplayer", "as_player") && !scriptEntry.hasObject("type")) {
                if (!Utilities.entryHasPlayer(scriptEntry)) {
                    throw new InvalidArgumentsException("Must have a Player link when using AS_PLAYER.");
                }
                scriptEntry.addObject("type", new ElementTag("AS_PLAYER"));
                continue;
            }
            if (arg.matches("asop", "as_op") && !scriptEntry.hasObject("type")) {
                if (!Utilities.entryHasPlayer(scriptEntry)) {
                    throw new InvalidArgumentsException("Must have a Player link when using AS_OP.");
                }
                scriptEntry.addObject("type", new ElementTag("AS_OP"));
                continue;
            }
            if (arg.matches("asnpc", "as_npc") && !scriptEntry.hasObject("type")) {
                if (!Utilities.entryHasNPC(scriptEntry)) {
                    throw new InvalidArgumentsException("Must have a NPC link when using AS_NPC.");
                }
                scriptEntry.addObject("type", new ElementTag("AS_NPC"));
                continue;
            }
            if (arg.matches("asserver", "as_server") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", new ElementTag("AS_SERVER"));
                continue;
            }
            if (!scriptEntry.hasObject("silent") && arg.matches("silent")) {
                scriptEntry.addObject("silent", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("command")) {
                scriptEntry.addObject("command", new ElementTag(arg.raw_value));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("type")) {
            throw new InvalidArgumentsException("Missing execution type!");
        }
        if (!scriptEntry.hasObject("command")) {
            throw new InvalidArgumentsException("Missing command text!");
        }
        scriptEntry.defaultObject("silent", new ElementTag("false"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag cmd = scriptEntry.getElement("command");
        ElementTag type = scriptEntry.getElement("type");
        ElementTag silent = scriptEntry.getElement("silent");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), type.debug() + cmd.debug() + silent.debug());
        }
        String command = cmd.asString();
        switch (Type.valueOf(type.asString())) {
            case AS_PLAYER: {
                try {
                    PlayerCommandPreprocessEvent pcpe = new PlayerCommandPreprocessEvent(Utilities.getEntryPlayer(scriptEntry).getPlayerEntity(), "/" + command);
                    Bukkit.getPluginManager().callEvent((Event)pcpe);
                    if (pcpe.isCancelled()) break;
                    boolean silentBool = silent.asBoolean();
                    Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
                    if (silentBool) {
                        silencedPlayers.add(player.getUniqueId());
                    }
                    player.performCommand(pcpe.getMessage().startsWith("/") ? pcpe.getMessage().substring(1) : pcpe.getMessage());
                    if (!silentBool) break;
                    silencedPlayers.remove(player.getUniqueId());
                }
                catch (Throwable e) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Exception while executing command as player.");
                    Debug.echoError(scriptEntry.getResidingQueue(), e);
                }
                break;
            }
            case AS_OP: {
                if (CoreUtilities.toLowerCase(command).equals("stop")) {
                    Debug.echoError("Please use as_server to execute 'stop'.");
                    return;
                }
                Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
                PlayerHelper playerHelper = NMSHandler.getPlayerHelper();
                boolean isOp = player.isOp();
                if (!isOp) {
                    playerHelper.setTemporaryOp(player, true);
                }
                try {
                    PlayerCommandPreprocessEvent pcpe = new PlayerCommandPreprocessEvent(player, "/" + command);
                    Bukkit.getPluginManager().callEvent((Event)pcpe);
                    if (!pcpe.isCancelled()) {
                        boolean silentBool = silent.asBoolean();
                        if (silentBool) {
                            silencedPlayers.add(player.getUniqueId());
                        }
                        player.performCommand(pcpe.getMessage().startsWith("/") ? pcpe.getMessage().substring(1) : pcpe.getMessage());
                        if (silentBool) {
                            silencedPlayers.remove(player.getUniqueId());
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Exception while executing command as OP.");
                    Debug.echoError(scriptEntry.getResidingQueue(), e);
                }
                if (isOp) break;
                playerHelper.setTemporaryOp(player, false);
                break;
            }
            case AS_NPC: {
                if (!Utilities.getEntryNPC(scriptEntry).isSpawned()) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Cannot EXECUTE AS_NPC unless the NPC is Spawned.");
                    return;
                }
                if (Utilities.getEntryNPC(scriptEntry).getEntity().getType() != EntityType.PLAYER) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Cannot EXECUTE AS_NPC unless the NPC is Player-Type.");
                    return;
                }
                Utilities.getEntryNPC(scriptEntry).getEntity().setOp(true);
                try {
                    ((Player)Utilities.getEntryNPC(scriptEntry).getEntity()).performCommand(command);
                }
                catch (Throwable e) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Exception while executing command as NPC-OP.");
                    Debug.echoError(scriptEntry.getResidingQueue(), e);
                }
                Utilities.getEntryNPC(scriptEntry).getEntity().setOp(false);
                break;
            }
            case AS_SERVER: {
                this.dcs.clearOutput();
                this.dcs.silent = silent.asBoolean();
                ServerCommandEvent sce = new ServerCommandEvent((CommandSender)this.dcs, command);
                Bukkit.getPluginManager().callEvent((Event)sce);
                DenizenAPI.getCurrentInstance().getServer().dispatchCommand((CommandSender)this.dcs, sce.getCommand());
                scriptEntry.addObject("output", new ListTag((List<String>)this.dcs.getOutput()));
            }
        }
    }

    static enum Type {
        AS_SERVER,
        AS_NPC,
        AS_PLAYER,
        AS_OP;

    }
}

