/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.depends;

import com.denizenscript.denizen.utilities.DenizenAPI;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import net.citizensnpcs.Citizens;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Depends {
    public static Citizens citizens = null;
    public static Economy economy = null;
    public static Permission permissions = null;
    public static Chat chat = null;
    public static Plugin vault = null;

    public static void initialize() {
        vault = Bukkit.getServer().getPluginManager().getPlugin("Vault");
        Depends.setupBungee();
        Depends.setupEconomy();
        Depends.setupPermissions();
        Depends.setupChat();
        Depends.setupCitizens();
    }

    public static void setupBungee() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)DenizenAPI.getCurrentInstance(), "BungeeCord");
    }

    public static void bungeeSendPlayer(Player player, String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Connect");
        out.writeUTF(server);
        player.sendPluginMessage((Plugin)DenizenAPI.getCurrentInstance(), "BungeeCord", out.toByteArray());
    }

    public static boolean setupEconomy() {
        if (vault == null || !vault.isEnabled()) {
            return false;
        }
        try {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                return false;
            }
            economy = (Economy)rsp.getProvider();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return economy != null;
    }

    public static boolean setupChat() {
        if (vault == null || !vault.isEnabled()) {
            return false;
        }
        try {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
            chat = (Chat)rsp.getProvider();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chat != null;
    }

    public static boolean setupPermissions() {
        if (vault == null || !vault.isEnabled()) {
            return false;
        }
        try {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            permissions = (Permission)rsp.getProvider();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return permissions != null;
    }

    public static boolean setupCitizens() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("Citizens");
        if (plugin == null || !plugin.isEnabled()) {
            return false;
        }
        try {
            citizens = (Citizens)Bukkit.getServer().getPluginManager().getPlugin("Citizens");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return citizens != null;
    }
}

