/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.implementation;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.EconomyScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.DenizenImplementation;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.debugging.StrongWarning;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class DenizenCoreImplementation
implements DenizenImplementation {
    public static StrongWarning invalidPlayerArg = new StrongWarning("The 'player:' arg should not be used in commands like define/flag/yaml/... just input the player directly instead.");
    public static StrongWarning invalidNpcArg = new StrongWarning("The 'npc:' arg should not be used in commands like define/flag/yaml/... just input the npc directly instead.");
    public static HashSet<String> invalidPlayerArgCommands = new HashSet<String>(Arrays.asList("DEFINE", "FLAG", "YAML"));
    public static Thread tagThread = null;
    Boolean tTimeoutSil = null;
    public static ChatColor[] DEBUG_FRIENDLY_COLORS = new ChatColor[]{ChatColor.AQUA, ChatColor.BLUE, ChatColor.DARK_AQUA, ChatColor.DARK_BLUE, ChatColor.DARK_GREEN, ChatColor.DARK_PURPLE, ChatColor.GOLD, ChatColor.GRAY, ChatColor.GREEN, ChatColor.LIGHT_PURPLE, ChatColor.WHITE, ChatColor.YELLOW};

    @Override
    public File getScriptFolder() {
        File file = Settings.useDefaultScriptPath() ? new File(DenizenAPI.getCurrentInstance().getDataFolder() + File.separator + "scripts") : new File(Settings.getAlternateScriptPath().replace("/", File.separator));
        return file;
    }

    @Override
    public String getImplementationVersion() {
        return Denizen.versionTag;
    }

    @Override
    public void debugMessage(String message) {
        Debug.log(message);
    }

    @Override
    public void debugException(Throwable ex) {
        Debug.echoError(ex);
    }

    @Override
    public void debugError(String error) {
        Debug.echoError(error);
    }

    @Override
    public void debugError(ScriptQueue scriptQueue, String s) {
        Debug.echoError(scriptQueue, s);
    }

    @Override
    public void debugError(ScriptQueue scriptQueue, Throwable throwable) {
        Debug.echoError(scriptQueue, throwable);
    }

    @Override
    public void debugReport(Debuggable debuggable, String s, String s1) {
        Debug.report(debuggable, s, s1);
    }

    @Override
    public void debugApproval(String message) {
        Debug.echoApproval(message);
    }

    @Override
    public void debugEntry(Debuggable debuggable, String s) {
        Debug.echoDebug(debuggable, s);
    }

    @Override
    public void debugEntry(Debuggable debuggable, Debug.DebugElement debugElement, String s) {
        Debug.echoDebug(debuggable, debugElement, s);
    }

    @Override
    public void debugEntry(Debuggable debuggable, Debug.DebugElement debugElement) {
        Debug.echoDebug(debuggable, debugElement);
    }

    @Override
    public String getImplementationName() {
        return "Spigot";
    }

    @Override
    public void preScriptReload() {
        ItemScriptHelper.removeDenizenRecipes();
        CommandScriptHelper.removeDenizenCommands();
        if (Depends.vault != null) {
            EconomyScriptContainer.cleanup();
        }
    }

    @Override
    public void onScriptReload() {
        Depends.setupEconomy();
        Bukkit.getServer().getPluginManager().callEvent((Event)new ScriptReloadEvent());
    }

    @Override
    public boolean shouldDebug(Debuggable debug) {
        return Debug.shouldDebug(debug);
    }

    @Override
    public void debugQueueExecute(ScriptEntry entry, String queue, String execute) {
        Consumer<String> altDebug = entry.getResidingQueue().debugOutput;
        entry.getResidingQueue().debugOutput = null;
        Debug.echoDebug(entry, Debug.DebugElement.Header, ChatColor.LIGHT_PURPLE + "Queue '" + queue + ChatColor.LIGHT_PURPLE + "' Executing: " + ChatColor.WHITE + execute);
        entry.getResidingQueue().debugOutput = altDebug;
    }

    @Override
    public void debugTagFill(Debuggable entry, String tag, String result) {
        Debug.echoDebug(entry, ChatColor.DARK_GRAY + "Filled tag <" + ChatColor.WHITE + tag + ChatColor.DARK_GRAY + "> with '" + ChatColor.WHITE + result + ChatColor.DARK_GRAY + "'.");
    }

    @Override
    public String queueHeaderInfo(ScriptEntry scriptEntry) {
        BukkitScriptEntryData data = (BukkitScriptEntryData)scriptEntry.entryData;
        if (data.hasPlayer() && data.hasNPC()) {
            return " with player '" + data.getPlayer().getName() + "' and NPC '" + data.getNPC().getId() + "/" + data.getNPC().getName() + "'";
        }
        if (data.hasPlayer()) {
            return " with player '" + data.getPlayer().getName() + "'";
        }
        if (data.hasNPC()) {
            return " with NPC '" + data.getNPC().getId() + "/" + data.getNPC().getName() + "'";
        }
        return "";
    }

    @Override
    public boolean needsHandleArgPrefix(String prefix) {
        return prefix.equals("player") || prefix.equals("npc");
    }

    @Override
    public boolean handleCustomArgs(ScriptEntry scriptEntry, Argument arg, boolean if_ignore) {
        if (arg.matchesPrefix("player") && !if_ignore) {
            if (invalidPlayerArgCommands.contains(scriptEntry.getCommandName())) {
                invalidPlayerArg.warn(scriptEntry);
            }
            Debug.echoDebug((Debuggable)scriptEntry, "...replacing the linked player with " + arg.getValue());
            String value = TagManager.tag(arg.getValue(), scriptEntry.getContext());
            PlayerTag player = PlayerTag.valueOf(value);
            if (player == null || !player.isValid()) {
                Debug.echoError(scriptEntry.getResidingQueue(), value + " is an invalid player!");
            }
            ((BukkitScriptEntryData)scriptEntry.entryData).setPlayer(player);
            return true;
        }
        if (arg.matchesPrefix("npc") && !if_ignore) {
            if (invalidPlayerArgCommands.contains(scriptEntry.getCommandName())) {
                invalidNpcArg.warn(scriptEntry);
            }
            Debug.echoDebug((Debuggable)scriptEntry, "...replacing the linked NPC with " + arg.getValue());
            String value = TagManager.tag(arg.getValue(), scriptEntry.getContext());
            NPCTag npc = NPCTag.valueOf(value);
            if (npc == null || !npc.isValid()) {
                Debug.echoError(scriptEntry.getResidingQueue(), value + " is an invalid NPC!");
                return false;
            }
            ((BukkitScriptEntryData)scriptEntry.entryData).setNPC(npc);
            return true;
        }
        return false;
    }

    @Override
    public void refreshScriptContainers() {
        ItemScriptHelper.item_scripts.clear();
        ItemScriptHelper.item_scripts_by_hash_id.clear();
        InventoryScriptHelper.inventory_scripts.clear();
    }

    @Override
    public String scriptQueueSpeed() {
        return Settings.scriptQueueSpeed();
    }

    @Override
    public ListTag valueOfFlagListTag(String string) {
        FlagManager.Flag flag = DenizenAPI.getCurrentInstance().getFlag(string);
        if (flag == null) {
            return null;
        }
        return new ListTag(flag.toString(), true, flag.values());
    }

    @Override
    public boolean matchesFlagListTag(String arg) {
        boolean flag = false;
        if (arg.startsWith("fl")) {
            if (arg.indexOf(91) == 2) {
                int cb = arg.indexOf(93);
                if (cb > 4 && arg.indexOf(64) == cb + 1) {
                    String owner = arg.substring(3, cb);
                    flag = arg.substring(cb + 2).length() > 0 && (PlayerTag.matches(owner) || Depends.citizens != null && NPCTag.matches(owner));
                }
            } else if (arg.indexOf(64) == 2) {
                flag = arg.substring(3).length() > 0;
            }
        }
        return flag;
    }

    @Override
    public TagContext getTagContext(ScriptContainer container) {
        return new BukkitTagContext(container);
    }

    @Override
    public TagContext getTagContext(ScriptEntry scriptEntry) {
        return new BukkitTagContext(scriptEntry);
    }

    @Override
    public ScriptEntryData getEmptyScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public int getTagTimeout() {
        if (!Settings.tagTimeoutUnsafe()) {
            return 0;
        }
        return Settings.tagTimeout();
    }

    @Override
    public boolean allowConsoleRedirection() {
        return Settings.allowConsoleRedirection();
    }

    @Override
    public String cleanseLogString(String input) {
        return DenizenCoreImplementation.cleanseLog(input);
    }

    public static String cleanseLog(String input) {
        String esc = String.valueOf('\u001b');
        String repc = String.valueOf('\u00a7');
        if (input.contains(esc)) {
            input = StringUtils.replace((String)input, (String)(esc + "[0;30;22m"), (String)(repc + "0"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;34;22m"), (String)(repc + "1"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;32;22m"), (String)(repc + "2"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;36;22m"), (String)(repc + "3"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;31;22m"), (String)(repc + "4"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;35;22m"), (String)(repc + "5"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;33;22m"), (String)(repc + "6"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;37;22m"), (String)(repc + "7"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;30;1m"), (String)(repc + "8"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;34;1m"), (String)(repc + "9"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;32;1m"), (String)(repc + "a"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;36;1m"), (String)(repc + "b"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;31;1m"), (String)(repc + "c"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;35;1m"), (String)(repc + "d"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;33;1m"), (String)(repc + "e"));
            input = StringUtils.replace((String)input, (String)(esc + "[0;37;1m"), (String)(repc + "f"));
            input = StringUtils.replace((String)input, (String)(esc + "[5m"), (String)(repc + "k"));
            input = StringUtils.replace((String)input, (String)(esc + "[21m"), (String)(repc + "l"));
            input = StringUtils.replace((String)input, (String)(esc + "[9m"), (String)(repc + "m"));
            input = StringUtils.replace((String)input, (String)(esc + "[4m"), (String)(repc + "n"));
            input = StringUtils.replace((String)input, (String)(esc + "[3m"), (String)(repc + "o"));
            input = StringUtils.replace((String)input, (String)(esc + "[m"), (String)(repc + "r"));
        }
        return input;
    }

    @Override
    public boolean matchesType(String comparable, String comparedto) {
        boolean outcome = false;
        if (comparedto.equalsIgnoreCase("location")) {
            outcome = LocationTag.matches(comparable);
        } else if (comparedto.equalsIgnoreCase("material")) {
            outcome = MaterialTag.matches(comparable);
        } else if (comparedto.equalsIgnoreCase("materiallist")) {
            outcome = ListTag.valueOf(comparable, CoreUtilities.basicContext).containsObjectsFrom(MaterialTag.class);
        } else if (comparedto.equalsIgnoreCase("entity")) {
            outcome = EntityTag.matches(comparable);
        } else if (comparedto.equalsIgnoreCase("spawnedentity")) {
            outcome = EntityTag.matches(comparable) && EntityTag.valueOf(comparable).isSpawned();
        } else if (comparedto.equalsIgnoreCase("npc")) {
            outcome = NPCTag.matches(comparable);
        } else if (comparedto.equalsIgnoreCase("player")) {
            outcome = PlayerTag.matches(comparable);
        } else if (comparedto.equalsIgnoreCase("offlineplayer")) {
            outcome = PlayerTag.valueOf(comparable) != null && !PlayerTag.valueOf(comparable).isOnline();
        } else if (comparedto.equalsIgnoreCase("onlineplayer")) {
            outcome = PlayerTag.valueOf(comparable) != null && PlayerTag.valueOf(comparable).isOnline();
        } else if (comparedto.equalsIgnoreCase("item")) {
            outcome = ItemTag.matches(comparable);
        } else if (comparedto.equalsIgnoreCase("cuboid")) {
            outcome = CuboidTag.matches(comparable);
        } else if (comparedto.equalsIgnoreCase("trade")) {
            outcome = TradeTag.matches(comparable);
        } else {
            Debug.echoError("Invalid 'matches' type '" + comparedto + "'!");
        }
        return outcome;
    }

    @Override
    public boolean allowedToWebget() {
        return Settings.allowWebget();
    }

    public static boolean isSafeThread() {
        return Bukkit.isPrimaryThread() || Thread.currentThread().equals(tagThread);
    }

    @Override
    public void preTagExecute() {
        try {
            NMSHandler.getInstance().disableAsyncCatcher();
            tagThread = Thread.currentThread();
        }
        catch (Throwable e) {
            Debug.echoError("Running not-Spigot?!");
        }
    }

    @Override
    public void postTagExecute() {
        try {
            NMSHandler.getInstance().undisableAsyncCatcher();
            tagThread = null;
        }
        catch (Throwable e) {
            Debug.echoError("Running not-Spigot?!");
        }
    }

    @Override
    public boolean tagTimeoutWhenSilent() {
        if (this.tTimeoutSil == null) {
            this.tTimeoutSil = Settings.tagTimeoutSilent();
        }
        return this.tTimeoutSil;
    }

    @Override
    public boolean getDefaultDebugMode() {
        return Settings.defaultDebugMode();
    }

    @Override
    public boolean canWriteToFile(File f) {
        return Utilities.canWriteToFile(f);
    }

    @Override
    public String getRandomColor() {
        return DEBUG_FRIENDLY_COLORS[CoreUtilities.getRandom().nextInt(DEBUG_FRIENDLY_COLORS.length)].toString();
    }

    @Override
    public int whileMaxLoops() {
        return Settings.whileMaxLoops();
    }

    @Override
    public boolean allowLogging() {
        return Settings.allowLogging();
    }

    @Override
    public boolean canReadFile(File f) {
        return Utilities.canReadFile(f);
    }

    @Override
    public boolean allowFileCopy() {
        return Settings.allowFilecopy();
    }

    @Override
    public File getDataFolder() {
        return DenizenAPI.getCurrentInstance().getDataFolder();
    }

    @Override
    public boolean allowStrangeYAMLSaves() {
        return Settings.allowStrangeYAMLSaves();
    }
}

