/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchable;
import com.denizenscript.denizen.scripts.commands.world.AdjustBlockCommand;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<Location, Integer> taskMap = new HashMap<Location, Integer>(32);

    public SwitchCommand() {
        this.setName("switch");
        this.setSyntax("switch [<location>|...] (state:[{toggle}/on/off]) (duration:<value>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Notable note : NotableManager.notesByType.get(LocationTag.class)) {
            addOne.accept(NotableManager.getSavedId(note));
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("locations", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(SwitchState.values())) {
                scriptEntry.addObject("switchstate", new ElementTag(arg.getValue().toUpperCase()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("locations")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(0));
        scriptEntry.defaultObject("switchstate", new ElementTag("TOGGLE"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ListTag interactLocations = (ListTag)scriptEntry.getObjectTag("locations");
        long duration = ((DurationTag)scriptEntry.getObject("duration")).getTicks();
        SwitchState switchState = SwitchState.valueOf(scriptEntry.getElement("switchstate").asString());
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), interactLocations.debug() + ArgumentHelper.debugObj("duration", duration + "t") + ArgumentHelper.debugObj("switchstate", switchState.name()));
        }
        for (LocationTag interactLocation : interactLocations.filter(LocationTag.class, scriptEntry)) {
            this.switchBlock(scriptEntry, interactLocation, switchState);
            if (duration <= 0L) continue;
            if (this.taskMap.containsKey(interactLocation)) {
                try {
                    Bukkit.getScheduler().cancelTask(this.taskMap.get(interactLocation).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Setting delayed task 'SWITCH' for " + interactLocation.identify());
            this.taskMap.put(interactLocation, Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> this.switchBlock(scriptEntry, interactLocation, SwitchState.TOGGLE), duration));
        }
    }

    public static boolean switchState(Block b) {
        MaterialSwitchable switchable = MaterialSwitchable.getFrom(new MaterialTag(b.getBlockData()));
        if (switchable == null) {
            return false;
        }
        return switchable.getState();
    }

    public void switchBlock(ScriptEntry scriptEntry, Location interactLocation, SwitchState switchState) {
        MaterialSwitchable switchable = MaterialSwitchable.getFrom(new MaterialTag(interactLocation.getBlock().getBlockData()));
        if (switchable == null) {
            return;
        }
        boolean currentState = switchable.getState();
        if (switchState.equals((Object)SwitchState.ON) && !currentState || switchState.equals((Object)SwitchState.OFF) && currentState || switchState.equals((Object)SwitchState.TOGGLE)) {
            switchable.setState(!currentState);
            interactLocation.getBlock().setBlockData(switchable.material.getModernData());
            if (switchable.material.getModernData() instanceof Bisected) {
                Location other = interactLocation.clone();
                other = ((Bisected)switchable.material.getModernData()).getHalf() == Bisected.Half.TOP ? other.add(0.0, -1.0, 0.0) : other.add(0.0, 1.0, 0.0);
                MaterialSwitchable switchable2 = MaterialSwitchable.getFrom(new MaterialTag(other.getBlock().getBlockData()));
                switchable2.setState(!currentState);
                other.getBlock().setBlockData(switchable2.material.getModernData());
                AdjustBlockCommand.applyPhysicsAt(other);
            }
            AdjustBlockCommand.applyPhysicsAt(interactLocation);
            Debug.echoDebug((Debuggable)scriptEntry, "Switched " + interactLocation.getBlock().getType().toString() + "! Current state now: " + (SwitchCommand.switchState(interactLocation.getBlock()) ? "ON" : "OFF"));
        }
    }

    private static enum SwitchState {
        ON,
        OFF,
        TOGGLE;

    }
}

