/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ReflectionHelper {
    private static final Map<Class, Map<String, Field>> cachedFields = new HashMap<Class, Map<String, Field>>();

    public static <T> T getFieldValue(Class clazz, String fieldName, Object object) {
        Map<Object, Object> cache;
        if (cachedFields.containsKey(clazz)) {
            cache = cachedFields.get(clazz);
        } else {
            cache = new HashMap();
            cachedFields.put(clazz, cache);
        }
        try {
            Field field = cache.containsKey(fieldName) ? (Field)cache.get(fieldName) : clazz.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            cache.put(fieldName, field);
            return (T)field.get(object);
        }
        catch (Exception e) {
            dB.echoError((Throwable)e);
            return null;
        }
    }

    public static void setFieldValue(Class clazz, String fieldName, Object object, Object value) {
        Map<Object, Object> cache;
        if (cachedFields.containsKey(clazz)) {
            cache = cachedFields.get(clazz);
        } else {
            cache = new HashMap();
            cachedFields.put(clazz, cache);
        }
        try {
            Field field = cache.containsKey(fieldName) ? (Field)cache.get(fieldName) : clazz.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            ReflectionHelper.fixFinal(field);
            cache.put(fieldName, field);
            field.set(object, value);
        }
        catch (Exception e) {
            dB.echoError((Throwable)e);
        }
    }

    public static void fixFinal(Field field) {
        int mod = field.getModifiers();
        if (Modifier.isFinal(mod)) {
            ReflectionHelper.setFieldValue(Field.class, "modifiers", field, mod & 0xFFFFFFEF);
        }
    }

    public static Map<String, Field> getFields(Class clazz) {
        if (cachedFields.containsKey(clazz)) {
            return cachedFields.get(clazz);
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            fields.put(field.getName(), field);
        }
        cachedFields.put(clazz, fields);
        return fields;
    }
}

