/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.impl.packets;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.nms.interfaces.packets.PacketOutTradeList;
import net.aufdemrand.denizen.nms.util.TradeOffer;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.minecraft.server.v1_12_R1.PacketDataSerializer;
import net.minecraft.server.v1_12_R1.PacketPlayOutCustomPayload;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class PacketOutTradeList_v1_12_R1
implements PacketOutTradeList {
    private PacketPlayOutCustomPayload internal;
    private int container;
    private List<TradeOffer> tradeOffers;

    public PacketOutTradeList_v1_12_R1(PacketPlayOutCustomPayload internal, PacketDataSerializer serializer) {
        this.internal = internal;
        try {
            this.container = serializer.readInt();
            this.tradeOffers = new ArrayList<TradeOffer>();
            byte tradeCount = serializer.readByte();
            for (byte i = 0; i < tradeCount; i = (byte)(i + 1)) {
                ItemStack firstCost = CraftItemStack.asBukkitCopy((net.minecraft.server.v1_12_R1.ItemStack)serializer.k());
                ItemStack product = CraftItemStack.asBukkitCopy((net.minecraft.server.v1_12_R1.ItemStack)serializer.k());
                boolean hasSecondCost = serializer.readBoolean();
                ItemStack secondCost = hasSecondCost ? CraftItemStack.asBukkitCopy((net.minecraft.server.v1_12_R1.ItemStack)serializer.k()) : null;
                boolean usedMaxTimes = serializer.readBoolean();
                int currentUses = serializer.readInt();
                int maxUses = serializer.readInt();
                this.tradeOffers.add(new TradeOffer(product, firstCost, secondCost, usedMaxTimes, currentUses, maxUses));
            }
        }
        catch (Exception e) {
            dB.echoError((Throwable)e);
        }
    }

    public List<TradeOffer> getTradeOffers() {
        return this.tradeOffers;
    }

    public void setTradeOffers(List<TradeOffer> tradeOffers) {
        try {
            PacketDataSerializer serializer = new PacketDataSerializer(Unpooled.buffer());
            serializer.a("MC|TrList");
            serializer.writeInt(this.container);
            serializer.writeByte((int)((byte)(tradeOffers.size() & 0xFF)));
            for (TradeOffer tradeOffer : tradeOffers) {
                serializer.a(CraftItemStack.asNMSCopy((ItemStack)tradeOffer.getFirstCost()));
                serializer.a(CraftItemStack.asNMSCopy((ItemStack)tradeOffer.getProduct()));
                boolean hasSecondCost = tradeOffer.hasSecondCost();
                serializer.writeBoolean(hasSecondCost);
                if (hasSecondCost) {
                    serializer.a(CraftItemStack.asNMSCopy((ItemStack)tradeOffer.getSecondCost()));
                }
                serializer.writeBoolean(tradeOffer.isUsedMaxTimes());
                serializer.writeInt(tradeOffer.getCurrentUses());
                serializer.writeInt(tradeOffer.getMaxUses());
            }
            this.internal.a(serializer);
        }
        catch (Exception e) {
            dB.echoError((Throwable)e);
        }
    }
}

