/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.helpers;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.UUID;
import net.aufdemrand.denizen.nms.impl.blocks.BlockData_v1_13_R2;
import net.aufdemrand.denizen.nms.impl.jnbt.CompoundTag_v1_13_R2;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.nms.interfaces.BlockHelper;
import net.aufdemrand.denizen.nms.util.PlayerProfile;
import net.aufdemrand.denizen.nms.util.ReflectionHelper;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.minecraft.server.v1_13_R2.Block;
import net.minecraft.server.v1_13_R2.Blocks;
import net.minecraft.server.v1_13_R2.Item;
import net.minecraft.server.v1_13_R2.ItemBlock;
import net.minecraft.server.v1_13_R2.TileEntity;
import net.minecraft.server.v1_13_R2.TileEntitySkull;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftSkull;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_13_R2.util.CraftLegacy;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class BlockHelper_v1_13_R2
implements BlockHelper {
    public <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            Field f = CraftBlockEntityState.class.getDeclaredField("tileEntity");
            f.setAccessible(true);
            return (T)((TileEntity)f.get(cbs));
        }
        catch (IllegalAccessException e) {
            dB.echoError((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            dB.echoError((Throwable)e);
        }
        return null;
    }

    public int idFor(Material mat) {
        if (mat.isLegacy()) {
            return mat.getId();
        }
        return CraftLegacy.toLegacy((Material)mat).getId();
    }

    public MaterialData getFlowerpotContents(org.bukkit.block.Block block) {
        throw new UnsupportedOperationException("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
    }

    public void setFlowerpotContents(org.bukkit.block.Block block, MaterialData data) {
        throw new UnsupportedOperationException("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)this.getTE((CraftBlockEntityState)((CraftSkull)skull))).getGameProfile();
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        TileEntitySkull tileEntity = (TileEntitySkull)this.getTE((CraftBlockEntityState)((CraftSkull)skull));
        tileEntity.setGameProfile(gameProfile);
        skull.getBlock().getState().update();
    }

    public CompoundTag getNbtData(org.bukkit.block.Block block) {
        Object tileEntity = this.getTE((CraftBlockEntityState)((CraftBlockState)block.getState()));
        if (tileEntity == null) {
            return null;
        }
        return CompoundTag_v1_13_R2.fromNMSTag(tileEntity.aa_());
    }

    public void setNbtData(org.bukkit.block.Block block, CompoundTag compoundTag) {
        Object tileEntity = this.getTE((CraftBlockEntityState)((CraftBlockState)block.getState()));
        if (tileEntity == null) {
            return;
        }
        tileEntity.load(((CompoundTag_v1_13_R2)compoundTag).toNMSTag());
        tileEntity.update();
    }

    public BlockData getBlockData(Material material, byte data) {
        return new BlockData_v1_13_R2(material, data);
    }

    public BlockData getBlockData(org.bukkit.block.Block block) {
        return new BlockData_v1_13_R2(block);
    }

    public BlockData getBlockData(String compressedString) {
        return BlockData_v1_13_R2.fromCompressedString(compressedString);
    }

    private static Block getBlockFrom(Material material) {
        if (material == Material.FLOWER_POT) {
            return Blocks.FLOWER_POT;
        }
        net.minecraft.server.v1_13_R2.ItemStack is = CraftItemStack.asNMSCopy((ItemStack)new ItemStack(material));
        if (is == null) {
            return null;
        }
        Item item = is.getItem();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        return ((ItemBlock)item).getBlock();
    }

    public boolean hasBlock(Material material) {
        return BlockHelper_v1_13_R2.getBlockFrom(material) != null;
    }

    public boolean setBlockResistance(Material material, float resistance) {
        Block block = BlockHelper_v1_13_R2.getBlockFrom(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(Block.class, (String)"durability", (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        Block block = BlockHelper_v1_13_R2.getBlockFrom(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(Block.class, (String)"durability", (Object)block)).floatValue();
    }

    public boolean isSafeBlock(Material material) {
        return !material.isSolid();
    }

    public BlockState generateBlockState(Material mat) {
        return new CraftBlockState(mat);
    }
}

