/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.aufdemrand.denizen.nms.abstracts.BiomeNMS;
import net.aufdemrand.denizen.nms.util.ReflectionHelper;
import net.minecraft.server.v1_13_R2.BiomeBase;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.Chunk;
import net.minecraft.server.v1_13_R2.EntityTypes;
import net.minecraft.server.v1_13_R2.EnumCreatureType;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftBlock;
import org.bukkit.entity.EntityType;

public class BiomeNMS_v1_13_R2
extends BiomeNMS {
    private final BiomeBase biomeBase;

    public BiomeNMS_v1_13_R2(Biome biome) {
        super(biome);
        this.biomeBase = CraftBlock.biomeToBiomeBase((Biome)biome);
    }

    public float getHumidity() {
        return this.biomeBase.getHumidity();
    }

    public float getTemperature() {
        return this.biomeBase.getTemperature();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.AMBIENT);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.CREATURE);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.MONSTER);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.WATER_CREATURE);
    }

    public void setHumidity(float humidity) {
        ReflectionHelper.setFieldValue(BiomeBase.class, (String)"C", (Object)this.biomeBase, (Object)Float.valueOf(humidity));
    }

    public void setTemperature(float temperature) {
        ReflectionHelper.setFieldValue(BiomeBase.class, (String)"B", (Object)this.biomeBase, (Object)Float.valueOf(temperature));
    }

    public void changeBlockBiome(Location location) {
        Chunk chunk;
        int x = location.getBlockX();
        int z = location.getBlockZ();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        if (world.isLoaded(new BlockPosition(x, 0, z)) && (chunk = world.getChunkAtWorldCoords(new BlockPosition(x, 0, z))) != null) {
            BiomeBase[] biomevals = chunk.getBiomeIndex();
            biomevals[(z & 0xF) << 4 | x & 0xF] = this.biomeBase;
        }
    }

    protected boolean getDoesRain() {
        return this.biomeBase.c() == BiomeBase.Precipitation.RAIN;
    }

    protected boolean getDoesSnow() {
        return this.biomeBase.c() == BiomeBase.Precipitation.SNOW;
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (BiomeBase.BiomeMeta meta : this.biomeBase.getMobs(creatureType)) {
            try {
                String n = EntityTypes.getName((EntityTypes)meta.b).getKey();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }
}

