/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.helpers;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.abstracts.ModernBlockData;
import net.aufdemrand.denizen.nms.impl.blocks.BlockData_v1_14_R1;
import net.aufdemrand.denizen.nms.impl.jnbt.CompoundTag_v1_14_R1;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.nms.interfaces.BlockHelper;
import net.aufdemrand.denizen.nms.util.PlayerProfile;
import net.aufdemrand.denizen.nms.util.ReflectionHelper;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.minecraft.server.v1_14_R1.Block;
import net.minecraft.server.v1_14_R1.Blocks;
import net.minecraft.server.v1_14_R1.Item;
import net.minecraft.server.v1_14_R1.ItemBlock;
import net.minecraft.server.v1_14_R1.TileEntity;
import net.minecraft.server.v1_14_R1.TileEntitySkull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_14_R1.util.CraftLegacy;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class BlockHelper_v1_14_R1
implements BlockHelper {
    public List<Location> getBlocksList(PortalCreateEvent event) {
        ArrayList<Location> blocks = new ArrayList<Location>();
        for (BlockState block : event.getBlocks()) {
            blocks.add(block.getLocation());
        }
        return blocks;
    }

    public <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            Field f = CraftBlockEntityState.class.getDeclaredField("tileEntity");
            f.setAccessible(true);
            return (T)((TileEntity)f.get(cbs));
        }
        catch (IllegalAccessException e) {
            dB.echoError((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            dB.echoError((Throwable)e);
        }
        return null;
    }

    public int idFor(Material mat) {
        if (mat.isLegacy()) {
            return mat.getId();
        }
        return CraftLegacy.toLegacy((Material)mat).getId();
    }

    public MaterialData getFlowerpotContents(org.bukkit.block.Block block) {
        throw new UnsupportedOperationException("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
    }

    public void setFlowerpotContents(org.bukkit.block.Block block, MaterialData data) {
        throw new UnsupportedOperationException("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)this.getTE((CraftSkull)skull)).gameProfile;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        TileEntitySkull tileEntity = (TileEntitySkull)this.getTE((CraftBlockEntityState)((CraftSkull)skull));
        tileEntity.setGameProfile(gameProfile);
        skull.update();
    }

    public CompoundTag getNbtData(org.bukkit.block.Block block) {
        NMSHandler.getInstance().getChunkHelper().changeChunkServerThread(block.getWorld());
        BlockState state = block.getState();
        NMSHandler.getInstance().getChunkHelper().restoreServerThread(block.getWorld());
        Object tileEntity = this.getTE((CraftBlockEntityState)state);
        if (tileEntity == null) {
            return null;
        }
        return CompoundTag_v1_14_R1.fromNMSTag(tileEntity.b());
    }

    public void setNbtData(org.bukkit.block.Block block, CompoundTag compoundTag) {
        NMSHandler.getInstance().getChunkHelper().changeChunkServerThread(block.getWorld());
        BlockState state = block.getState();
        NMSHandler.getInstance().getChunkHelper().restoreServerThread(block.getWorld());
        Object tileEntity = this.getTE((CraftBlockEntityState)state);
        if (tileEntity == null) {
            return;
        }
        tileEntity.load(((CompoundTag_v1_14_R1)compoundTag).toNMSTag());
        tileEntity.update();
    }

    public BlockData getBlockData(Material material, byte data) {
        return new BlockData_v1_14_R1(material, data);
    }

    public BlockData getBlockData(ModernBlockData data) {
        return new BlockData_v1_14_R1(data.data);
    }

    public BlockData getBlockData(org.bukkit.block.Block block) {
        return new BlockData_v1_14_R1(block);
    }

    public BlockData getBlockData(String compressedString) {
        return BlockData_v1_14_R1.fromCompressedString(compressedString);
    }

    private static Block getBlockFrom(Material material) {
        if (material == Material.FLOWER_POT) {
            return Blocks.FLOWER_POT;
        }
        net.minecraft.server.v1_14_R1.ItemStack is = CraftItemStack.asNMSCopy((ItemStack)new ItemStack(material));
        if (is == null) {
            return null;
        }
        Item item = is.getItem();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        return ((ItemBlock)item).getBlock();
    }

    public boolean hasBlock(Material material) {
        return BlockHelper_v1_14_R1.getBlockFrom(material) != null;
    }

    public boolean setBlockResistance(Material material, float resistance) {
        Block block = BlockHelper_v1_14_R1.getBlockFrom(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(Block.class, (String)"durability", (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        Block block = BlockHelper_v1_14_R1.getBlockFrom(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(Block.class, (String)"durability", (Object)block)).floatValue();
    }

    public boolean isSafeBlock(Material material) {
        return !material.isSolid();
    }

    public BlockState generateBlockState(Material mat) {
        return new CraftBlockState(mat);
    }
}

