/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dItem;
import net.aufdemrand.denizen.utilities.arguments.dList;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldScriptHelper
implements Listener {
    public static Map<String, WorldScriptContainer> world_scripts = new ConcurrentHashMap<String, WorldScriptContainer>(8, 0.9f, 1);
    private Map<String, Integer> current_time = new HashMap<String, Integer>();

    public WorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public String doEvent(String eventName, dNPC npc, Player player, Map<String, String> context) {
        String determination = "none";
        for (WorldScriptContainer script : world_scripts.values()) {
            List<ScriptEntry> entries;
            if (script == null || !script.contains("EVENTS.ON " + eventName.toUpperCase()) || (entries = script.getEntries(player, npc, "events.on " + eventName)).isEmpty()) continue;
            dB.report("Event", aH.debugObj("Type", "On " + eventName) + script.getAsScriptArg().debug() + (npc != null ? aH.debugObj("NPC", npc.toString()) : "") + (player != null ? aH.debugObj("Player", player.getName()) : "") + (context != null ? aH.debugObj("Context", context.toString()) : ""));
            dB.echoDebug(dB.DebugElement.Header, "Building event 'On " + eventName.toUpperCase() + "' for " + script.getName());
            if (context != null) {
                for (Map.Entry<String, String> entry : context.entrySet()) {
                    ScriptBuilder.addObjectToEntries(entries, entry.getKey(), entry.getValue());
                }
            }
            long id = DetermineCommand.getNewId();
            ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
            ScriptQueue._getInstantQueue(ScriptQueue._getNextId()).addEntries(entries).start();
            if (!DetermineCommand.hasOutcome(id)) continue;
            determination = DetermineCommand.getOutcome(id);
        }
        return determination;
    }

    @EventHandler
    public void commandEvent(PlayerCommandPreprocessEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        dList args = new dList(Arrays.asList(aH.buildArgs(TagManager.tag((OfflinePlayer)event.getPlayer(), null, event.getMessage().split(" ").length > 1 ? event.getMessage().split(" ", 2)[1] : ""))));
        String command = event.getMessage().split(" ")[0].replace("/", "").toUpperCase();
        context.put("args", args.dScriptArgValue());
        context.put("command", command);
        context.put("raw_args", event.getMessage().split(" ").length > 1 ? event.getMessage().split(" ", 2)[1] : "");
        String determination = this.doEvent(command + " command", null, event.getPlayer(), context).toUpperCase();
        if (determination.equals("FULFILLED") || determination.equals("CANCELLED")) {
            event.setCancelled(true);
        }
        if ((determination = this.doEvent("command", null, event.getPlayer(), context).toUpperCase()).equals("FULFILLED") || determination.equals("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void loginEvent(PlayerLoginEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("hostname", event.getHostname());
        String determination = this.doEvent("player login", null, event.getPlayer(), context).toUpperCase();
        if (determination.toUpperCase().startsWith("KICKED")) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void loginEvent(PlayerQuitEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("message", event.getQuitMessage());
        String determination = this.doEvent("player quit", null, event.getPlayer(), context).toUpperCase();
        if (determination.toUpperCase().startsWith("MESSAGE")) {
            event.setQuitMessage(aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void joinEvent(PlayerJoinEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("message", event.getJoinMessage());
        String determination = this.doEvent("player join", null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("MESSAGE")) {
            event.setJoinMessage(aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void walkOnLocationEvent(PlayerMoveEvent event) {
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        String name = dLocation.isSavedLocation(event.getPlayer().getLocation());
        if (name != null) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("notable_name", name);
            String determination = this.doEvent("walked over " + name, null, event.getPlayer(), context);
            if (determination.toUpperCase().startsWith("FROZEN")) {
                event.setCancelled(true);
            }
            if ((determination = this.doEvent("walked over notable location", null, event.getPlayer(), context)).toUpperCase().startsWith("FROZEN")) {
                event.setCancelled(true);
            }
        }
    }

    public void serverStartEvent() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                WorldScriptHelper.this.timeEvent();
            }
        }, Settings.WorldScriptTimeEventResolution().getTicks(), Settings.WorldScriptTimeEventResolution().getTicks());
        this.doEvent("server start", null, null, null);
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            int hour = Double.valueOf(world.getTime() / 1000L).intValue();
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey(world.getName()) && this.current_time.get(world.getName()) == hour) continue;
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("time", String.valueOf(hour));
            context.put("world", world.getName());
            this.doEvent("time change in " + world.getName(), null, null, context);
            this.doEvent(hour + ":00 in " + world.getName(), null, null, context);
            this.current_time.put(world.getName(), hour);
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_AIR) {
            String determination;
            HashMap<String, String> context = new HashMap<String, String>();
            if (event.getItem() != null) {
                context.put("item_in_hand", new dItem(event.getItem()).dScriptArgValue());
                determination = this.doEvent("player swings " + new dItem(event.getItem()).dScriptArgValue() + " in air", null, event.getPlayer(), context);
                if (determination.toUpperCase().startsWith("CANCELLED")) {
                    event.setCancelled(true);
                }
                if ((determination = this.doEvent("player swings item in air", null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
                    event.setCancelled(true);
                }
            }
            if ((determination = this.doEvent("player swings arm in air", null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
        } else if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            String determination;
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("location clicked", new dLocation(event.getClickedBlock().getLocation()).dScriptArgValue());
            if (event.getItem() != null) {
                context.put("item_in_hand", new dItem(event.getItem()).dScriptArgValue());
                determination = this.doEvent("player hits block with " + new dItem(event.getItem()).dScriptArgValue(), null, event.getPlayer(), context);
                if (determination.toUpperCase().startsWith("CANCELLED")) {
                    event.setCancelled(true);
                }
                if ((determination = this.doEvent("player hits block with item", null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
                    event.setCancelled(true);
                }
            }
            if ((determination = this.doEvent("player hits block", null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
        } else if (event.getAction() == Action.PHYSICAL) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("interact location", new dLocation(event.getClickedBlock().getLocation()).dScriptArgValue());
            String determination = this.doEvent("player interacts with block", null, event.getPlayer(), context);
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerChat(AsyncPlayerChatEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("message", event.getMessage());
        String determination = this.doEvent("player chats", null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("MESSAGE")) {
            event.setMessage(aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void playerHit(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player && !CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("cause", event.getCause().toString());
            String determination = this.doEvent("player damaged", null, (Player)event.getEntity(), context);
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
            if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Integer)) {
                event.setDamage(aH.getIntegerFrom(determination));
            }
            if ((determination = this.doEvent("player damaged by " + event.getCause().toString(), null, (Player)event.getEntity(), context)).toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
            if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Integer)) {
                event.setDamage(aH.getIntegerFrom(determination));
            }
        }
    }

    @EventHandler
    public void playerHitByEntity(EntityDamageByEntityEvent event) {
        String determination;
        HashMap<String, String> context;
        if (CitizensAPI.getNPCRegistry().isNPC(event.getEntity()) && event.getDamager() instanceof Player) {
            context = new HashMap<String, String>();
            context.put("cause", event.getCause().toString());
            determination = this.doEvent("player damages npc", DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(event.getEntity())), (Player)event.getDamager(), context);
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
            if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Integer)) {
                event.setDamage(aH.getIntegerFrom(determination));
            }
        }
        if (event.getEntity() instanceof Player) {
            context = new HashMap();
            context.put("cause", event.getCause().toString());
            context.put("damaging entity", event.getDamager().getType().toString());
            determination = this.doEvent("player damaged by entity", null, (Player)event.getEntity(), context);
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
            if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Integer)) {
                event.setDamage(aH.getIntegerFrom(determination));
            }
            if (CitizensAPI.getNPCRegistry().isNPC(event.getDamager())) {
                context.put("damager", String.valueOf(CitizensAPI.getNPCRegistry().getNPC(event.getDamager()).getId()));
                determination = this.doEvent("player damaged by npc", null, (Player)event.getEntity(), context);
                if (determination.toUpperCase().startsWith("CANCELLED")) {
                    event.setCancelled(true);
                }
                if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Integer)) {
                    event.setDamage(aH.getIntegerFrom(determination));
                }
            } else if (event.getDamager() instanceof Player) {
                context.put("damager", ((Player)event.getDamager()).getName());
                determination = this.doEvent("player damaged by player", null, (Player)event.getEntity(), context);
                if (determination.toUpperCase().startsWith("CANCELLED")) {
                    event.setCancelled(true);
                }
                if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Integer)) {
                    event.setDamage(aH.getIntegerFrom(determination));
                }
            } else {
                determination = this.doEvent("player damaged by " + event.getDamager().getType().toString(), null, (Player)event.getEntity(), context);
                if (determination.toUpperCase().startsWith("CANCELLED")) {
                    event.setCancelled(true);
                }
                if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Integer)) {
                    event.setDamage(aH.getIntegerFrom(determination));
                }
            }
        }
    }

    @EventHandler
    public void playerEat(EntityRegainHealthEvent event) {
        if (event.getEntity() instanceof Player && !CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("reason", event.getRegainReason().toString());
            context.put("amount", String.valueOf(event.getAmount()));
            String determination = this.doEvent("player regains health", null, (Player)event.getEntity(), context);
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
            if (aH.matchesValueArg("AMOUNT", determination, aH.ArgumentType.Integer)) {
                event.setAmount(aH.getIntegerFrom(determination));
            }
        }
    }

    @EventHandler
    public void playerDeath(PlayerDeathEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("message", event.getDeathMessage());
        String determination = this.doEvent("player death", null, event.getEntity(), context);
        if (determination.toUpperCase().startsWith("MESSAGE")) {
            event.setDeathMessage(aH.getStringFrom(determination));
        }
    }
}

