/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListener {
    protected Denizen denizen;
    protected String listenerType;
    public String listenerId;
    protected Player player;
    protected String scriptName;
    protected dNPC npc;
    protected Map<String, Object> saveable = new HashMap<String, Object>();

    public AbstractListener() {
        this.denizen = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
    }

    public void build(Player player, String listenerId, String listenerType, List<String> args, String finishScript, dNPC npc) {
        this.player = player;
        this.listenerId = listenerId;
        this.listenerType = listenerType;
        this.scriptName = finishScript;
        this.npc = npc;
        this.onBuild(args);
        this.save();
        this.constructed();
    }

    public void cancel() {
        this.onCancel();
        this.denizen.getListenerRegistry().cancel(this.player, this.listenerId, this);
        this.deconstructed();
    }

    public abstract void constructed();

    public abstract void deconstructed();

    public void finish() {
        this.onFinish();
        this.denizen.getListenerRegistry().finish(this.player, this.npc, this.listenerId, this.scriptName, this);
        this.deconstructed();
    }

    public Object get(String key) {
        return this.denizen.getSaves().get("Listeners." + this.player.getName() + "." + this.listenerId + "." + key);
    }

    public String getListenerId() {
        return this.listenerId != null ? this.listenerId : "";
    }

    public String getListenerType() {
        return this.listenerType != null ? this.listenerType : "";
    }

    public void load(Player player, dNPC npc, String listenerId, String listenerType) {
        this.player = player;
        this.listenerId = listenerId;
        this.listenerType = listenerType;
        this.scriptName = (String)this.get("Finish Script");
        this.npc = npc;
        try {
            this.onLoad();
        }
        catch (Exception e) {
            dB.echoError("Problem loading saved listener '" + listenerId + "' for " + player.getName() + "!");
        }
        this.constructed();
    }

    public abstract void onBuild(List<String> var1);

    public abstract void onCancel();

    public abstract void onFinish();

    public abstract void onLoad();

    public abstract void onSave();

    public abstract String report();

    public void save() {
        this.denizen.getSaves().set("Listeners." + this.player.getName() + "." + this.listenerId + ".Listener Type", (Object)this.listenerType);
        this.denizen.getSaves().set("Listeners." + this.player.getName() + "." + this.listenerId + ".Finish Script", (Object)this.scriptName);
        this.denizen.getSaves().set("Listeners." + this.player.getName() + "." + this.listenerId + ".Linked NPCID", (Object)this.npc.getId());
        this.onSave();
        try {
            if (!this.saveable.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.saveable.entrySet()) {
                    this.denizen.getSaves().set("Listeners." + this.player.getName() + "." + this.listenerId + "." + entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            dB.echoError("Problem saving listener '" + this.listenerId + "' for " + this.player.getName() + "!");
        }
        this.deconstructed();
    }

    public void store(String key, Object object) {
        this.saveable.put(key, object);
    }
}

