/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Sound;

public class AnimateChestCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String chestAction = "OPEN";
        dLocation location = null;
        Boolean sound = true;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("OPEN, CLOSE", arg)) {
                chestAction = aH.getStringFrom(arg);
                dB.echoDebug("...chest action set: " + chestAction);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set");
                continue;
            }
            if (aH.matchesValueArg("SOUND", arg, aH.ArgumentType.Boolean)) {
                sound = aH.getBooleanFrom(arg);
                if (sound.booleanValue()) {
                    dB.echoDebug("...sound enabled");
                    continue;
                }
                dB.echoDebug("...sound disabled");
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (location == null) {
            dB.echoError("...location is invalid");
        }
        scriptEntry.addObject("location", location).addObject("sound", sound).addObject("chestAction", chestAction);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        ChestAction action = ChestAction.valueOf(((String)scriptEntry.getObject("chestAction")).toUpperCase());
        Boolean sound = (Boolean)scriptEntry.getObject("sound");
        switch (action) {
            case OPEN: {
                if (sound.booleanValue()) {
                    scriptEntry.getPlayer().playSound(location, Sound.CHEST_OPEN, 1.0f, 1.0f);
                }
                scriptEntry.getPlayer().playNote(location, (byte)1, (byte)1);
                dB.echoDebug("...opening chest");
                break;
            }
            case CLOSE: {
                if (sound.booleanValue()) {
                    scriptEntry.getPlayer().playSound(location, Sound.CHEST_CLOSE, 1.0f, 1.0f);
                }
                scriptEntry.getPlayer().playNote(location, (byte)1, (byte)0);
                dB.echoDebug("...closing chest");
                break;
            }
            default: {
                dB.echoError("...error animating chest");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ChestAction {
        OPEN,
        CLOSE;

    }
}

