/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dItem;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class ScribeCommand
extends AbstractCommand
implements Listener {
    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean savedItem = false;
        BookAction action = BookAction.NONE;
        dItem book = null;
        Player player = scriptEntry.getPlayer();
        String scriptName = null;
        dLocation location = null;
        dNPC npc = scriptEntry.getNPC();
        if (npc != null) {
            location = npc.getLocation();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("DROP, GIVE, EQUIP", arg)) {
                action = BookAction.valueOf(arg.toUpperCase());
                continue;
            }
            if (aH.matchesScript(arg)) {
                scriptName = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                action = BookAction.DROP;
                continue;
            }
            if (aH.matchesItem(arg)) {
                book = aH.getItemFrom(arg);
                if (book.getItemStack().getType() == Material.BOOK || book.getItemStack().getType() == Material.WRITTEN_BOOK) {
                    savedItem = true;
                    continue;
                }
                book = null;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (action == BookAction.NONE && !savedItem) {
            action = BookAction.GIVE;
        }
        if (scriptName == null) {
            throw new InvalidArgumentsException("Missing SCRIPT argument!");
        }
        if (book == null) {
            book = new dItem(387);
        }
        scriptEntry.addObject("action", (Object)action);
        scriptEntry.addObject("book", book);
        scriptEntry.addObject("script", scriptName);
        scriptEntry.addObject("player", player);
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("npc", npc);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        BookAction action = (BookAction)((Object)scriptEntry.getObject("action"));
        dItem book = (dItem)scriptEntry.getObject("book");
        String scriptName = (String)scriptEntry.getObject("script");
        Player player = (Player)scriptEntry.getObject("player");
        Location location = (Location)scriptEntry.getObject("location");
        dNPC npc = (dNPC)scriptEntry.getObject("npc");
        BookScriptContainer bookScript = ScriptRegistry.getScriptContainerAs(scriptName, BookScriptContainer.class);
        book = bookScript.writeBookTo(book, player, npc);
        switch (action) {
            case DROP: {
                this.dropBook(location, book.getItemStack());
                break;
            }
            case GIVE: {
                this.giveBook(player, book.getItemStack());
                break;
            }
            case EQUIP: {
                this.equipBook(player, book.getItemStack());
                break;
            }
        }
        player.updateInventory();
    }

    private void giveBook(Player player, ItemStack book) {
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (emptySpot != -1) {
            player.getInventory().addItem(new ItemStack[]{book});
        } else {
            player.getWorld().dropItem(player.getLocation(), book);
            dB.echoDebug("Player's inventory is full, dropped book.");
        }
    }

    private void equipBook(Player player, ItemStack book) {
        ItemStack currItem = player.getItemInHand();
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (currItem == null || currItem.getType() == Material.AIR) {
            player.setItemInHand(book);
            return;
        }
        emptySpot = inv.firstEmpty();
        dB.echoDebug("emptySpot: " + emptySpot);
        if (emptySpot == -1) {
            player.getWorld().dropItem(player.getLocation(), book);
            dB.echoDebug("Player's inventory is full, dropped book.");
        } else {
            inv.setItem(emptySpot, currItem);
            player.setItemInHand(book);
            dB.echoDebug("...added book to player hand, moved original item");
        }
    }

    private void dropBook(Location location, ItemStack book) {
        location.getWorld().dropItem(location, book);
    }

    @EventHandler
    public void paragraph(ReplaceableTagEvent e) {
        if (e.matches("P")) {
            e.setReplaced("\n \u00a7r \n");
            return;
        }
        if (e.matches("N")) {
            e.setReplaced("\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BookAction {
        GIVE,
        DROP,
        EQUIP,
        NONE;

    }
}

