/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class WaitCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ScriptQueue queue = scriptEntry.getResidingQueue();
        Duration delay = new Duration(3);
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesInteger(arg) || aH.matchesDouble(arg) || aH.matchesDuration(arg)) {
                delay = Duration.valueOf(String.valueOf(aH.getDoubleFrom(arg)));
            }
            if (!aH.matchesQueue(arg)) continue;
            queue = aH.getQueueFrom(arg);
        }
        scriptEntry.addObject("queue", queue);
        scriptEntry.addObject("delay", delay.setPrefix("Duration"));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        ScriptQueue queue = (ScriptQueue)scriptEntry.getObject("queue");
        Duration delay = (Duration)scriptEntry.getObject("delay");
        dB.echoDebug("Delaying " + delay.dScriptArgValue());
        queue.delayUntil(System.currentTimeMillis() + delay.getMillis());
    }
}

