/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ContextTags
implements Listener {
    public ContextTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler
    public void getEntry(ReplaceableTagEvent event) {
        if (!event.matches("SCRIPT") || event.getScriptEntry() == null) {
            return;
        }
        ScriptContainer script = event.getScriptEntry().getScript().getContainer();
        String type = event.getType();
        String sub_type = "";
        if (event.hasSubType()) {
            sub_type = event.getSubType();
        }
        String specifier = "";
        if (event.hasSpecifier()) {
            specifier = event.getSpecifier();
        }
        if (event.hasTypeContext()) {
            script = ScriptRegistry.getScriptContainer(event.getTypeContext());
        }
        if (type.equalsIgnoreCase("REQUIREMENTS")) {
            if (sub_type.equals("CHECK")) {
                event.setReplaced(String.valueOf(event.getScriptEntry().getScript().getContainer().checkBaseRequirements(event.getPlayer(), event.getNPC())));
            }
        } else if (type.equalsIgnoreCase("TYPE")) {
            event.setReplaced(script.getType());
        } else if (type.equalsIgnoreCase("SPEED")) {
            if (script.contains("SPEED")) {
                event.setReplaced(script.getString("SPEED"));
            }
        } else if (type.equalsIgnoreCase("NAME")) {
            event.setReplaced(script.getName());
        }
    }

    @EventHandler
    public void getContext(ReplaceableTagEvent event) {
        Map<String, Integer> id;
        HashMap context;
        if (!event.matches("CONTEXT") || event.getScriptEntry() == null) {
            return;
        }
        String type = event.getType();
        if (event.getScriptEntry().hasObject(type)) {
            event.setReplaced(event.getScriptEntry().getObject(type).toString());
        }
        if (!ScriptRegistry.containsScript(event.getScriptEntry().getScript().getName(), TaskScriptContainer.class)) {
            return;
        }
        TaskScriptContainer script = ScriptRegistry.getScriptContainerAs(event.getScriptEntry().getScript().getName(), TaskScriptContainer.class);
        ScriptEntry entry = event.getScriptEntry();
        if (entry.hasObject("CONTEXT") && (context = (HashMap)entry.getObject("CONTEXT")).containsKey(String.valueOf((id = script.getContextMap()).get(type.toUpperCase())))) {
            event.setReplaced((String)context.get(String.valueOf(id.get(type.toUpperCase()))));
        }
    }
}

