/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.arguments.dItem;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_5_R3.Entity;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_5_R3.CraftWorld;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class aH {
    static final Pattern doublePtrn = Pattern.compile("(-)?(?:(?:\\d+)|)(?:(?:\\.\\d+)|)");
    static final Pattern floatPtrn = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
    static final Pattern integerPtrn = Pattern.compile("(-)?\\d+");
    static final Pattern locationPattern = Pattern.compile("location:((-)?\\d+(\\.\\d+)?,){3}\\w+", 2);
    static final Pattern wordPtrn = Pattern.compile("\\w+");
    static final Pattern matchesDurationPtrn = Pattern.compile("duration:(\\d+.\\d+|.\\d+|\\d+)(t|m|s|h|d|)", 2);
    static final Pattern matchesEntityPtrn = Pattern.compile("(?:.+?|):((ENTITY\\.|PLAYER\\.|NPC\\.).+)|(PLAYER|NPC)", 2);
    static final Pattern matchesQuantityPtrn = Pattern.compile("qty:(-)?\\d+", 2);
    static final Pattern matchesQueuePtrn = Pattern.compile("queue:(.+)", 2);
    private static final Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
    static final Pattern matchesTogglePtrn = Pattern.compile("toggle:(?:(?:true)|(?:false)|(?:toggle))", 2);
    static final Pattern matchesScriptPtrn = Pattern.compile("script:(.+)", 2);

    public static String debugObj(String prefix, Object value) {
        return "<G>" + prefix + "='<Y>" + value.toString() + "<G>'  ";
    }

    public static String debugUniqueObj(String prefix, String id, Object value) {
        return "<G>" + prefix + "='<A>" + id + "<Y>(" + value.toString() + ")<G>'  ";
    }

    public static Argument interpret(String arg) {
        return new Argument(arg);
    }

    public static boolean matchesArg(String names, String arg) {
        String[] parts = names.split(",");
        if (parts.length == 1) {
            if (arg.toUpperCase().equals(names.toUpperCase())) {
                return true;
            }
        } else {
            for (String string : parts) {
                if (!arg.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchesValueArg(String names, String arg, ArgumentType type) {
        if (arg == null) {
            return false;
        }
        int firstColonIndex = arg.indexOf(58);
        if (firstColonIndex == -1) {
            return false;
        }
        String[] commaParts = names.split(",");
        if (commaParts.length == 1) {
            if (!arg.substring(0, firstColonIndex).equalsIgnoreCase(names)) {
                return false;
            }
        } else {
            boolean matched = false;
            for (String string : commaParts) {
                if (!arg.substring(0, firstColonIndex).equalsIgnoreCase(string.trim())) continue;
                matched = true;
            }
            if (!matched) {
                return false;
            }
        }
        arg = arg.split(":", 2)[1];
        switch (type) {
            case Word: {
                if (!wordPtrn.matcher(arg).matches()) break;
                return true;
            }
            case Integer: {
                if (!integerPtrn.matcher(arg).matches()) break;
                return true;
            }
            case Double: {
                if (!doublePtrn.matcher(arg).matches()) break;
                return true;
            }
            case Float: {
                if (!floatPtrn.matcher(arg).matches()) break;
                return true;
            }
            case Boolean: {
                if (arg.equalsIgnoreCase("true")) {
                    return true;
                }
                if (!arg.equalsIgnoreCase("false")) break;
                return false;
            }
            case Location: {
                return aH.matchesLocation("location:" + arg);
            }
            case Script: {
                return aH.matchesLocation("script:" + arg);
            }
            case Item: {
                return aH.matchesItem("item:" + arg);
            }
            case LivingEntity: {
                if (!matchesEntityPtrn.matcher(arg).matches()) break;
                return true;
            }
            case Duration: {
                return aH.matchesDuration("duration:" + arg);
            }
            default: {
                return true;
            }
        }
        dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. Check documentation for valid value." + "Perhaps a replaceable tag has failed to fill in a value?");
        return false;
    }

    public static boolean getBooleanFrom(String arg) {
        return Boolean.valueOf(aH.getValuePart(arg));
    }

    public static double getDoubleFrom(String arg) {
        try {
            return Double.valueOf(aH.getValuePart(arg));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static EntityType getEntityFrom(String arg) {
        for (EntityType validEntity : EntityType.values()) {
            if (!aH.getStringFrom(arg).equalsIgnoreCase(validEntity.name())) continue;
            return validEntity;
        }
        return null;
    }

    public static LivingEntity getLivingEntityFrom(String arg) {
        Matcher m = matchesEntityPtrn.matcher(arg);
        if (m.matches()) {
            String entityGroup = m.group(1);
            String entityGroupUpper = entityGroup.toUpperCase();
            if (entityGroupUpper.startsWith("ENTITY.") || entityGroupUpper.startsWith("E@")) {
                World world;
                int entityID = Integer.valueOf(entityGroup.split("\\.")[1]);
                Entity entity = null;
                Iterator i$ = Bukkit.getWorlds().iterator();
                while (i$.hasNext() && (entity = ((CraftWorld)(world = (World)i$.next())).getHandle().getEntity(entityID)) == null) {
                }
                if (entity != null) {
                    return (LivingEntity)entity.getBukkitEntity();
                }
                dB.echoError("Invalid entity! '" + entityGroup + "' could not be found. Has it been despawned or killed?");
            } else if (entityGroupUpper.startsWith("NPC.") || entityGroupUpper.startsWith("NPCID.") || entityGroupUpper.startsWith("n@")) {
                LivingEntity returnable = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(entityGroup.split("\\.")[1]).intValue()).getBukkitEntity();
                if (returnable != null) {
                    return returnable;
                }
                dB.echoError("Invalid NPC! '" + entityGroup + "' could not be found. Has it been despawned or killed?");
            } else if (entityGroupUpper.startsWith("PLAYER.") || entityGroupUpper.startsWith("@P.")) {
                Player returnable = aH.getPlayerFrom(entityGroup.split("\\.")[1]);
                if (returnable != null) {
                    return returnable;
                }
                dB.echoError("Invalid Player! '" + entityGroup + "' could not be found. Has the player logged off?");
            }
        }
        return null;
    }

    public static float getFloatFrom(String arg) {
        try {
            return Float.valueOf(aH.getValuePart(arg)).floatValue();
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static int getIntegerFrom(String arg) {
        try {
            return Integer.valueOf(aH.getValuePart(arg));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static dItem getItemFrom(String arg) {
        dItem stack = dItem.valueOf(arg);
        if (stack == null) {
            dB.echoError("Invalid item! Failed to find a matching Bukkit ItemStack.");
        }
        return stack;
    }

    public static List<String> getListFrom(String arg) {
        if (arg == null || arg.equals("")) {
            return Collections.emptyList();
        }
        return Arrays.asList(aH.getValuePart(arg).split("\\|"));
    }

    public static dLocation getLocationFrom(String arg) {
        dLocation location = dLocation.valueOf(arg);
        if (location == null) {
            dB.echoError("Unable to build a location with this information! Provided: '" + arg + "'.");
        }
        return location;
    }

    public static Script getScriptFrom(String arg) {
        Script script = Script.valueOf(arg);
        if (script == null) {
            dB.echoError("Unable to build a script with this information! Provided: '" + arg + "'.");
        }
        return script;
    }

    public static Player getPlayerFrom(String arg) {
        if ((arg = aH.getValuePart(arg)).toUpperCase().contains("PLAYER.")) {
            arg = arg.toUpperCase().replace("PLAYER.", "");
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(arg)) continue;
            return player;
        }
        dB.echoError("Player '" + arg + "' is invalid, or offline.");
        return null;
    }

    public static NPC getNPCFrom(String arg) {
        arg = aH.getValuePart(arg);
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (npc.getId() != Integer.parseInt(arg)) continue;
            return npc;
        }
        dB.echoError("NPC '" + arg + "' is invalid, or has been removed.");
        return null;
    }

    public static OfflinePlayer getOfflinePlayerFrom(String arg) {
        arg = aH.getValuePart(arg);
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (!player.getName().equalsIgnoreCase(arg)) continue;
            return player;
        }
        dB.echoError("OfflinePlayer '" + arg + "' is invalid, or has never logged in to this server.");
        return null;
    }

    public static ScriptQueue getQueueFrom(String arg) {
        return ScriptQueue._getQueue(aH.getValuePart(arg).toUpperCase());
    }

    public static String getStringFrom(String arg) {
        if (arg.split(":").length >= 2 && (arg.indexOf(58) < arg.indexOf(32) || arg.indexOf(32) == -1)) {
            return arg.split(":", 2)[1];
        }
        return arg;
    }

    private static String getValuePart(String arg) {
        String[] parts = arg.split(":", 2);
        return parts.length >= 2 ? parts[1] : arg;
    }

    public static Duration getDurationFrom(String arg) {
        Duration duration = Duration.valueOf(arg);
        if (duration == null) {
            dB.echoError("Unable to build a duration with this information! Provided: '" + arg + "'.");
        }
        return duration;
    }

    public static boolean matchesDouble(String arg) {
        return doublePtrn.matcher(arg).matches();
    }

    public static boolean matchesDuration(String arg) {
        Matcher m = matchesDurationPtrn.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("DURATION:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. 'DURATION' requires a positive integer value. " + "Perhaps a replaceable Tag has failed to fill in a valid value?");
        }
        return false;
    }

    public static boolean matchesEntityType(String arg) {
        Pattern matchesEntityPtrn = Pattern.compile("entity:(.+)", 2);
        Matcher m = matchesEntityPtrn.matcher(arg);
        if (m.matches()) {
            String group = m.group(1).toUpperCase();
            for (EntityType validEntity : EntityType.values()) {
                if (!group.equals(validEntity.name())) continue;
                return true;
            }
        }
        if (arg.toUpperCase().startsWith("entity:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. Perhaps a replaceable Tag has failed " + "to fill in a valid EntityType, or the EntityType you provided is not correct?");
        }
        return false;
    }

    public static boolean matchesInteger(String arg) {
        return integerPtrn.matcher(arg).matches();
    }

    public static boolean matchesItem(String arg) {
        return arg.length() > 5 && arg.toUpperCase().startsWith("ITEM:");
    }

    public static boolean matchesContext(String arg) {
        return arg.toUpperCase().startsWith("CONTEXT:");
    }

    public static Map<String, String> getContextFrom(String arg) {
        HashMap<String, String> context = new HashMap<String, String>();
        int x = 1;
        for (String ctxt : aH.getListFrom(arg)) {
            context.put(String.valueOf(x), ctxt.trim());
            ++x;
        }
        return context;
    }

    public static boolean matchesLocation(String arg) {
        Matcher m = locationPattern.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("location:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. Perhaps a replaceable Tag has failed " + "to fill in a valid location?");
        }
        return false;
    }

    public static boolean matchesQuantity(String arg) {
        Matcher m = matchesQuantityPtrn.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("qty:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. 'QTY' requires a an integer value. " + "Perhaps a replaceable Tag has failed to fill in a valid value?");
        }
        return false;
    }

    public static boolean matchesQueue(String arg) {
        Matcher m = matchesQueuePtrn.matcher(arg);
        return m.matches();
    }

    public static boolean matchesScript(String arg) {
        Matcher m = matchesScriptPtrn.matcher(arg);
        if (m.matches()) {
            if (ScriptRegistry.containsScript(m.group(1))) {
                return true;
            }
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. This " + "argument's format is correct, but Denizen couldn't locate a script " + "named '" + m.group(1) + "'. Is it spelled correctly?");
        }
        return false;
    }

    public static boolean matchesToggle(String arg) {
        Matcher m = matchesTogglePtrn.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("toggle:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. 'TOGGLE' requires a value of TRUE, FALSE, or TOGGLE. " + "Perhaps a replaceable Tag has failed to fill in a valid value?");
        }
        return false;
    }

    public static String[] buildArgs(String stringArgs) {
        if (stringArgs == null) {
            return null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher regexMatcher = regex.matcher(stringArgs);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        if (dB.showScriptBuilder) {
            dB.echoDebug(ChatColor.GRAY + "Args: " + Arrays.toString(matchList.toArray()));
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    private static class Argument {
        String raw_value;
        String prefix;
        String value;
        ArgumentType argument_type;
        Object argument_object;

        public Argument(String string) {
            this.raw_value = string;
            string = string.trim();
            int first_colon = string.indexOf(":");
            int first_space = string.indexOf(" ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgumentType {
        LivingEntity,
        Item,
        Boolean,
        Custom,
        Double,
        Float,
        Integer,
        String,
        Word,
        Location,
        Script,
        Duration;

    }
}

