/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import org.bukkit.entity.Player;

public class GroupCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = null;
        Player player = scriptEntry.getPlayer();
        String group = null;
        String world = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ADD, REMOVE", arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("WORLD", arg, aH.ArgumentType.String)) {
                world = aH.getStringFrom(arg);
                continue;
            }
            group = arg;
        }
        scriptEntry.addObject("action", (Object)action).addObject("player", player).addObject("group", group).addObject("world", world);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Player player = (Player)scriptEntry.getObject("player");
        String group = String.valueOf(scriptEntry.getObject("group"));
        String world = String.valueOf(scriptEntry.getObject("world"));
        dB.report(this.getName(), aH.debugObj("Action", action.toString()) + aH.debugObj("Player", player.getName()) + aH.debugObj("Group", group) + aH.debugObj("World", world));
        switch (action) {
            case ADD: {
                if (Depends.permissions.playerInGroup(world, player.getName(), group)) {
                    dB.echoDebug("Player " + player.getName() + " is already in group " + group);
                } else {
                    Depends.permissions.playerAddGroup(world, player.getName(), group);
                }
                return;
            }
            case REMOVE: {
                if (!Depends.permissions.playerInGroup(world, player.getName(), group)) {
                    dB.echoDebug("Player " + player.getName() + " is not in group " + group);
                } else {
                    Depends.permissions.playerRemoveGroup(world, player.getName(), group);
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE;

    }
}

