/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.interfaces.dScriptArgument;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.arguments.Element;
import net.aufdemrand.denizen.utilities.arguments.dList;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.NBTItem;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class dItem
implements dScriptArgument {
    static final Pattern[] getItemPtrn = new Pattern[]{Pattern.compile("(?:(?:.+?:)|)(\\d+):(\\d+)"), Pattern.compile("(?:(?:.+?:)|)(\\d+)"), Pattern.compile("(?:(?:.+?:)|)([a-zA-Z\\x5F]+?):(\\d+)"), Pattern.compile("(?:(?:.+?:)|)([a-zA-Z\\x5F]+)"), Pattern.compile("(?:(?:.+?:)|)item\\.(.+)", 2), Pattern.compile("(?:(?:.+?:)|)(.+)")};
    private ItemStack item;
    private String prefix = "Item";

    public static dItem valueOf(String string) {
        return dItem.valueOf(string, null, null);
    }

    public static dItem valueOf(String string, Player player, dNPC npc) {
        if (string == null) {
            return null;
        }
        Matcher[] m = new Matcher[4];
        dItem stack = null;
        m[0] = getItemPtrn[4].matcher(string);
        if (m[0].matches()) {
            // empty if block
        }
        m[0] = getItemPtrn[0].matcher(string);
        m[1] = getItemPtrn[1].matcher(string);
        m[2] = getItemPtrn[2].matcher(string);
        m[3] = getItemPtrn[3].matcher(string);
        try {
            if (m[0].matches()) {
                stack = new dItem(Integer.valueOf(m[0].group(1)));
                stack.setDurability(Short.valueOf(m[0].group(2)));
                return stack;
            }
            if (m[1].matches()) {
                stack = new dItem(Integer.valueOf(m[1].group(1)));
                return stack;
            }
            if (m[2].matches()) {
                stack = new dItem(Material.valueOf((String)m[2].group(1).toUpperCase()));
                stack.setDurability(Short.valueOf(m[2].group(2)));
                return stack;
            }
            if (m[3].matches()) {
                stack = new dItem(Material.valueOf((String)m[3].group(1).toUpperCase()));
                return stack;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        m[0] = getItemPtrn[5].matcher(string);
        if (m[0].matches() && ScriptRegistry.containsScript(m[0].group(1), ItemScriptContainer.class)) {
            dB.echoDebug("TEST!");
            return ScriptRegistry.getScriptContainerAs(m[0].group(1), ItemScriptContainer.class).getItemFrom(player, npc);
        }
        return stack;
    }

    public dItem(Material material) {
        this.item = new ItemStack(material);
    }

    public dItem(int itemId) {
        this.item = new ItemStack(itemId);
    }

    public dItem(Material material, int qty) {
        this.item = new ItemStack(material, qty);
    }

    public dItem(int type, int qty) {
        this.item = new ItemStack(type, qty);
    }

    public dItem(ItemStack item) {
        this.item = item;
    }

    public int comparesTo(dItem item) {
        return this.comparesTo(item.getItemStack());
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public int comparesTo(ItemStack item) {
        int determination = 0;
        ItemStack compared = this.getItemStack();
        ItemStack compared_to = item;
        if (compared.getTypeId() != compared_to.getTypeId()) {
            return -1;
        }
        if (compared_to.hasItemMeta()) {
            if (!compared.hasItemMeta()) {
                return -1;
            }
            if (compared_to.getItemMeta().hasDisplayName()) {
                if (!compared.getItemMeta().hasDisplayName()) {
                    return -1;
                }
                if (compared_to.getItemMeta().getDisplayName().toUpperCase().startsWith(compared.getItemMeta().getDisplayName().toUpperCase())) {
                    if (compared.getItemMeta().getDisplayName().length() > compared_to.getItemMeta().getDisplayName().length()) {
                        ++determination;
                    }
                } else {
                    return -1;
                }
            }
            if (compared_to.getItemMeta().hasLore()) {
                if (!compared.getItemMeta().hasLore()) {
                    return -1;
                }
                for (String string : compared_to.getItemMeta().getLore()) {
                    if (compared.getItemMeta().getLore().contains(string)) continue;
                    return -1;
                }
                if (compared.getItemMeta().getLore().size() > compared_to.getItemMeta().getLore().size()) {
                    ++determination;
                }
            }
            if (!compared_to.getItemMeta().getEnchants().isEmpty()) {
                if (compared.getItemMeta().getEnchants().isEmpty()) {
                    return -1;
                }
                for (Map.Entry entry : compared_to.getItemMeta().getEnchants().entrySet()) {
                    if (compared.getItemMeta().getEnchants().containsKey(entry.getKey()) && (Integer)compared.getItemMeta().getEnchants().get(entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return -1;
                }
                if (compared.getItemMeta().getEnchants().size() > compared_to.getItemMeta().getEnchants().size()) {
                    ++determination;
                }
            }
        }
        if (this.isRepairable()) {
            if (compared.getDurability() < compared_to.getDurability()) {
                ++determination;
            }
        } else if (this.getItemStack().getData().getData() != item.getData().getData()) {
            return -1;
        }
        return determination;
    }

    public void setDurability(short amt) {
        this.item.setDurability(amt);
    }

    public boolean isRepairable() {
        switch (this.getItemStack().getType()) {
            case BOW: 
            case DIAMOND_AXE: 
            case DIAMOND_HOE: 
            case DIAMOND_PICKAXE: 
            case DIAMOND_SPADE: 
            case DIAMOND_SWORD: 
            case FISHING_ROD: 
            case GOLD_AXE: 
            case GOLD_HOE: 
            case GOLD_PICKAXE: 
            case GOLD_SPADE: 
            case GOLD_SWORD: 
            case IRON_AXE: 
            case IRON_HOE: 
            case IRON_PICKAXE: 
            case IRON_SPADE: 
            case IRON_SWORD: 
            case SHEARS: 
            case WOOD_AXE: 
            case WOOD_HOE: 
            case WOOD_PICKAXE: 
            case WOOD_SPADE: 
            case WOOD_SWORD: {
                return true;
            }
        }
        return this.getItemStack().getType().getId() >= Material.LEATHER_HELMET.getId() && this.getItemStack().getType().getId() <= Material.GOLD_BOOTS.getId();
    }

    public String getId() {
        if (NBTItem.hasCustomNBT(this.getItemStack(), "denizen-script-id")) {
            return NBTItem.getCustomNBT(this.getItemStack(), "denizen-script-id");
        }
        return this.getItemStack().getType().name().toLowerCase() + ":" + this.getItemStack().getData().getData();
    }

    public void setItemStack(ItemStack item) {
        this.item = item;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.getId() + "<G>'  ";
    }

    public String as_dScriptArg() {
        return this.prefix + ":" + this.getId();
    }

    public String dScriptArgValue() {
        return this.getDefaultPrefix().toLowerCase() + ":" + this.as_dScriptArg();
    }

    public String toString() {
        return this.getId();
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String id = this.getId().toLowerCase();
        if (attribute.startsWith("qty")) {
            return new Element(String.valueOf(this.getItemStack().getAmount())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("id")) {
            return new Element(id).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("typeid")) {
            return new Element(String.valueOf(this.getItemStack().getTypeId())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_stack")) {
            return new Element(String.valueOf(this.getItemStack().getMaxStackSize())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("data")) {
            return new Element(String.valueOf(this.getItemStack().getData().getData())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("durability")) {
            return new Element(String.valueOf(this.getItemStack().getDurability())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("repariable")) {
            return new Element(String.valueOf(this.isRepairable())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material.formatted")) {
            if (id.equals("air")) {
                return new Element("nothing").getAttribute(attribute.fulfill(2));
            }
            if (id.equals("ice") || id.equals("dirt")) {
                return new Element(id).getAttribute(attribute.fulfill(2));
            }
            if (this.getItemStack().getAmount() > 1) {
                if (id.equals("cactus")) {
                    return new Element("cactuses").getAttribute(attribute.fulfill(2));
                }
                if (id.endsWith("y")) {
                    return new Element(id.substring(0, id.length() - 1) + "ies").getAttribute(attribute.fulfill(2));
                }
                if (id.endsWith("s")) {
                    return new Element(id).getAttribute(attribute.fulfill(2));
                }
                return new Element(id + "s").getAttribute(attribute.fulfill(2));
            }
            if (id.equals("cactus")) {
                return new Element("a cactus").getAttribute(attribute.fulfill(2));
            }
            if (id.endsWith("s")) {
                return new Element(id).getAttribute(attribute.fulfill(2));
            }
            if (id.startsWith("a") || id.startsWith("e") || id.startsWith("i") || id.startsWith("o") || id.startsWith("u")) {
                return new Element("an " + id).getAttribute(attribute.fulfill(2));
            }
            return new Element("a " + id).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("material")) {
            return new Element(this.getItemStack().getType().toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("display") && this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasDisplayName()) {
            return new Element(this.getItemStack().getItemMeta().getDisplayName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantments")) {
            // empty if block
        }
        if (attribute.startsWith("lore")) {
            if (this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasLore()) {
                return new dList(this.getItemStack().getItemMeta().getLore()).getAttribute(attribute.fulfill(1));
            }
            return new dList("Empty dList", "").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.dScriptArgValue()).getAttribute(attribute.fulfill(1));
    }
}

