/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class CooldownCommand
extends AbstractCommand {
    public String getHelp() {
        return "Cools down an interact script. While cool, players cannot run the script. When on cooldown, the script will not pass requirements allowing the next lowest priority script to trigger. You can use <script[...].cooled_down[player]> to return whether the script is cooled down, and <script[...].cooldown> to get the duration of the cooldown in progress. Cooldown requiresa type (player or default, a script, and a duration. It also requiresa valid link to a dPlayer.\n \nUse to keep a player from activating a script for a specified duration. \n- cooldown bonus_script 11h \n- cooldown hit_indicator 5s \nUse the 'global' argument to indicate the script to be on cooldown for all players. \n- cooldown global daily_treasure_offering 24h  \n";
    }

    public String getUsage() {
        return "- cooldown ({player}|global) (script_name) [duration]";
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (scriptEntry.hasObject("script") || !arg.matchesArgumentType(dScript.class)) continue;
            scriptEntry.addObject("script", arg.asType(dScript.class));
        }
        if (scriptEntry.hasObject("type") && ((Element)scriptEntry.getObject("type")).identify().equalsIgnoreCase("player") && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException("Requires a type, either ");
        }
        if (!scriptEntry.hasObject("script") || scriptEntry.hasObject("script") && !((dScript)scriptEntry.getObject("script")).isValid()) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_SCRIPT);
        }
        if (!scriptEntry.hasObject("duration") || scriptEntry.hasObject("script") && !((dScript)scriptEntry.getObject("script")).isValid()) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_SCRIPT);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dScript script = (dScript)scriptEntry.getObject("script");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        Element type = scriptEntry.hasObject("type") ? (Element)scriptEntry.getObject("type") : new Element("player");
        dB.report(this.getName(), type.debug() + script.debug() + (type.toString().equalsIgnoreCase("player") ? scriptEntry.getPlayer().debug() : "") + duration.debug());
        Type type_ = Type.valueOf(type.asString().toUpperCase());
        switch (type_) {
            case PLAYER: {
                CooldownCommand.setCooldown(scriptEntry.getPlayer().getName(), duration, script.getName(), false);
            }
            case GLOBAL: {
                CooldownCommand.setCooldown(null, duration, script.getName(), true);
            }
        }
    }

    public static boolean checkCooldown(String playerName, String scriptName) {
        playerName = playerName.toUpperCase();
        scriptName = scriptName.toUpperCase();
        if (DenizenAPI._saves().contains("Global.Scripts." + scriptName + ".Cooldown Time")) {
            if (System.currentTimeMillis() < DenizenAPI._saves().getLong("Global.Scripts." + scriptName + ".Cooldown Time")) {
                return false;
            }
            DenizenAPI._saves().set("Global.Scripts." + scriptName + ".Cooldown Time", null);
        }
        if (!DenizenAPI._saves().contains("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time")) {
            return true;
        }
        if (System.currentTimeMillis() >= DenizenAPI._saves().getLong("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time")) {
            DenizenAPI._saves().set("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time", null);
            return true;
        }
        return false;
    }

    public static void setCooldown(String playerName, Duration duration, String scriptName, boolean global) {
        if (playerName != null) {
            playerName = playerName.toUpperCase();
        }
        scriptName = scriptName.toUpperCase();
        if (global) {
            DenizenAPI._saves().set("Global.Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration.getSecondsAsInt() * 1000)));
        } else {
            DenizenAPI._saves().set("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration.getSecondsAsInt() * 1000)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

