/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.entity.Item;

public class DisplayItemCommand
extends AbstractCommand {
    public static Map<String, Item> displayed = new HashMap<String, Item>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dItem item = null;
        Action action = Action.PLACE;
        Duration duration = null;
        dLocation location = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                duration = aH.getDurationFrom(arg);
                continue;
            }
            if (aH.matchesArg("REMOVE", arg)) {
                action = Action.REMOVE;
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.getItemFrom(arg) != null) {
                item = aH.getItemFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (item == null) {
            throw new InvalidArgumentsException("Must specify an item to display.");
        }
        if (location == null) {
            throw new InvalidArgumentsException(dB.Messages.DEBUG_SET_LOCATION);
        }
        scriptEntry.addObject("item", item).addObject("action", (Object)action).addObject("duration", duration).addObject("location", location);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dItem item = (dItem)scriptEntry.getObject("item");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        dB.report(this.getName(), aH.debugObj("Action", action.toString()) + item.debug() + (duration != null ? duration.debug() : "") + location.debug());
        if (action == Action.PLACE) {
            int ticks = Integer.MAX_VALUE;
            if (duration != null) {
                ticks = duration.getTicksAsInt();
            }
            if (displayed.containsKey(location.identify())) {
                displayed.get(location.identify()).remove();
                displayed.remove(location.identify());
            }
            displayed.put(location.identify(), location.getBlock().getLocation().add(0.0, 1.0, 0.0).getWorld().dropItem((Location)location, item.getItemStack()));
            displayed.get(location.identify()).setPickupDelay(Integer.MAX_VALUE);
            displayed.get(location.identify()).setTicksLived(ticks);
        } else if (action == Action.REMOVE && displayed.containsKey(location.identify())) {
            displayed.get(location.identify()).remove();
            displayed.remove(location.identify());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        PLACE,
        REMOVE;

    }
}

