/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.LivingEntity;

public class AttackCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.START;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("STOP", arg)) {
                action = Action.STOP;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("action", (Object)action);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        dB.report(this.getName(), aH.debugObj("Player", scriptEntry.getPlayer().getName()) + aH.debugObj("Action", action.toString()));
        if (action == Action.STOP) {
            scriptEntry.getNPC().getNavigator().cancelNavigation();
        } else {
            scriptEntry.getNPC().getNavigator().setTarget((LivingEntity)scriptEntry.getPlayer().getPlayerEntity(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        START,
        STOP;

    }
}

