/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.midi;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import net.aufdemrand.denizen.utilities.midi.MidiUtil;
import net.aufdemrand.denizen.utilities.midi.ToneUtil;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteBlockReceiver
implements Receiver {
    private static final float VOLUME_RANGE = 10.0f;
    private final Set<Player> listeners;
    private final Location location;
    private final Map<Integer, Integer> channelPatches;

    public NoteBlockReceiver(Set<Player> listeners) throws InvalidMidiDataException, IOException {
        this.listeners = listeners;
        this.location = null;
        this.channelPatches = Maps.newHashMap();
    }

    public NoteBlockReceiver(Location location) throws InvalidMidiDataException, IOException {
        this.listeners = null;
        this.location = location;
        this.channelPatches = Maps.newHashMap();
    }

    @Override
    public void send(MidiMessage m, long time) {
        if (m instanceof ShortMessage) {
            ShortMessage smessage = (ShortMessage)m;
            int chan = smessage.getChannel();
            switch (smessage.getCommand()) {
                case 192: {
                    int patch = smessage.getData1();
                    this.channelPatches.put(chan, patch);
                    break;
                }
                case 144: {
                    this.playNote(smessage);
                    break;
                }
            }
        }
    }

    public void playNote(ShortMessage message) {
        if (144 != message.getCommand()) {
            return;
        }
        int channel = message.getChannel();
        if (channel == 9) {
            return;
        }
        Integer patch = this.channelPatches.get(channel);
        float pitch = (float)ToneUtil.midiToPitch(message);
        float volume = 10.0f * ((float)message.getData2() / 127.0f);
        Sound instrument = Sound.NOTE_PIANO;
        if (patch != null) {
            instrument = MidiUtil.patchToInstrument(patch);
        }
        if (this.location != null) {
            this.location.getWorld().playSound(this.location, instrument, volume, pitch);
        } else {
            for (Player player : this.listeners) {
                player.playSound(player.getLocation(), instrument, volume, pitch);
            }
        }
    }

    @Override
    public void close() {
        this.listeners.clear();
        this.channelPatches.clear();
    }
}

