/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.events.ScriptFinishEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class FinishCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dScript script = scriptEntry.getScript();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getScriptFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (script == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_SCRIPT);
        }
        scriptEntry.addObject("script", script);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dScript script = (dScript)scriptEntry.getObject("script");
        dB.report(this.getName(), scriptEntry.getPlayer().debug() + script.debug());
        FinishCommand.finishScript(scriptEntry.getPlayer().getName(), script.getName());
    }

    public static void resetFinishes(String playerName, String scriptName) {
        scriptName = scriptName.toUpperCase();
        DenizenAPI._saves().set("Players." + playerName + "." + scriptName + "." + "Completed", null);
    }

    public static boolean finishScript(String playerName, String scriptName) {
        scriptName = scriptName.toUpperCase();
        int finishes = DenizenAPI._saves().getInt("Players." + playerName + "." + scriptName + "." + "Completed", 0);
        DenizenAPI._saves().set("Players." + playerName + "." + scriptName + "." + "Completed", (Object)(++finishes));
        ScriptFinishEvent event = new ScriptFinishEvent(playerName, scriptName, finishes);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return true;
    }

    public static int getScriptCompletes(String playerName, String scriptName) {
        return DenizenAPI.getCurrentInstance().getSaves().getInt("Players." + playerName + "." + scriptName.toUpperCase() + "." + "Completed", 0);
    }
}

