/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ZapCommand
extends AbstractCommand
implements Listener {
    private static Map<String, Integer> durations = new ConcurrentHashMap<String, Integer>(8, 0.9f, 1);

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dScript script = scriptEntry.getScript();
        String step = null;
        Duration duration = new Duration(-1.0);
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getScriptFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("STEP", arg, aH.ArgumentType.String) || aH.matchesInteger(arg)) {
                step = aH.getStringFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_STEP, step);
                continue;
            }
            if (aH.matchesDuration(arg)) {
                duration = aH.getDurationFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("script", script).addObject("step", step).addObject("duration", duration);
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        final dScript script = (dScript)scriptEntry.getObject("script");
        String step = (String)scriptEntry.getObject("step");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        String currentStep = InteractScriptHelper.getCurrentStep(scriptEntry.getPlayer(), script.getName());
        if (step == null) {
            step = aH.matchesInteger(currentStep) ? String.valueOf(aH.getIntegerFrom(currentStep) + 1) : "1";
        }
        if (durations.containsKey(scriptEntry.getPlayer().getName() + "," + script.getName())) {
            try {
                this.denizen.getServer().getScheduler().cancelTask(durations.get(scriptEntry.getPlayer().getName() + "," + script.getName()).intValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (duration.getSeconds() > 0.0) {
            scriptEntry.addObject("step", currentStep);
            scriptEntry.addObject("duration", new Duration(-1.0));
            long delay = (long)(duration.getSeconds() * 20.0);
            dB.echoDebug(dB.Messages.DEBUG_SETTING_DELAYED_TASK, "RESET ZAP for '" + script + "'");
            durations.put(scriptEntry.getPlayer().getName() + "," + script.getName(), this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, new Runnable(){

                public void run() {
                    block2: {
                        dB.log(dB.Messages.DEBUG_RUNNING_DELAYED_TASK, "RESET ZAP for '" + script.getName() + "'");
                        try {
                            durations.remove(scriptEntry.getPlayer().getName() + "," + script.getName().toUpperCase());
                            ZapCommand.this.execute(scriptEntry);
                        }
                        catch (CommandExecutionException e) {
                            dB.echoError("Could not run delayed task!");
                            if (!dB.showStackTraces) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            }, delay));
        }
        this.denizen.getSaves().set("Players." + scriptEntry.getPlayer().getName() + ".Scripts." + script.getName().toUpperCase() + "." + "Current Step", (Object)step);
    }
}

