/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.core.ItemListenerType;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.WorldGuardUtilities;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListenerInstance
extends AbstractListener
implements Listener {
    ItemListenerType.ItemType type = null;
    List<String> items = new ArrayList<String>();
    int quantity = 0;
    int currentItems = 0;
    Server server = Bukkit.getServer();
    String region = null;

    @Override
    public void onBuild(List<String> args) {
        for (String arg : args) {
            if (aH.matchesValueArg("TYPE", arg, aH.ArgumentType.Custom)) {
                try {
                    this.type = ItemListenerType.ItemType.valueOf(aH.getStringFrom(arg).toUpperCase());
                    dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, this.type.name());
                }
                catch (Exception e) {
                    dB.echoError("Invalid ItemType!");
                }
                continue;
            }
            if (aH.matchesQuantity(arg)) {
                this.quantity = aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(this.quantity));
                continue;
            }
            if (aH.matchesValueArg("ITEMS, ITEM", arg, aH.ArgumentType.Custom)) {
                for (String thisItem : aH.getListFrom(arg.toUpperCase())) {
                    if (this.server.getRecipesFor(new ItemStack(Material.matchMaterial((String)thisItem))) != null) {
                        this.items.add(thisItem);
                        continue;
                    }
                    dB.echoError("..." + thisItem + " is not a craftable item");
                }
                dB.echoDebug("...set ITEMS.: " + Arrays.toString(this.items.toArray()));
                continue;
            }
            if (!aH.matchesValueArg("REGION", arg, aH.ArgumentType.String)) continue;
            this.region = aH.getStringFrom(arg);
            dB.echoDebug("...region set: " + this.region);
        }
        if (this.items.isEmpty() && !this.type.name().equalsIgnoreCase("FISH")) {
            dB.echoError("Missing ITEMS argument!");
            this.cancel();
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: CRAFT, SMELT, FISH");
            this.cancel();
        }
    }

    public void increment(String object, int amount) {
        this.currentItems += amount;
        dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " " + this.type.toString().toLowerCase() + "ed " + amount + " " + object + ".");
        this.check();
    }

    @EventHandler
    public void listenItem(InventoryClickEvent event) {
        if (event.getSlotType().toString() == "RESULT" && event.getWhoClicked() == this.player.getPlayerEntity()) {
            String inventoryType = event.getInventory().getType().toString();
            if (this.type == ItemListenerType.ItemType.CRAFT && (inventoryType == "CRAFTING" || inventoryType == "WORKBENCH") || this.type == ItemListenerType.ItemType.SMELT && inventoryType == "FURNACE") {
                if (this.region != null && !WorldGuardUtilities.inRegion(this.player.getPlayerEntity().getLocation(), this.region)) {
                    return;
                }
                final ItemStack item = new ItemStack(event.getCurrentItem());
                if (!this.items.contains(item.getType().toString()) && !this.items.contains(item.getTypeId())) {
                    return;
                }
                if (event.isShiftClick()) {
                    final int initialQty = new dInventory((Inventory)this.player.getPlayerEntity().getInventory()).count(item, false);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                        public void run() {
                            int newQty = new dInventory((Inventory)ItemListenerInstance.this.player.getPlayerEntity().getInventory()).count(item, false);
                            int difference = newQty - initialQty;
                            if (difference > 0) {
                                ItemListenerInstance.this.increment(item.getType().toString(), difference);
                            }
                        }
                    }, 1L);
                } else {
                    this.increment(item.getType().toString(), item.getAmount());
                }
            }
        }
    }

    @EventHandler
    public void listenFish(PlayerFishEvent event) {
        if (this.type == ItemListenerType.ItemType.FISH && event.getPlayer() == this.player.getPlayerEntity()) {
            if (this.region != null && !WorldGuardUtilities.inRegion(this.player.getPlayerEntity().getLocation(), this.region)) {
                return;
            }
            if (event.getState().toString() == "CAUGHT_FISH") {
                this.increment("FISH", 1);
            }
        }
    }

    @Override
    public void onSave() {
        try {
            this.store("Type", this.type.name());
            this.store("Items", this.items);
            this.store("Quantity Needed", this.quantity);
            this.store("Quantity Done", this.currentItems);
            this.store("Region", this.region);
        }
        catch (Exception e) {
            dB.echoError("Unable to save ITEM listener for '%s'!", this.player.getName());
        }
    }

    @Override
    public void onLoad() {
        try {
            this.type = ItemListenerType.ItemType.valueOf((String)this.get("Type"));
            this.items = (List)this.get("Items");
            this.quantity = (Integer)this.get("Quantity Needed");
            this.currentItems = (Integer)this.get("Quantity Done");
            this.region = (String)this.get("Region");
        }
        catch (Exception e) {
            dB.echoError("Unable to load ITEM listener for '%s'!", this.player.getName());
            this.cancel();
        }
    }

    @Override
    public void onFinish() {
    }

    public void check() {
        if (this.currentItems >= this.quantity) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            PlayerFishEvent.getHandlerList().unregister((Listener)this);
            this.finish();
        }
    }

    @Override
    public void onCancel() {
    }

    @Override
    public String report() {
        return this.player.getName() + " current has quest listener '" + this.listenerId + "' active and must " + this.type.name() + " " + Arrays.toString(this.items.toArray()) + " '(s). Current progress '" + this.currentItems + "/" + this.quantity + "'.";
    }

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
    }
}

