/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEntry {
    private String command;
    private long creationTime;
    private boolean instant = false;
    private boolean waitfor = false;
    private boolean done = false;
    private dPlayer player = null;
    private dNPC npc = null;
    private dScript script = null;
    private ScriptQueue queue = null;
    private List<String> args = null;
    private Map<String, Object> objects = new HashMap<String, Object>();
    public boolean has_tags = false;
    public List<String> tracked_objects = new ArrayList<String>();

    public ScriptEntry(String command, String[] arguments, ScriptContainer script) throws ScriptEntryCreationException {
        if (command == null) {
            throw new ScriptEntryCreationException("dCommand 'type' cannot be null!");
        }
        this.command = command.toUpperCase();
        if (script != null) {
            this.script = script.getAsScriptArg();
        }
        this.creationTime = System.currentTimeMillis();
        if (command.startsWith("^")) {
            this.instant = true;
            this.command = command.substring(1);
        } else if (command.startsWith("~")) {
            this.waitfor = true;
            this.command = command.substring(1);
        }
        this.args = new ArrayList<String>();
        if (arguments != null) {
            this.args = Arrays.asList(arguments);
        }
        for (String arg : this.args) {
            if (!arg.contains("<") || !arg.contains(">")) continue;
            this.has_tags = true;
            break;
        }
    }

    public ScriptEntry addObject(String key, Object object) {
        if (object == null) {
            return this;
        }
        if (object instanceof dObject) {
            ((dObject)object).setPrefix(key);
        }
        this.objects.put(key.toUpperCase(), object);
        return this;
    }

    public ScriptEntry defaultObject(String key, Object ... objects) {
        if (!this.hasObject(key)) {
            for (Object obj : objects) {
                if (obj == null) continue;
                this.addObject(key, obj);
                break;
            }
        }
        return this;
    }

    public List<String> getArguments() {
        return this.args;
    }

    public String getCommandName() {
        return this.command;
    }

    public dNPC getNPC() {
        return this.npc;
    }

    public boolean hasNPC() {
        return this.npc != null;
    }

    public void setFinished(boolean finished) {
        this.done = finished;
    }

    public dPlayer getPlayer() {
        return this.player;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public Object getObject(String key) {
        try {
            return this.objects.get(key.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public dObject getdObject(String key) {
        try {
            return (dObject)this.objects.get(key.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Element getElement(String key) {
        try {
            return (Element)this.objects.get(key.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasObject(String key) {
        return this.objects.containsKey(key.toUpperCase()) && this.objects.get(key.toUpperCase()) != null;
    }

    public dScript getScript() {
        return this.script;
    }

    public ScriptQueue getResidingQueue() {
        return this.queue;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public boolean shouldWaitFor() {
        return this.waitfor;
    }

    public boolean isDone() {
        return this.done;
    }

    public ScriptEntry setArguments(List<String> arguments) {
        this.args = arguments;
        return this;
    }

    public ScriptEntry setInstant(boolean instant) {
        this.instant = instant;
        return this;
    }

    public ScriptEntry setPlayer(dPlayer player) {
        this.player = player;
        return this;
    }

    public ScriptEntry setNPC(dNPC dNPC2) {
        this.npc = dNPC2;
        return this;
    }

    public ScriptEntry setScript(String scriptName) {
        this.script = dScript.valueOf(scriptName);
        return this;
    }

    public void setSendingQueue(ScriptQueue scriptQueue) {
        this.queue = scriptQueue;
    }

    public ScriptEntry trackObject(String key) {
        this.tracked_objects.add(key.toUpperCase());
        return this;
    }

    public void setCommandName(String commandName) {
        this.command = commandName;
    }
}

