/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ScriptEntryExecuteEvent;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class CommandExecuter {
    private Denizen plugin;
    final Pattern definition_pattern = Pattern.compile("%(.+?)%");

    public CommandExecuter(Denizen denizen) {
        this.plugin = denizen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execute(ScriptEntry scriptEntry) {
        block42: {
            Matcher m = this.definition_pattern.matcher(scriptEntry.getCommandName());
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                if (scriptEntry.getResidingQueue().hasContext(m.group(1).toLowerCase())) {
                    m.appendReplacement(sb, scriptEntry.getResidingQueue().getContext(m.group(1).toLowerCase()));
                    continue;
                }
                m.appendReplacement(sb, "null");
            }
            m.appendTail(sb);
            scriptEntry.setCommandName(sb.toString());
            if (this.plugin.getCommandRegistry().get(scriptEntry.getCommandName()) == null) {
                dB.echoDebug(dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommandName());
                dB.echoError(scriptEntry.getCommandName() + " is an invalid dCommand! Are you sure it loaded?");
                dB.echoDebug(dB.DebugElement.Footer);
                return false;
            }
            AbstractCommand command = this.plugin.getCommandRegistry().get(scriptEntry.getCommandName());
            if (scriptEntry.getPlayer() != null) {
                dB.echoDebug(dB.DebugElement.Header, "Executing dCommand: " + scriptEntry.getCommandName() + "/" + scriptEntry.getPlayer().getName());
            } else {
                dB.echoDebug(dB.DebugElement.Header, "Executing dCommand: " + scriptEntry.getCommandName() + (scriptEntry.getNPC() != null ? "/" + scriptEntry.getNPC().getName() : ""));
            }
            boolean keepGoing = true;
            if (command.getOptions().REQUIRED_ARGS > scriptEntry.getArguments().size()) {
                throw new InvalidArgumentsException("");
            }
            if (scriptEntry.has_tags) {
                scriptEntry.setArguments(TagManager.fillArguments(scriptEntry.getArguments(), scriptEntry, true));
            }
            ArrayList<String> newArgs = new ArrayList<String>();
            int nested_depth = 0;
            for (String arg : scriptEntry.getArguments()) {
                if (arg.equals("{")) {
                    ++nested_depth;
                }
                if (arg.equals("}")) {
                    --nested_depth;
                }
                if (nested_depth > 0) {
                    newArgs.add(arg);
                    continue;
                }
                m = this.definition_pattern.matcher(arg);
                sb = new StringBuffer();
                while (m.find()) {
                    if (scriptEntry.getResidingQueue().hasContext(m.group(1).toLowerCase())) {
                        m.appendReplacement(sb, scriptEntry.getResidingQueue().getContext(m.group(1).toLowerCase()));
                        continue;
                    }
                    m.appendReplacement(sb, "null");
                }
                m.appendTail(sb);
                arg = sb.toString();
                if (aH.matchesValueArg("player", arg, aH.ArgumentType.String)) {
                    arg = TagManager.tag(scriptEntry.getPlayer(), scriptEntry.getNPC(), arg, false);
                    scriptEntry.setPlayer(dPlayer.valueOf(aH.getStringFrom(arg)));
                    continue;
                }
                if (aH.matchesValueArg("npcid, npc", arg, aH.ArgumentType.String)) {
                    dB.echoDebug("...replacing the linked NPC.");
                    arg = TagManager.tag(scriptEntry.getPlayer(), scriptEntry.getNPC(), arg, false);
                    if (!dNPC.matches(aH.getStringFrom(arg))) continue;
                    scriptEntry.setNPC(dNPC.valueOf(aH.getStringFrom(arg)));
                    continue;
                }
                newArgs.add(arg);
            }
            scriptEntry.setArguments(newArgs);
            if (scriptEntry.has_tags) {
                scriptEntry.setArguments(TagManager.fillArguments(scriptEntry.getArguments(), scriptEntry, false));
            }
            command.parseArgs(scriptEntry);
            Object var11_12 = null;
            if (!keepGoing) break block42;
            try {
                ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isAltered()) {
                    scriptEntry = event.getScriptEntry();
                }
                if (!event.isCancelled()) {
                    command.execute(scriptEntry);
                    break block42;
                }
                dB.echoDebug("ScriptEntry has been cancelled.");
            }
            catch (Exception e2) {
                dB.echoError("Woah!! An exception has been called with this command!");
                if (!dB.showStackTraces) {
                    dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                    break block42;
                }
                e2.printStackTrace();
            }
            break block42;
            {
                catch (InvalidArgumentsException e) {
                    keepGoing = false;
                    dB.echoError("Woah! Invalid arguments were specified!");
                    dB.echoDebug(ChatColor.YELLOW + "+> MESSAGE follows: " + ChatColor.WHITE + "'" + e.getMessage() + "'");
                    dB.echoDebug("Usage: " + command.getUsageHint());
                    dB.echoDebug(dB.DebugElement.Footer);
                    Object var11_13 = null;
                    if (!keepGoing) break block42;
                    try {
                        ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                        Bukkit.getServer().getPluginManager().callEvent((Event)event);
                        if (event.isAltered()) {
                            scriptEntry = event.getScriptEntry();
                        }
                        if (!event.isCancelled()) {
                            command.execute(scriptEntry);
                            break block42;
                        }
                        dB.echoDebug("ScriptEntry has been cancelled.");
                    }
                    catch (Exception e2) {
                        dB.echoError("Woah!! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            break block42;
                        }
                        e2.printStackTrace();
                    }
                    break block42;
                }
                catch (Exception e) {
                    keepGoing = false;
                    dB.echoError("Woah! An exception has been called with this command!");
                    if (!dB.showStackTraces) {
                        dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                    } else {
                        e.printStackTrace();
                    }
                    dB.echoDebug(dB.DebugElement.Footer);
                    Object var11_14 = null;
                    if (!keepGoing) break block42;
                    try {
                        ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                        Bukkit.getServer().getPluginManager().callEvent((Event)event);
                        if (event.isAltered()) {
                            scriptEntry = event.getScriptEntry();
                        }
                        if (!event.isCancelled()) {
                            command.execute(scriptEntry);
                            break block42;
                        }
                        dB.echoDebug("ScriptEntry has been cancelled.");
                    }
                    catch (Exception e2) {
                        dB.echoError("Woah!! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            break block42;
                        }
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                block43: {
                    Object var11_15 = null;
                    if (keepGoing) {
                        try {
                            ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                            Bukkit.getServer().getPluginManager().callEvent((Event)event);
                            if (event.isAltered()) {
                                scriptEntry = event.getScriptEntry();
                            }
                            if (!event.isCancelled()) {
                                command.execute(scriptEntry);
                            } else {
                                dB.echoDebug("ScriptEntry has been cancelled.");
                            }
                        }
                        catch (Exception e2) {
                            dB.echoError("Woah!! An exception has been called with this command!");
                            if (!dB.showStackTraces) {
                                dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                                break block43;
                            }
                            e2.printStackTrace();
                        }
                    }
                }
                throw throwable;
            }
        }
        return true;
    }
}

